/*!
 * Animation Bus 0.2.0
 * https://github.com/souporserious/animation-bus
 * Copyright (c) 2016 Animation Bus Authors
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["AnimationBus"] = factory();
	else
		root["AnimationBus"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "dist/";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _polylinearScale = __webpack_require__(1);

	var _polylinearScale2 = _interopRequireDefault(_polylinearScale);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	var transformUnits = {
	  perspective: 'px',
	  rotate: 'deg',
	  rotateX: 'deg',
	  rotateY: 'deg',
	  rotateZ: 'deg',
	  scale: '',
	  scaleX: '',
	  scaleY: '',
	  scaleZ: '',
	  skew: 'deg',
	  skewX: 'deg',
	  skewY: 'deg',
	  translateX: 'px',
	  translateY: 'px',
	  translateZ: 'px'
	};
	var transformKeys = Object.keys(transformUnits);

	var AnimationBus = function () {
	  function AnimationBus(_ref) {
	    var animations = _ref.animations,
	        element = _ref.element,
	        origin = _ref.origin;

	    _classCallCheck(this, AnimationBus);

	    this.animations = animations;
	    this.element = element;
	    this.origin = origin;
	  }

	  _createClass(AnimationBus, [{
	    key: 'getStyles',
	    value: function getStyles() {
	      var element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.element;

	      var origin = this.origin(element);
	      var transformValues = [];
	      var styles = {};

	      this.animations.forEach(function (animation) {
	        var prop = animation.prop;
	        var unit = animation.unit || transformUnits[prop] || '';
	        var value = (0, _polylinearScale2.default)(animation.stops)(origin);

	        if (transformKeys.indexOf(prop) > -1) {
	          transformValues.push(prop + '(' + value + unit + ')');
	        } else {
	          styles[prop] = '' + value + unit;
	        }
	      });

	      if (transformValues.length) {
	        styles.transform = transformValues.join(' ');
	      }

	      return styles;
	    }
	  }, {
	    key: 'applyStyles',
	    value: function applyStyles() {
	      var element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.element;

	      var styles = this.getStyles(element);
	      Object.keys(styles).forEach(function (key) {
	        return element.style[key] = styles[key];
	      });
	    }
	  }]);

	  return AnimationBus;
	}();

	exports.default = AnimationBus;
	module.exports = exports['default'];

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

	exports.default = polylinearScale;

	var _piecewise = __webpack_require__(2);

	var _piecewise2 = _interopRequireDefault(_piecewise);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function polylinearScale(stops) {
	  var xs = [];
	  var ys_r = [];
	  var ys_g = [];
	  var ys_b = [];

	  stops.forEach(function (_ref) {
	    var _ref2 = _slicedToArray(_ref, 2),
	        domain = _ref2[0],
	        range = _ref2[1];

	    xs.push(domain);
	    if (isNaN(range)) {
	      ys_r.push(parseInt(range.substr(1, 2), 16));
	      ys_g.push(parseInt(range.substr(3, 2), 16));
	      ys_b.push(parseInt(range.substr(5, 2), 16));
	    } else {
	      ys_r.push(range);
	    }
	  });

	  var pw_r = (0, _piecewise2.default)(xs, ys_r);

	  if (ys_g.length && ys_b.length) {
	    var _ret = function () {
	      var pw_g = (0, _piecewise2.default)(xs, ys_g);
	      var pw_b = (0, _piecewise2.default)(xs, ys_b);
	      return {
	        v: function v(x) {
	          return 'rgb(' + Math.round(pw_r(x)) + ', ' + Math.round(pw_g(x)) + ', ' + Math.round(pw_b(x)) + ')';
	        }
	      };
	    }();

	    if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
	  } else {
	    return function (x) {
	      return pw_r(x);
	    };
	  }
	}
	module.exports = exports['default'];

/***/ },
/* 2 */
/***/ function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = piecewise;
	function piecewise(xs, ys) {
	  return function (x) {
	    // out of bounds
	    if (x <= xs[0]) {
	      return ys[0];
	    } else if (x >= xs[xs.length - 1]) {
	      return ys[xs.length - 1];
	    }

	    // bisect
	    var lo = 0;
	    var hi = xs.length - 1;

	    while (hi - lo > 1) {
	      var mid = lo + hi >> 1;
	      if (x < xs[mid]) {
	        hi = mid;
	      } else {
	        lo = mid;
	      }
	    }

	    // project
	    return ys[lo] + (ys[hi] - ys[lo]) / (xs[hi] - xs[lo]) * (x - xs[lo]);
	  };
	}
	module.exports = exports["default"];

/***/ }
/******/ ])
});
;