set nocompatible
let &rtp = '../..,' . &rtp
filetype plugin on

set nomore

let g:vimtex_view_automatic = 0
let g:vimtex_log_verbose = 0

function! RunTests(comp, list_opts)
  if !executable(a:comp)
    echo 'Warning! "' . a:comp . '" was not executable!'
    echo "Compiler tests could not run!\n\n"
    cquit
  endif

  let g:vimtex_compiler_method = a:comp

  for l:opts in a:list_opts
    let g:vimtex_compiler_{a:comp} = l:opts

    " Ensure there is no latexmk process before we start the test
    if a:comp ==# 'latexmk'
      call system('pkill -f latexmk')
    endif

    echo 'Testing compiler "' . a:comp . '"'
    if !empty(l:opts)
      echon ' with options:'
      for [l:key, l:val] in items(l:opts)
        echo '* ' . l:key . ' =' l:val . "\n"
      endfor
    endif

    for l:file in glob('minimal.*', 1, 1)
      call delete(l:file)
    endfor
    call writefile([
          \ '\documentclass{minimal}',
          \ '\begin{document}',
          \ 'Hello World!',
          \ '\end{document}',
          \], 'minimal.tex')

    silent edit minimal.tex

    " Check if the compiler was loaded
    if !has_key(b:vimtex, 'compiler')
      echo "Compiler failed to load!\n"
      cquit
    endif

    silent call vimtex#compiler#compile()
    sleep 650m

    " Check if continuous mode is active
    if get(b:vimtex.compiler, 'continuous')
      if !b:vimtex.compiler.get_pid()
        echo "Could not get PID for compiler\n"
        cquit
      endif

      silent call vimtex#compiler#stop()
    else
      sleep 450m
    endif

    " Check that the PDF has been built
    if empty(b:vimtex.compiler.get_file('pdf'))
      echo "PDF was not built properly\n"
      cquit
    endif

    silent call vimtex#compiler#clean(1)
    sleep 650m

    if !empty(b:vimtex.compiler.get_file('pdf'))
          \ || !empty(b:vimtex.compiler.get_file('aux'))
      echo "VimtexClean failed!\n"
      cquit
    endif

    if !empty(get(l:opts, 'build_dir', ''))
      call delete(l:opts.build_dir, 'rf')
    endif

    echo "\n"
    bwipeout
  endfor
endfunction

for [s:comp, s:opts] in items({
      \ 'latexmk' : [
      \   {},
      \   {'build_dir' : 'out'},
      \   {'callback' : 0},
      \   {'callback' : 0, 'continuous' : 0},
      \   {'continuous' : 0},
      \ ],
      \ 'latexrun' : [
      \   {},
      \   {'build_dir' : 'out'},
      \ ],
      \})
  call RunTests(s:comp, s:opts)
endfor

quitall!
