/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.xml.sax.helpers.SecuritySupport;

class SecuritySupport12
extends SecuritySupport {
    SecuritySupport12() {
    }

    public ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(this){
            private final SecuritySupport12 this$0;
            {
                this.this$0 = securitySupport12;
            }

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    public String getSystemProperty(String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(this, string){
            private final String val$propName;
            private final SecuritySupport12 this$0;
            {
                this.this$0 = securitySupport12;
                this.val$propName = string;
            }

            public Object run() {
                return System.getProperty(this.val$propName);
            }
        });
    }

    public FileInputStream getFileInputStream(File file) {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(this, file){
                private final File val$file;
                private final SecuritySupport12 this$0;
                {
                    this.this$0 = securitySupport12;
                    this.val$file = file;
                }

                public Object run() {
                    return new FileInputStream(this.val$file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    public InputStream getResourceAsStream(ClassLoader classLoader, String string) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(this, classLoader, string){
            private final ClassLoader val$cl;
            private final String val$name;
            private final SecuritySupport12 this$0;
            {
                this.this$0 = securitySupport12;
                this.val$cl = classLoader;
                this.val$name = string;
            }

            public Object run() {
                InputStream inputStream = this.val$cl == null ? ClassLoader.getSystemResourceAsStream(this.val$name) : this.val$cl.getResourceAsStream(this.val$name);
                return inputStream;
            }
        });
    }
}

