/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.sqlite.ExtendedCommand;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class JDBC3Statement
extends CoreStatement {
    protected JDBC3Statement(SQLiteConnection sQLiteConnection) {
        super(sQLiteConnection);
    }

    public void close() {
        this.internalClose();
    }

    protected void finalize() {
        this.close();
    }

    public boolean execute(String string) {
        this.internalClose();
        ExtendedCommand.SQLExtension sQLExtension = ExtendedCommand.parse(string);
        if (sQLExtension != null) {
            sQLExtension.execute(this.conn.getDatabase());
            return false;
        }
        this.sql = string;
        this.conn.getDatabase().prepare(this);
        return this.exec();
    }

    @Override
    public ResultSet executeQuery(String string, boolean bl2) {
        this.rs.closeStmt = bl2;
        return this.executeQuery(string);
    }

    public ResultSet executeQuery(String string) {
        this.internalClose();
        this.sql = string;
        this.conn.getDatabase().prepare(this);
        if (!this.exec()) {
            this.internalClose();
            throw new SQLException("query does not return ResultSet", "SQLITE_DONE", 101);
        }
        return this.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) {
        this.internalClose();
        this.sql = string;
        DB dB2 = this.conn.getDatabase();
        int n2 = 0;
        ExtendedCommand.SQLExtension sQLExtension = ExtendedCommand.parse(string);
        if (sQLExtension != null) {
            sQLExtension.execute(dB2);
        } else {
            try {
                n2 = dB2.total_changes();
                int n3 = dB2._exec(string);
                if (n3 != 0) {
                    throw DB.newSQLException(n3, "");
                }
                n2 = dB2.total_changes() - n2;
            }
            finally {
                this.internalClose();
            }
        }
        return n2;
    }

    public ResultSet getResultSet() {
        this.checkOpen();
        if (this.rs.isOpen()) {
            throw new SQLException("ResultSet already requested");
        }
        DB dB2 = this.conn.getDatabase();
        if (dB2.column_count(this.pointer) == 0) {
            return null;
        }
        if (this.rs.colsMeta == null) {
            this.rs.colsMeta = dB2.column_names(this.pointer);
        }
        this.rs.cols = this.rs.colsMeta;
        this.rs.open = this.resultsWaiting;
        this.resultsWaiting = false;
        return (ResultSet)((Object)this.rs);
    }

    public int getUpdateCount() {
        DB dB2 = this.conn.getDatabase();
        if (this.pointer != 0L && !this.rs.isOpen() && !this.resultsWaiting && dB2.column_count(this.pointer) == 0) {
            return dB2.changes();
        }
        return -1;
    }

    public void addBatch(String string) {
        this.internalClose();
        if (this.batch == null || this.batchPos + 1 >= this.batch.length) {
            Object[] objectArray = new Object[Math.max(10, this.batchPos * 2)];
            if (this.batch != null) {
                System.arraycopy(this.batch, 0, objectArray, 0, this.batch.length);
            }
            this.batch = objectArray;
        }
        this.batch[this.batchPos++] = string;
    }

    public void clearBatch() {
        this.batchPos = 0;
        if (this.batch != null) {
            for (int i2 = 0; i2 < this.batch.length; ++i2) {
                this.batch[i2] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() {
        DB dB2;
        this.internalClose();
        if (this.batch == null || this.batchPos == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.batchPos];
        DB dB3 = dB2 = this.conn.getDatabase();
        synchronized (dB3) {
            try {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    try {
                        this.sql = (String)this.batch[i2];
                        dB2.prepare(this);
                        nArray[i2] = dB2.executeUpdate(this, null);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        throw new BatchUpdateException("batch entry " + i2 + ": " + sQLException.getMessage(), nArray);
                    }
                    finally {
                        dB2.finalize(this);
                    }
                }
            }
            finally {
                this.clearBatch();
            }
        }
        return nArray;
    }

    public void setCursorName(String string) {
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void cancel() {
        this.conn.getDatabase().interrupt();
    }

    public int getQueryTimeout() {
        return this.conn.getBusyTimeout();
    }

    public void setQueryTimeout(int n2) {
        if (n2 < 0) {
            throw new SQLException("query timeout must be >= 0");
        }
        this.conn.setBusyTimeout(1000 * n2);
    }

    public int getMaxRows() {
        return this.rs.maxRows;
    }

    public void setMaxRows(int n2) {
        if (n2 < 0) {
            throw new SQLException("max row count must be >= 0");
        }
        this.rs.maxRows = n2;
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public void setMaxFieldSize(int n2) {
        if (n2 < 0) {
            throw new SQLException("max field size " + n2 + " cannot be negative");
        }
    }

    public int getFetchSize() {
        return ((ResultSet)((Object)this.rs)).getFetchSize();
    }

    public void setFetchSize(int n2) {
        ((ResultSet)((Object)this.rs)).setFetchSize(n2);
    }

    public int getFetchDirection() {
        return ((ResultSet)((Object)this.rs)).getFetchDirection();
    }

    public void setFetchDirection(int n2) {
        ((ResultSet)((Object)this.rs)).setFetchDirection(n2);
    }

    public ResultSet getGeneratedKeys() {
        return this.conn.getSQLiteDatabaseMetaData().getGeneratedKeys();
    }

    public boolean getMoreResults() {
        return this.getMoreResults(0);
    }

    public boolean getMoreResults(int n2) {
        this.checkOpen();
        this.internalClose();
        return false;
    }

    public int getResultSetConcurrency() {
        return 1007;
    }

    public int getResultSetHoldability() {
        return 2;
    }

    public int getResultSetType() {
        return 1003;
    }

    public void setEscapeProcessing(boolean bl2) {
        if (bl2) {
            throw this.unused();
        }
    }

    protected SQLException unused() {
        return new SQLException("not implemented by SQLite JDBC driver");
    }

    public boolean execute(String string, int[] nArray) {
        throw this.unused();
    }

    public boolean execute(String string, String[] stringArray) {
        throw this.unused();
    }

    public int executeUpdate(String string, int n2) {
        throw this.unused();
    }

    public int executeUpdate(String string, int[] nArray) {
        throw this.unused();
    }

    public int executeUpdate(String string, String[] stringArray) {
        throw this.unused();
    }

    public boolean execute(String string, int n2) {
        throw this.unused();
    }

    static class BackupObserver
    implements DB.ProgressObserver {
        BackupObserver() {
        }

        @Override
        public void progress(int n2, int n3) {
            System.out.println(String.format("remaining:%d, page count:%d", n2, n3));
        }
    }
}

