/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CorePreparedStatement;

public abstract class JDBC3PreparedStatement
extends CorePreparedStatement {
    protected JDBC3PreparedStatement(SQLiteConnection sQLiteConnection, String string) {
        super(sQLiteConnection, string);
    }

    public void clearParameters() {
        this.checkOpen();
        this.conn.getDatabase().clear_bindings(this.pointer);
        this.paramValid.clear();
        if (this.batch != null) {
            for (int i2 = this.batchPos; i2 < this.batchPos + this.paramCount; ++i2) {
                this.batch[i2] = null;
            }
        }
    }

    public boolean execute() {
        this.checkOpen();
        this.rs.close();
        this.conn.getDatabase().reset(this.pointer);
        this.checkParameters();
        boolean bl2 = false;
        try {
            this.resultsWaiting = this.conn.getDatabase().execute(this, this.batch);
            bl2 = true;
            boolean bl3 = this.columnCount != 0;
            return bl3;
        }
        finally {
            if (!bl2 && this.pointer != 0L) {
                this.conn.getDatabase().reset(this.pointer);
            }
        }
    }

    public ResultSet executeQuery() {
        this.checkOpen();
        if (this.columnCount == 0) {
            throw new SQLException("Query does not return results");
        }
        this.rs.close();
        this.conn.getDatabase().reset(this.pointer);
        this.checkParameters();
        boolean bl2 = false;
        try {
            this.resultsWaiting = this.conn.getDatabase().execute(this, this.batch);
            bl2 = true;
        }
        finally {
            if (!bl2 && this.pointer != 0L) {
                this.conn.getDatabase().reset(this.pointer);
            }
        }
        return this.getResultSet();
    }

    public int executeUpdate() {
        this.checkOpen();
        if (this.columnCount != 0) {
            throw new SQLException("Query returns results");
        }
        this.rs.close();
        this.conn.getDatabase().reset(this.pointer);
        this.checkParameters();
        return this.conn.getDatabase().executeUpdate(this, this.batch);
    }

    public void addBatch() {
        this.checkOpen();
        this.checkParameters();
        this.batchPos += this.paramCount;
        ++this.batchQueryCount;
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
            this.paramValid.clear();
        }
        if (this.batchPos + this.paramCount > this.batch.length) {
            Object[] objectArray = new Object[this.batch.length * 2];
            System.arraycopy(this.batch, 0, objectArray, 0, this.batch.length);
            this.batch = objectArray;
        }
        System.arraycopy(this.batch, this.batchPos - this.paramCount, this.batch, this.batchPos, this.paramCount);
    }

    public ParameterMetaData getParameterMetaData() {
        return (ParameterMetaData)((Object)this);
    }

    public int getParameterCount() {
        this.checkOpen();
        return this.paramCount;
    }

    public String getParameterClassName(int n2) {
        this.checkOpen();
        return "java.lang.String";
    }

    public String getParameterTypeName(int n2) {
        return "VARCHAR";
    }

    public int getParameterType(int n2) {
        return 12;
    }

    public int getParameterMode(int n2) {
        return 1;
    }

    public int getPrecision(int n2) {
        return 0;
    }

    public int getScale(int n2) {
        return 0;
    }

    public int isNullable(int n2) {
        return 1;
    }

    public boolean isSigned(int n2) {
        return true;
    }

    public Statement getStatement() {
        return this;
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) {
        this.batch(n2, bigDecimal == null ? null : bigDecimal.toString());
    }

    private byte[] readBytes(InputStream inputStream, int n2) {
        if (n2 < 0) {
            SQLException sQLException = new SQLException("Error reading stream. Length should be non-negative");
            throw sQLException;
        }
        byte[] byArray = new byte[n2];
        try {
            int n3;
            for (int i2 = 0; i2 < n2; i2 += n3) {
                n3 = inputStream.read(byArray, i2, n2 - i2);
                if (n3 != -1) continue;
                throw new IOException("End of stream has been reached");
            }
            return byArray;
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException("Error reading stream");
            sQLException.initCause(iOException);
            throw sQLException;
        }
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) {
        if (inputStream == null && n3 == 0) {
            this.setBytes(n2, null);
        }
        this.setBytes(n2, this.readBytes(inputStream, n3));
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) {
        this.setUnicodeStream(n2, inputStream, n3);
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) {
        if (inputStream == null && n3 == 0) {
            this.setString(n2, null);
        }
        try {
            this.setString(n2, new String(this.readBytes(inputStream, n3), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException("UTF-8 is not supported");
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    public void setBoolean(int n2, boolean bl2) {
        this.setInt(n2, bl2 ? 1 : 0);
    }

    public void setByte(int n2, byte by2) {
        this.setInt(n2, by2);
    }

    public void setBytes(int n2, byte[] byArray) {
        this.batch(n2, byArray);
    }

    public void setDouble(int n2, double d2) {
        this.batch(n2, new Double(d2));
    }

    public void setFloat(int n2, float f2) {
        this.batch(n2, new Float(f2));
    }

    public void setInt(int n2, int n3) {
        this.batch(n2, new Integer(n3));
    }

    public void setLong(int n2, long l2) {
        this.batch(n2, new Long(l2));
    }

    public void setNull(int n2, int n3) {
        this.setNull(n2, n3, null);
    }

    public void setNull(int n2, int n3, String string) {
        this.batch(n2, null);
    }

    public void setObject(int n2, Object object) {
        if (object == null) {
            this.batch(n2, null);
        } else if (object instanceof java.util.Date) {
            this.setDateByMilliseconds(n2, ((java.util.Date)object).getTime(), Calendar.getInstance());
        } else if (object instanceof Long) {
            this.batch(n2, object);
        } else if (object instanceof Integer) {
            this.batch(n2, object);
        } else if (object instanceof Short) {
            this.batch(n2, new Integer(((Short)object).intValue()));
        } else if (object instanceof Float) {
            this.batch(n2, object);
        } else if (object instanceof Double) {
            this.batch(n2, object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n2, (Boolean)object);
        } else if (object instanceof byte[]) {
            this.batch(n2, object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n2, (BigDecimal)object);
        } else {
            this.batch(n2, object.toString());
        }
    }

    public void setObject(int n2, Object object, int n3) {
        this.setObject(n2, object);
    }

    public void setObject(int n2, Object object, int n3, int n4) {
        this.setObject(n2, object);
    }

    public void setShort(int n2, short s2) {
        this.setInt(n2, s2);
    }

    public void setString(int n2, String string) {
        this.batch(n2, string);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) {
        try {
            int n4;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[8192];
            while ((n4 = reader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n4);
            }
            this.setString(n2, stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new SQLException("Cannot read from character stream, exception message: " + iOException.getMessage());
        }
    }

    public void setDate(int n2, Date date) {
        this.setDate(n2, date, Calendar.getInstance());
    }

    public void setDate(int n2, Date date, Calendar calendar) {
        if (date == null) {
            this.setObject(n2, null);
        } else {
            this.setDateByMilliseconds(n2, date.getTime(), calendar);
        }
    }

    public void setTime(int n2, Time time) {
        this.setTime(n2, time, Calendar.getInstance());
    }

    public void setTime(int n2, Time time, Calendar calendar) {
        if (time == null) {
            this.setObject(n2, null);
        } else {
            this.setDateByMilliseconds(n2, time.getTime(), calendar);
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp) {
        this.setTimestamp(n2, timestamp, Calendar.getInstance());
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            this.setObject(n2, null);
        } else {
            this.setDateByMilliseconds(n2, timestamp.getTime(), calendar);
        }
    }

    public ResultSetMetaData getMetaData() {
        this.checkOpen();
        return (ResultSetMetaData)((Object)this.rs);
    }

    @Override
    protected SQLException unused() {
        return new SQLException("not implemented by SQLite JDBC driver");
    }

    public void setArray(int n2, Array array) {
        throw this.unused();
    }

    public void setBlob(int n2, Blob blob) {
        throw this.unused();
    }

    public void setClob(int n2, Clob clob) {
        throw this.unused();
    }

    public void setRef(int n2, Ref ref) {
        throw this.unused();
    }

    public void setURL(int n2, URL uRL) {
        throw this.unused();
    }

    @Override
    public boolean execute(String string) {
        throw this.unused();
    }

    @Override
    public int executeUpdate(String string) {
        throw this.unused();
    }

    @Override
    public ResultSet executeQuery(String string) {
        throw this.unused();
    }

    @Override
    public void addBatch(String string) {
        throw this.unused();
    }
}

