/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CoreDatabaseMetaData;
import org.sqlite.core.CoreStatement;
import org.sqlite.util.StringUtils;

public abstract class JDBC3DatabaseMetaData
extends CoreDatabaseMetaData {
    private static String driverName;
    private static String driverVersion;
    protected static final Pattern TYPE_INTEGER;
    protected static final Pattern TYPE_VARCHAR;
    protected static final Pattern TYPE_FLOAT;
    private static final Map<String, Integer> RULE_MAP;
    protected static final Pattern PK_UNNAMED_PATTERN;
    protected static final Pattern PK_NAMED_PATTERN;

    protected JDBC3DatabaseMetaData(SQLiteConnection sQLiteConnection) {
        super(sQLiteConnection);
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return Integer.valueOf(this.conn.libversion().split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() {
        return Integer.valueOf(this.conn.libversion().split("\\.")[1]);
    }

    @Override
    public int getDriverMajorVersion() {
        return Integer.valueOf(driverVersion.split("\\.")[0]);
    }

    @Override
    public int getDriverMinorVersion() {
        return Integer.valueOf(driverVersion.split("\\.")[1]);
    }

    @Override
    public int getJDBCMajorVersion() {
        return 2;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 1;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public String getDatabaseProductName() {
        return "SQLite";
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.conn.libversion();
    }

    @Override
    public String getDriverName() {
        return driverName;
    }

    @Override
    public String getDriverVersion() {
        return driverVersion;
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public String getCatalogTerm() {
        return "catalog";
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "not_implemented";
    }

    @Override
    public String getSearchStringEscape() {
        return null;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "ABORT,ACTION,AFTER,ANALYZE,ATTACH,AUTOINCREMENT,BEFORE,CASCADE,CONFLICT,DATABASE,DEFERRABLE,DEFERRED,DESC,DETACH,EXCLUSIVE,EXPLAIN,FAIL,GLOB,IGNORE,INDEX,INDEXED,INITIALLY,INSTEAD,ISNULL,KEY,LIMIT,NOTNULL,OFFSET,PLAN,PRAGMA,QUERY,RAISE,REGEXP,REINDEX,RENAME,REPLACE,RESTRICT,TEMP,TEMPORARY,TRANSACTION,VACUUM,VIEW,VIRTUAL";
    }

    @Override
    public String getNumericFunctions() {
        return "";
    }

    @Override
    public String getStringFunctions() {
        return "";
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public String getTimeDateFunctions() {
        return "DATE,TIME,DATETIME,JULIANDAY,STRFTIME";
    }

    @Override
    public String getURL() {
        return this.conn.getUrl();
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return !this.nullsAreSortedAtStart();
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean othersDeletesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int n2, int n3) {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n2, int n3) {
        return n2 == 1003 && n3 == 1007;
    }

    @Override
    public boolean supportsResultSetHoldability(int n2) {
        return n2 == 2;
    }

    @Override
    public boolean supportsResultSetType(int n2) {
        return n2 == 1003;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n2) {
        return n2 == 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.conn.isReadOnly();
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) {
        if (this.getAttributes == null) {
            this.getAttributes = this.conn.prepareStatement("select null as TYPE_CAT, null as TYPE_SCHEM, null as TYPE_NAME, null as ATTR_NAME, null as DATA_TYPE, null as ATTR_TYPE_NAME, null as ATTR_SIZE, null as DECIMAL_DIGITS, null as NUM_PREC_RADIX, null as NULLABLE, null as REMARKS, null as ATTR_DEF, null as SQL_DATA_TYPE, null as SQL_DATETIME_SUB, null as CHAR_OCTET_LENGTH, null as ORDINAL_POSITION, null as IS_NULLABLE, null as SCOPE_CATALOG, null as SCOPE_SCHEMA, null as SCOPE_TABLE, null as SOURCE_DATA_TYPE limit 0;");
        }
        return this.getAttributes.executeQuery();
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl2) {
        if (this.getBestRowIdentifier == null) {
            this.getBestRowIdentifier = this.conn.prepareStatement("select null as SCOPE, null as COLUMN_NAME, null as DATA_TYPE, null as TYPE_NAME, null as COLUMN_SIZE, null as BUFFER_LENGTH, null as DECIMAL_DIGITS, null as PSEUDO_COLUMN limit 0;");
        }
        return this.getBestRowIdentifier.executeQuery();
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) {
        if (this.getColumnPrivileges == null) {
            this.getColumnPrivileges = this.conn.prepareStatement("select null as TABLE_CAT, null as TABLE_SCHEM, null as TABLE_NAME, null as COLUMN_NAME, null as GRANTOR, null as GRANTEE, null as PRIVILEGE, null as IS_GRANTABLE limit 0;");
        }
        return this.getColumnPrivileges.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) {
        Object object;
        this.checkOpen();
        StringBuilder stringBuilder = new StringBuilder(700);
        stringBuilder.append("select null as TABLE_CAT, null as TABLE_SCHEM, tblname as TABLE_NAME, ").append("cn as COLUMN_NAME, ct as DATA_TYPE, tn as TYPE_NAME, 2000000000 as COLUMN_SIZE, ").append("2000000000 as BUFFER_LENGTH, 10   as DECIMAL_DIGITS, 10   as NUM_PREC_RADIX, ").append("colnullable as NULLABLE, null as REMARKS, colDefault as COLUMN_DEF, ").append("0    as SQL_DATA_TYPE, 0    as SQL_DATETIME_SUB, 2000000000 as CHAR_OCTET_LENGTH, ").append("ordpos as ORDINAL_POSITION, (case colnullable when 0 then 'NO' when 1 then 'YES' else '' end)").append("    as IS_NULLABLE, null as SCOPE_CATLOG, null as SCOPE_SCHEMA, ").append("null as SCOPE_TABLE, null as SOURCE_DATA_TYPE, ").append("(case colautoincrement when 0 then 'NO' when 1 then 'YES' else '' end) as IS_AUTOINCREMENT, ").append("'' as IS_GENERATEDCOLUMN from (");
        boolean bl2 = false;
        ResultSet resultSet = null;
        try {
            object = new String[]{"TABLE", "VIEW"};
            resultSet = this.getTables(string, string2, string3, (String[])object);
            while (resultSet.next()) {
                String string5 = resultSet.getString(3);
                boolean bl3 = false;
                Statement statement = this.conn.createStatement();
                ResultSet resultSet2 = null;
                try {
                    statement = this.conn.createStatement();
                    resultSet2 = statement.executeQuery("SELECT LIKE('%autoincrement%', LOWER(sql)) FROM sqlite_master WHERE LOWER(name) = LOWER('" + this.escape(string5) + "') AND TYPE IN ('table', 'view')");
                    resultSet2.next();
                    bl3 = resultSet2.getInt(1) == 1;
                }
                finally {
                    if (resultSet2 != null) {
                        try {
                            resultSet2.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                Statement statement2 = this.conn.createStatement();
                ResultSet resultSet3 = null;
                try {
                    String string6 = "PRAGMA table_info('" + string5 + "')";
                    resultSet3 = statement2.executeQuery(string6);
                    int n2 = 0;
                    while (resultSet3.next()) {
                        String string7 = resultSet3.getString(2);
                        String string8 = resultSet3.getString(3);
                        String string9 = resultSet3.getString(4);
                        String string10 = resultSet3.getString(5);
                        boolean bl4 = "1".equals(resultSet3.getString(6));
                        int n3 = 2;
                        if (string9 != null) {
                            int n4 = n3 = string9.equals("0") ? 1 : 0;
                        }
                        if (bl2) {
                            stringBuilder.append(" union all ");
                        }
                        bl2 = true;
                        string8 = string8 == null ? "TEXT" : string8.toUpperCase();
                        int n5 = 0;
                        if (bl4 && bl3) {
                            n5 = 1;
                        }
                        int n6 = -1;
                        n6 = TYPE_INTEGER.matcher(string8).find() ? 4 : (TYPE_VARCHAR.matcher(string8).find() ? 12 : (TYPE_FLOAT.matcher(string8).find() ? 6 : 12));
                        stringBuilder.append("select ").append(n2 + 1).append(" as ordpos, ").append(n3).append(" as colnullable,").append("'").append(n6).append("' as ct, ").append("'").append(string5).append("' as tblname, ").append("'").append(this.escape(string7)).append("' as cn, ").append("'").append(this.escape(string8)).append("' as tn, ").append(JDBC3DatabaseMetaData.quote(string10 == null ? null : this.escape(string10))).append(" as colDefault,").append(n5).append(" as colautoincrement");
                        if (string4 != null) {
                            stringBuilder.append(" where upper(cn) like upper('").append(this.escape(string4)).append("')");
                        }
                        ++n2;
                    }
                }
                finally {
                    if (resultSet3 != null) {
                        try {
                            resultSet3.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (statement2 == null) continue;
                    try {
                        statement2.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (bl2) {
            stringBuilder.append(") order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION;");
        } else {
            stringBuilder.append("select null as ordpos, null as colnullable, null as ct, null as tblname, null as cn, null as tn, null as colDefault, null as colautoincrement) limit 0;");
        }
        object = this.conn.createStatement();
        return ((CoreStatement)object).executeQuery(stringBuilder.toString(), true);
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string3 == null) {
            return this.getExportedKeys(string4, string5, string6);
        }
        if (string6 == null) {
            return this.getImportedKeys(string, string2, string3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ").append(JDBC3DatabaseMetaData.quote(string)).append(" as PKTABLE_CAT, ").append(JDBC3DatabaseMetaData.quote(string2)).append(" as PKTABLE_SCHEM, ").append(JDBC3DatabaseMetaData.quote(string3)).append(" as PKTABLE_NAME, ").append("'' as PKCOLUMN_NAME, ").append(JDBC3DatabaseMetaData.quote(string4)).append(" as FKTABLE_CAT, ").append(JDBC3DatabaseMetaData.quote(string5)).append(" as FKTABLE_SCHEM, ").append(JDBC3DatabaseMetaData.quote(string6)).append(" as FKTABLE_NAME, ").append("'' as FKCOLUMN_NAME, -1 as KEY_SEQ, 3 as UPDATE_RULE, 3 as DELETE_RULE, '' as FK_NAME, '' as PK_NAME, ").append(Integer.toString(5)).append(" as DEFERRABILITY limit 0 ");
        return ((CoreStatement)((Object)this.conn.createStatement())).executeQuery(stringBuilder.toString(), true);
    }

    @Override
    public ResultSet getSchemas() {
        if (this.getSchemas == null) {
            this.getSchemas = this.conn.prepareStatement("select null as TABLE_SCHEM, null as TABLE_CATALOG limit 0;");
        }
        return this.getSchemas.executeQuery();
    }

    @Override
    public ResultSet getCatalogs() {
        if (this.getCatalogs == null) {
            this.getCatalogs = this.conn.prepareStatement("select null as TABLE_CAT limit 0;");
        }
        return this.getCatalogs.executeQuery();
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) {
        PrimaryKeyFinder primaryKeyFinder = new PrimaryKeyFinder(string3);
        String[] stringArray = primaryKeyFinder.getColumns();
        Statement statement = this.conn.createStatement();
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("select null as TABLE_CAT, null as TABLE_SCHEM, '").append(this.escape(string3)).append("' as TABLE_NAME, cn as COLUMN_NAME, ks as KEY_SEQ, pk as PK_NAME from (");
        if (stringArray == null) {
            stringBuilder.append("select null as cn, null as pk, 0 as ks) limit 0;");
            return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.toString(), true);
        }
        String string4 = primaryKeyFinder.getName();
        if (string4 != null) {
            string4 = "'" + string4 + "'";
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(" union ");
            }
            stringBuilder.append("select ").append(string4).append(" as pk, '").append(this.escape(this.unquoteIdentifier(stringArray[i2]))).append("' as cn, ").append(i2 + 1).append(" as ks");
        }
        return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.append(") order by cn;").toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) {
        Serializable serializable;
        PrimaryKeyFinder primaryKeyFinder = new PrimaryKeyFinder(string3);
        String[] stringArray = primaryKeyFinder.getColumns();
        Statement statement = this.conn.createStatement();
        string = string != null ? JDBC3DatabaseMetaData.quote(string) : null;
        string2 = string2 != null ? JDBC3DatabaseMetaData.quote(string2) : null;
        StringBuilder stringBuilder = new StringBuilder(512);
        Object object = null;
        int n2 = 0;
        if (stringArray != null) {
            Object object2;
            ResultSet resultSet = statement.executeQuery("select name from sqlite_master where type = 'table'");
            serializable = new ArrayList();
            while (resultSet.next()) {
                object2 = resultSet.getString(1);
                ((ArrayList)serializable).add(object2);
                if (!((String)object2).equalsIgnoreCase(string3)) continue;
                object = object2;
            }
            resultSet.close();
            object2 = ((ArrayList)serializable).iterator();
            while (object2.hasNext()) {
                String string4 = (String)object2.next();
                try {
                    ImportedKeyFinder importedKeyFinder = new ImportedKeyFinder(string4);
                    List<ImportedKeyFinder.ForeignKey> list = importedKeyFinder.getFkList();
                    for (ImportedKeyFinder.ForeignKey foreignKey : list) {
                        String string5 = foreignKey.getPkTableName();
                        if (string5 == null || !string5.equalsIgnoreCase((String)object)) continue;
                        for (int i2 = 0; i2 < foreignKey.getColumnMappingCount(); ++i2) {
                            int n3 = i2 + 1;
                            String[] stringArray2 = foreignKey.getColumnMapping(i2);
                            String string6 = stringArray2[1];
                            string6 = string6 == null ? "" : string6;
                            String string7 = stringArray2[0];
                            string7 = string7 == null ? "" : string7;
                            boolean bl2 = false;
                            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                                if (stringArray[i3] == null || !stringArray[i3].equalsIgnoreCase(string6)) continue;
                                bl2 = true;
                                break;
                            }
                            String string8 = bl2 && primaryKeyFinder.getName() != null ? primaryKeyFinder.getName() : "";
                            stringBuilder.append(n2 > 0 ? " union all select " : "select ").append(Integer.toString(n3)).append(" as ks, '").append(this.escape(string4)).append("' as fkt, '").append(this.escape(string7)).append("' as fcn, '").append(this.escape(string6)).append("' as pcn, '").append(this.escape(string8)).append("' as pkn, ").append(RULE_MAP.get(foreignKey.getOnUpdate())).append(" as ur, ").append(RULE_MAP.get(foreignKey.getOnDelete())).append(" as dr, ");
                            String string9 = foreignKey.getFkName();
                            if (string9 != null) {
                                stringBuilder.append("'").append(this.escape(string9)).append("' as fkn");
                            } else {
                                stringBuilder.append("'' as fkn");
                            }
                            ++n2;
                        }
                    }
                }
                finally {
                    try {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        boolean bl3 = n2 > 0;
        serializable = new StringBuilder(512);
        ((StringBuilder)serializable).append("select ").append(string).append(" as PKTABLE_CAT, ").append(string2).append(" as PKTABLE_SCHEM, ").append(JDBC3DatabaseMetaData.quote(object)).append(" as PKTABLE_NAME, ").append(bl3 ? "pcn" : "''").append(" as PKCOLUMN_NAME, ").append(string).append(" as FKTABLE_CAT, ").append(string2).append(" as FKTABLE_SCHEM, ").append(bl3 ? "fkt" : "''").append(" as FKTABLE_NAME, ").append(bl3 ? "fcn" : "''").append(" as FKCOLUMN_NAME, ").append(bl3 ? "ks" : "-1").append(" as KEY_SEQ, ").append(bl3 ? "ur" : "3").append(" as UPDATE_RULE, ").append(bl3 ? "dr" : "3").append(" as DELETE_RULE, ").append(bl3 ? "fkn" : "''").append(" as FK_NAME, ").append(bl3 ? "pkn" : "''").append(" as PK_NAME, ").append(Integer.toString(5)).append(" as DEFERRABILITY ");
        if (bl3) {
            ((StringBuilder)serializable).append("from (").append((CharSequence)stringBuilder).append(") ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        } else {
            ((StringBuilder)serializable).append("limit 0");
        }
        return ((CoreStatement)((Object)statement)).executeQuery(((StringBuilder)serializable).toString(), true);
    }

    private StringBuilder appendDummyForeignKeyList(StringBuilder stringBuilder) {
        stringBuilder.append("select -1 as ks, '' as ptn, '' as fcn, '' as pcn, ").append(3).append(" as ur, ").append(3).append(" as dr, ").append(" '' as fkn, ").append(" '' as pkn ").append(") limit 0;");
        return stringBuilder;
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) {
        ResultSet resultSet = null;
        Statement statement = this.conn.createStatement();
        StringBuilder stringBuilder = new StringBuilder(700);
        stringBuilder.append("select ").append(JDBC3DatabaseMetaData.quote(string)).append(" as PKTABLE_CAT, ").append(JDBC3DatabaseMetaData.quote(string2)).append(" as PKTABLE_SCHEM, ").append("ptn as PKTABLE_NAME, pcn as PKCOLUMN_NAME, ").append(JDBC3DatabaseMetaData.quote(string)).append(" as FKTABLE_CAT, ").append(JDBC3DatabaseMetaData.quote(string2)).append(" as FKTABLE_SCHEM, ").append(JDBC3DatabaseMetaData.quote(string3)).append(" as FKTABLE_NAME, ").append("fcn as FKCOLUMN_NAME, ks as KEY_SEQ, ur as UPDATE_RULE, dr as DELETE_RULE, fkn as FK_NAME, pkn as PK_NAME, ").append(Integer.toString(5)).append(" as DEFERRABILITY from (");
        try {
            resultSet = statement.executeQuery("pragma foreign_key_list('" + this.escape(string3) + "');");
        }
        catch (SQLException sQLException) {
            stringBuilder = this.appendDummyForeignKeyList(stringBuilder);
            return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.toString(), true);
        }
        ImportedKeyFinder importedKeyFinder = new ImportedKeyFinder(string3);
        List<ImportedKeyFinder.ForeignKey> list = importedKeyFinder.getFkList();
        int n2 = 0;
        while (resultSet.next()) {
            int n3 = resultSet.getInt(2) + 1;
            int n4 = resultSet.getInt(1);
            String string4 = resultSet.getString(3);
            String string5 = resultSet.getString(4);
            String string6 = resultSet.getString(5);
            PrimaryKeyFinder primaryKeyFinder = new PrimaryKeyFinder(string4);
            String string7 = primaryKeyFinder.getName();
            if (string6 == null) {
                string6 = primaryKeyFinder.getColumns()[0];
            }
            String string8 = resultSet.getString(6);
            String string9 = resultSet.getString(7);
            if (n2 > 0) {
                stringBuilder.append(" union all ");
            }
            String string10 = null;
            if (list.size() > n4) {
                string10 = list.get(n4).getFkName();
            }
            stringBuilder.append("select ").append(n3).append(" as ks,").append("'").append(this.escape(string4)).append("' as ptn, '").append(this.escape(string5)).append("' as fcn, '").append(this.escape(string6)).append("' as pcn,").append("case '").append(this.escape(string8)).append("'").append(" when 'NO ACTION' then ").append(3).append(" when 'CASCADE' then ").append(0).append(" when 'RESTRICT' then ").append(1).append(" when 'SET NULL' then ").append(2).append(" when 'SET DEFAULT' then ").append(4).append(" end as ur, ").append("case '").append(this.escape(string9)).append("'").append(" when 'NO ACTION' then ").append(3).append(" when 'CASCADE' then ").append(0).append(" when 'RESTRICT' then ").append(1).append(" when 'SET NULL' then ").append(2).append(" when 'SET DEFAULT' then ").append(4).append(" end as dr, ").append(string10 == null ? "''" : JDBC3DatabaseMetaData.quote(string10)).append(" as fkn, ").append(string7 == null ? "''" : JDBC3DatabaseMetaData.quote(string7)).append(" as pkn");
            ++n2;
        }
        resultSet.close();
        if (n2 == 0) {
            stringBuilder = this.appendDummyForeignKeyList(stringBuilder);
        }
        stringBuilder.append(") ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ;");
        return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.toString(), true);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl2, boolean bl3) {
        String string4;
        ResultSet resultSet = null;
        Statement statement = this.conn.createStatement();
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("select null as TABLE_CAT, null as TABLE_SCHEM, '").append(this.escape(string3)).append("' as TABLE_NAME, un as NON_UNIQUE, null as INDEX_QUALIFIER, n as INDEX_NAME, ").append(Integer.toString(3)).append(" as TYPE, op as ORDINAL_POSITION, ").append("cn as COLUMN_NAME, null as ASC_OR_DESC, 0 as CARDINALITY, 0 as PAGES, null as FILTER_CONDITION from (");
        resultSet = statement.executeQuery("pragma index_list('" + this.escape(string3) + "');");
        ArrayList arrayList = new ArrayList();
        while (resultSet.next()) {
            arrayList.add(new ArrayList());
            ((ArrayList)arrayList.get(arrayList.size() - 1)).add(resultSet.getString(2));
            ((ArrayList)arrayList.get(arrayList.size() - 1)).add(resultSet.getInt(3));
        }
        resultSet.close();
        if (arrayList.size() == 0) {
            stringBuilder.append("select null as un, null as n, null as op, null as cn) limit 0;");
            return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.toString(), true);
        }
        boolean bl4 = false;
        Iterator iterator = arrayList.iterator();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (iterator.hasNext()) {
            ArrayList arrayList3 = (ArrayList)iterator.next();
            string4 = arrayList3.get(0).toString();
            resultSet = statement.executeQuery("pragma index_info('" + this.escape(string4) + "');");
            while (resultSet.next()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                String string5 = resultSet.getString(3);
                stringBuilder2.append("select ").append(Integer.toString(1 - (Integer)arrayList3.get(1))).append(" as un,'").append(this.escape(string4)).append("' as n,").append(Integer.toString(resultSet.getInt(1) + 1)).append(" as op,");
                if (string5 == null) {
                    stringBuilder2.append("null");
                } else {
                    stringBuilder2.append("'").append(this.escape(string5)).append("'");
                }
                stringBuilder2.append(" as cn");
                arrayList2.add(stringBuilder2.toString());
            }
            resultSet.close();
        }
        string4 = StringUtils.join(arrayList2, " union all ");
        return ((CoreStatement)((Object)statement)).executeQuery(stringBuilder.append(string4).append(");").toString(), true);
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) {
        if (this.getProcedureColumns == null) {
            this.getProcedureColumns = this.conn.prepareStatement("select null as PROCEDURE_CAT, null as PROCEDURE_SCHEM, null as PROCEDURE_NAME, null as COLUMN_NAME, null as COLUMN_TYPE, null as DATA_TYPE, null as TYPE_NAME, null as PRECISION, null as LENGTH, null as SCALE, null as RADIX, null as NULLABLE, null as REMARKS limit 0;");
        }
        return this.getProcedureColumns.executeQuery();
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) {
        if (this.getProcedures == null) {
            this.getProcedures = this.conn.prepareStatement("select null as PROCEDURE_CAT, null as PROCEDURE_SCHEM, null as PROCEDURE_NAME, null as UNDEF1, null as UNDEF2, null as UNDEF3, null as REMARKS, null as PROCEDURE_TYPE limit 0;");
        }
        return this.getProcedures.executeQuery();
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) {
        if (this.getSuperTables == null) {
            this.getSuperTables = this.conn.prepareStatement("select null as TABLE_CAT, null as TABLE_SCHEM, null as TABLE_NAME, null as SUPERTABLE_NAME limit 0;");
        }
        return this.getSuperTables.executeQuery();
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) {
        if (this.getSuperTypes == null) {
            this.getSuperTypes = this.conn.prepareStatement("select null as TYPE_CAT, null as TYPE_SCHEM, null as TYPE_NAME, null as SUPERTYPE_CAT, null as SUPERTYPE_SCHEM, null as SUPERTYPE_NAME limit 0;");
        }
        return this.getSuperTypes.executeQuery();
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) {
        if (this.getTablePrivileges == null) {
            this.getTablePrivileges = this.conn.prepareStatement("select  null as TABLE_CAT, null as TABLE_SCHEM, null as TABLE_NAME, null as GRANTOR, null GRANTEE,  null as PRIVILEGE, null as IS_GRANTABLE limit 0;");
        }
        return this.getTablePrivileges.executeQuery();
    }

    @Override
    public synchronized ResultSet getTables(String string, String string2, String string3, String[] stringArray) {
        this.checkOpen();
        string3 = string3 == null || "".equals(string3) ? "%" : this.escape(string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT").append("\n");
        stringBuilder.append("  NULL AS TABLE_CAT,").append("\n");
        stringBuilder.append("  NULL AS TABLE_SCHEM,").append("\n");
        stringBuilder.append("  NAME AS TABLE_NAME,").append("\n");
        stringBuilder.append("  TYPE AS TABLE_TYPE,").append("\n");
        stringBuilder.append("  NULL AS REMARKS,").append("\n");
        stringBuilder.append("  NULL AS TYPE_CAT,").append("\n");
        stringBuilder.append("  NULL AS TYPE_SCHEM,").append("\n");
        stringBuilder.append("  NULL AS TYPE_NAME,").append("\n");
        stringBuilder.append("  NULL AS SELF_REFERENCING_COL_NAME,").append("\n");
        stringBuilder.append("  NULL AS REF_GENERATION").append("\n");
        stringBuilder.append("FROM").append("\n");
        stringBuilder.append("  (").append("\n");
        stringBuilder.append("    SELECT").append("\n");
        stringBuilder.append("      NAME,").append("\n");
        stringBuilder.append("      UPPER(TYPE) AS TYPE").append("\n");
        stringBuilder.append("    FROM").append("\n");
        stringBuilder.append("      sqlite_master").append("\n");
        stringBuilder.append("    WHERE").append("\n");
        stringBuilder.append("      NAME NOT LIKE 'sqlite_%'").append("\n");
        stringBuilder.append("      AND UPPER(TYPE) IN ('TABLE', 'VIEW')").append("\n");
        stringBuilder.append("    UNION ALL").append("\n");
        stringBuilder.append("    SELECT").append("\n");
        stringBuilder.append("      NAME,").append("\n");
        stringBuilder.append("      'GLOBAL TEMPORARY' AS TYPE").append("\n");
        stringBuilder.append("    FROM").append("\n");
        stringBuilder.append("      sqlite_temp_master").append("\n");
        stringBuilder.append("    UNION ALL").append("\n");
        stringBuilder.append("    SELECT").append("\n");
        stringBuilder.append("      NAME,").append("\n");
        stringBuilder.append("      'SYSTEM TABLE' AS TYPE").append("\n");
        stringBuilder.append("    FROM").append("\n");
        stringBuilder.append("      sqlite_master").append("\n");
        stringBuilder.append("    WHERE").append("\n");
        stringBuilder.append("      NAME LIKE 'sqlite_%'").append("\n");
        stringBuilder.append("  )").append("\n");
        stringBuilder.append(" WHERE TABLE_NAME LIKE '").append(string3).append("' AND TABLE_TYPE IN (");
        if (stringArray == null || stringArray.length == 0) {
            stringBuilder.append("'TABLE','VIEW'");
        } else {
            stringBuilder.append("'").append(stringArray[0].toUpperCase()).append("'");
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringBuilder.append(",'").append(stringArray[i2].toUpperCase()).append("'");
            }
        }
        stringBuilder.append(") ORDER BY TABLE_TYPE, TABLE_NAME;");
        return ((CoreStatement)((Object)this.conn.createStatement())).executeQuery(stringBuilder.toString(), true);
    }

    @Override
    public ResultSet getTableTypes() {
        this.checkOpen();
        String string = "SELECT 'TABLE' AS TABLE_TYPE UNION SELECT 'VIEW' AS TABLE_TYPE UNION SELECT 'SYSTEM TABLE' AS TABLE_TYPE UNION SELECT 'GLOBAL TEMPORARY' AS TABLE_TYPE;";
        if (this.getTableTypes == null) {
            this.getTableTypes = this.conn.prepareStatement(string);
        }
        this.getTableTypes.clearParameters();
        return this.getTableTypes.executeQuery();
    }

    @Override
    public ResultSet getTypeInfo() {
        if (this.getTypeInfo == null) {
            this.getTypeInfo = this.conn.prepareStatement("select tn as TYPE_NAME, dt as DATA_TYPE, 0 as PRECISION, null as LITERAL_PREFIX, null as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE, 1 as CASE_SENSITIVE, 3 as SEARCHABLE, 0 as UNSIGNED_ATTRIBUTE, 0 as FIXED_PREC_SCALE, 0 as AUTO_INCREMENT, null as LOCAL_TYPE_NAME, 0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from (    select 'BLOB' as tn, 2004 as dt union    select 'NULL' as tn, 0 as dt union    select 'REAL' as tn, 7 as dt union    select 'TEXT' as tn, 12 as dt union    select 'INTEGER' as tn, 4 as dt) order by TYPE_NAME;");
        }
        this.getTypeInfo.clearParameters();
        return this.getTypeInfo.executeQuery();
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) {
        if (this.getUDTs == null) {
            this.getUDTs = this.conn.prepareStatement("select  null as TYPE_CAT, null as TYPE_SCHEM, null as TYPE_NAME,  null as CLASS_NAME,  null as DATA_TYPE, null as REMARKS, null as BASE_TYPE limit 0;");
        }
        this.getUDTs.clearParameters();
        return this.getUDTs.executeQuery();
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) {
        if (this.getVersionColumns == null) {
            this.getVersionColumns = this.conn.prepareStatement("select null as SCOPE, null as COLUMN_NAME, null as DATA_TYPE, null as TYPE_NAME, null as COLUMN_SIZE, null as BUFFER_LENGTH, null as DECIMAL_DIGITS, null as PSEUDO_COLUMN limit 0;");
        }
        return this.getVersionColumns.executeQuery();
    }

    @Override
    public ResultSet getGeneratedKeys() {
        if (this.getGeneratedKeys == null) {
            this.getGeneratedKeys = this.conn.prepareStatement("select last_insert_rowid();");
        }
        return this.getGeneratedKeys.executeQuery();
    }

    public Struct createStruct(String string, Object[] objectArray) {
        throw new SQLException("Not yet implemented by SQLite JDBC driver");
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) {
        throw new SQLException("Not yet implemented by SQLite JDBC driver");
    }

    @Override
    protected void finalize() {
        this.close();
    }

    private String unquoteIdentifier(String string) {
        if (string == null) {
            return string;
        }
        if ((string = string.trim()).length() > 2 && (string.startsWith("`") && string.endsWith("`") || string.startsWith("\"") && string.endsWith("\"") || string.startsWith("[") && string.endsWith("]"))) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    static {
        InputStream inputStream = null;
        try {
            inputStream = JDBC3DatabaseMetaData.class.getClassLoader().getResourceAsStream("sqlite-jdbc.properties");
            if (inputStream == null) {
                throw new IOException("Cannot load sqlite-jdbc.properties from jar");
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            driverName = properties.getProperty("name");
            driverVersion = properties.getProperty("version");
        }
        catch (Exception exception) {
            driverName = "SQLite JDBC";
            driverVersion = "3.0.0-UNKNOWN";
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        TYPE_INTEGER = Pattern.compile(".*(INT|BOOL).*");
        TYPE_VARCHAR = Pattern.compile(".*(CHAR|CLOB|TEXT|BLOB).*");
        TYPE_FLOAT = Pattern.compile(".*(REAL|FLOA|DOUB|DEC|NUM).*");
        RULE_MAP = new HashMap<String, Integer>();
        RULE_MAP.put("NO ACTION", 3);
        RULE_MAP.put("CASCADE", 0);
        RULE_MAP.put("RESTRICT", 1);
        RULE_MAP.put("SET NULL", 2);
        RULE_MAP.put("SET DEFAULT", 4);
        PK_UNNAMED_PATTERN = Pattern.compile(".*PRIMARY\\s+KEY\\s*\\((.*?)\\).*", 34);
        PK_NAMED_PATTERN = Pattern.compile(".*CONSTRAINT\\s*(.*?)\\s*PRIMARY\\s+KEY\\s*\\((.*?)\\).*", 34);
    }

    class ImportedKeyFinder {
        private final Pattern FK_NAMED_PATTERN = Pattern.compile("CONSTRAINT\\s*([A-Za-z_][A-Za-z\\d_]*)?\\s*FOREIGN\\s+KEY\\s*\\((.*?)\\)", 34);
        private String fkTableName;
        private List<ForeignKey> fkList = new ArrayList<ForeignKey>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ImportedKeyFinder(String string) {
            if (string == null || string.trim().length() == 0) {
                throw new SQLException("Invalid table name: '" + string + "'");
            }
            this.fkTableName = string;
            List<String> list = this.getForeignKeyNames(this.fkTableName);
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = JDBC3DatabaseMetaData.this.conn.createStatement();
                resultSet = statement.executeQuery("pragma foreign_key_list('" + this.fkTableName.toLowerCase() + "')");
                int n2 = -1;
                int n3 = 0;
                ForeignKey foreignKey = null;
                while (resultSet.next()) {
                    int n4 = resultSet.getInt(1);
                    int n5 = resultSet.getInt(2);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(4);
                    String string4 = resultSet.getString(5);
                    String string5 = resultSet.getString(6);
                    String string6 = resultSet.getString(7);
                    String string7 = resultSet.getString(8);
                    String string8 = null;
                    if (list.size() > n3) {
                        string8 = list.get(n3);
                    }
                    if (n4 != n2) {
                        foreignKey = new ForeignKey(string8, string2, this.fkTableName, string5, string6, string7);
                        this.fkList.add(foreignKey);
                        n2 = n4;
                        ++n3;
                    }
                    foreignKey.addColumnMapping(string3, string4);
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> getForeignKeyNames(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string == null) {
                return arrayList;
            }
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = JDBC3DatabaseMetaData.this.conn.createStatement();
                resultSet = statement.executeQuery("select sql from sqlite_master where lower(name) = lower('" + JDBC3DatabaseMetaData.this.escape(string) + "')");
                if (resultSet.next()) {
                    Matcher matcher = this.FK_NAMED_PATTERN.matcher(resultSet.getString(1));
                    while (matcher.find()) {
                        arrayList.add(matcher.group(1));
                    }
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            Collections.reverse(arrayList);
            return arrayList;
        }

        public String getFkTableName() {
            return this.fkTableName;
        }

        public List<ForeignKey> getFkList() {
            return this.fkList;
        }

        class ForeignKey {
            private String fkName;
            private String pkTableName;
            private String fkTableName;
            private List<String> fkColNames = new ArrayList<String>();
            private List<String> pkColNames = new ArrayList<String>();
            private String onUpdate;
            private String onDelete;
            private String match;

            ForeignKey(String string, String string2, String string3, String string4, String string5, String string6) {
                this.fkName = string;
                this.pkTableName = string2;
                this.fkTableName = string3;
                this.onUpdate = string4;
                this.onDelete = string5;
                this.match = string6;
            }

            public String getFkName() {
                return this.fkName;
            }

            void addColumnMapping(String string, String string2) {
                this.fkColNames.add(string);
                this.pkColNames.add(string2);
            }

            public String[] getColumnMapping(int n2) {
                return new String[]{this.fkColNames.get(n2), this.pkColNames.get(n2)};
            }

            public int getColumnMappingCount() {
                return this.fkColNames.size();
            }

            public String getPkTableName() {
                return this.pkTableName;
            }

            public String getFkTableName() {
                return this.fkTableName;
            }

            public String getOnUpdate() {
                return this.onUpdate;
            }

            public String getOnDelete() {
                return this.onDelete;
            }

            public String getMatch() {
                return this.match;
            }

            public String toString() {
                return "ForeignKey [fkName=" + this.fkName + ", pkTableName=" + this.pkTableName + ", fkTableName=" + this.fkTableName + ", pkColNames=" + this.pkColNames + ", fkColNames=" + this.fkColNames + "]";
            }
        }
    }

    class PrimaryKeyFinder {
        String table;
        String pkName = null;
        String[] pkColumns = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrimaryKeyFinder(String string) {
            this.table = string;
            if (string == null || string.trim().length() == 0) {
                throw new SQLException("Invalid table name: '" + this.table + "'");
            }
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = JDBC3DatabaseMetaData.this.conn.createStatement();
                resultSet = statement.executeQuery("select sql from sqlite_master where lower(name) = lower('" + JDBC3DatabaseMetaData.this.escape(string) + "') and type in ('table', 'view')");
                if (!resultSet.next()) {
                    throw new SQLException("Table not found: '" + string + "'");
                }
                Matcher matcher = PK_NAMED_PATTERN.matcher(resultSet.getString(1));
                if (matcher.find()) {
                    this.pkName = JDBC3DatabaseMetaData.this.unquoteIdentifier(JDBC3DatabaseMetaData.this.escape(matcher.group(1)));
                    this.pkColumns = matcher.group(2).split(",");
                } else {
                    matcher = PK_UNNAMED_PATTERN.matcher(resultSet.getString(1));
                    if (matcher.find()) {
                        this.pkColumns = matcher.group(1).split(",");
                    }
                }
                if (this.pkColumns == null) {
                    resultSet = statement.executeQuery("pragma table_info('" + JDBC3DatabaseMetaData.this.escape(string) + "');");
                    while (resultSet.next()) {
                        if (!resultSet.getBoolean(6)) continue;
                        this.pkColumns = new String[]{resultSet.getString(2)};
                    }
                }
                if (this.pkColumns != null) {
                    for (int i2 = 0; i2 < this.pkColumns.length; ++i2) {
                        this.pkColumns[i2] = JDBC3DatabaseMetaData.this.unquoteIdentifier(this.pkColumns[i2]);
                    }
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public String getName() {
            return this.pkName;
        }

        public String[] getColumns() {
            return this.pkColumns;
        }
    }
}

