/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteOpenMode;
import org.sqlite.jdbc3.JDBC3Savepoint;

public abstract class JDBC3Connection
extends SQLiteConnection {
    private final AtomicInteger savePoint = new AtomicInteger(0);
    private Map<String, Class<?>> typeMap;

    protected JDBC3Connection(String string, String string2, Properties properties) {
        super(string, string2, properties);
    }

    @Override
    public String getCatalog() {
        this.checkOpen();
        return null;
    }

    @Override
    public void setCatalog(String string) {
        this.checkOpen();
    }

    @Override
    public int getHoldability() {
        this.checkOpen();
        return 2;
    }

    @Override
    public void setHoldability(int n2) {
        this.checkOpen();
        if (n2 != 2) {
            throw new SQLException("SQLite only supports CLOSE_CURSORS_AT_COMMIT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Class<?>> getTypeMap() {
        JDBC3Connection jDBC3Connection = this;
        synchronized (jDBC3Connection) {
            if (this.typeMap == null) {
                this.typeMap = new HashMap();
            }
            return this.typeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeMap(Map map) {
        JDBC3Connection jDBC3Connection = this;
        synchronized (jDBC3Connection) {
            this.typeMap = map;
        }
    }

    @Override
    public boolean isReadOnly() {
        return (this.getDatabase().getConfig().getOpenModeFlags() & SQLiteOpenMode.READONLY.flag) != 0;
    }

    @Override
    public void setReadOnly(boolean bl2) {
        if (bl2 != this.isReadOnly()) {
            throw new SQLException("Cannot change read-only flag after establishing a connection. Use SQLiteConfig#setReadOnly and SQLiteConfig.createConnection().");
        }
    }

    @Override
    public String nativeSQL(String string) {
        return string;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public Statement createStatement() {
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public Statement createStatement(int n2, int n3) {
        return this.createStatement(n2, n3, 2);
    }

    @Override
    public abstract Statement createStatement(int var1, int var2, int var3);

    @Override
    public CallableStatement prepareCall(String string) {
        return this.prepareCall(string, 1003, 1007, 2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n2, int n3) {
        return this.prepareCall(string, n2, n3, 2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n2, int n3, int n4) {
        throw new SQLException("SQLite does not support Stored Procedures");
    }

    @Override
    public PreparedStatement prepareStatement(String string) {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n2) {
        return this.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) {
        return this.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        return this.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3) {
        return this.prepareStatement(string, n2, n3, 2);
    }

    @Override
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4);

    @Override
    public Savepoint setSavepoint() {
        this.checkOpen();
        if (this.getAutoCommit()) {
            this.getConnectionConfig().setAutoCommit(false);
        }
        JDBC3Savepoint jDBC3Savepoint = new JDBC3Savepoint(this.savePoint.incrementAndGet());
        this.getDatabase().exec(String.format("SAVEPOINT %s", jDBC3Savepoint.getSavepointName()), false);
        return jDBC3Savepoint;
    }

    @Override
    public Savepoint setSavepoint(String string) {
        this.checkOpen();
        if (this.getAutoCommit()) {
            this.getConnectionConfig().setAutoCommit(false);
        }
        JDBC3Savepoint jDBC3Savepoint = new JDBC3Savepoint(this.savePoint.incrementAndGet(), string);
        this.getDatabase().exec(String.format("SAVEPOINT %s", jDBC3Savepoint.getSavepointName()), false);
        return jDBC3Savepoint;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new SQLException("database in auto-commit mode");
        }
        this.getDatabase().exec(String.format("RELEASE SAVEPOINT %s", savepoint.getSavepointName()), false);
    }

    @Override
    public void rollback(Savepoint savepoint) {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new SQLException("database in auto-commit mode");
        }
        this.getDatabase().exec(String.format("ROLLBACK TO SAVEPOINT %s", savepoint.getSavepointName()), this.getAutoCommit());
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) {
        throw new SQLException("unsupported by SQLite");
    }
}

