/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sqlite.BusyHandler;
import org.sqlite.Function;
import org.sqlite.ProgressHandler;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteErrorCode;
import org.sqlite.SQLiteException;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreStatement;

public abstract class DB
implements Codes {
    private final String url;
    private final String fileName;
    private final SQLiteConfig config;
    private final AtomicBoolean closed = new AtomicBoolean(true);
    long begin = 0L;
    long commit = 0L;
    private final Map<Long, CoreStatement> stmts = new HashMap<Long, CoreStatement>();

    public DB(String string, String string2, SQLiteConfig sQLiteConfig) {
        this.url = string;
        this.fileName = string2;
        this.config = sQLiteConfig;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public SQLiteConfig getConfig() {
        return this.config;
    }

    public abstract void interrupt();

    public abstract void busy_timeout(int var1);

    public abstract void busy_handler(BusyHandler var1);

    abstract String errmsg();

    public abstract String libversion();

    public abstract int changes();

    public abstract int total_changes();

    public abstract int shared_cache(boolean var1);

    public abstract int enable_load_extension(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void exec(String string, boolean bl2) {
        long l2 = 0L;
        try {
            l2 = this.prepare(string);
            int n2 = this.step(l2);
            switch (n2) {
                case 101: {
                    this.ensureAutoCommit(bl2);
                    return;
                }
                case 100: {
                    return;
                }
            }
            this.throwex(n2);
        }
        finally {
            this.finalize(l2);
        }
    }

    public final synchronized void open(String string, int n2) {
        this._open(string, n2);
        this.closed.set(false);
        if (this.fileName.startsWith("file:") && !this.fileName.contains("cache=")) {
            this.shared_cache(this.config.isEnabledSharedCache());
        }
        this.enable_load_extension(this.config.isEnabledLoadExtension());
        this.busy_timeout(this.config.getBusyTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void close() {
        Map<Long, CoreStatement> map = this.stmts;
        synchronized (map) {
            Iterator<Map.Entry<Long, CoreStatement>> iterator = this.stmts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, CoreStatement> entry = iterator.next();
                CoreStatement coreStatement = entry.getValue();
                this.finalize(entry.getKey());
                if (coreStatement != null) {
                    coreStatement.pointer = 0L;
                }
                iterator.remove();
            }
        }
        this.free_functions();
        if (this.begin != 0L) {
            this.finalize(this.begin);
            this.begin = 0L;
        }
        if (this.commit != 0L) {
            this.finalize(this.commit);
            this.commit = 0L;
        }
        this.closed.set(true);
        this._close();
    }

    public final synchronized void prepare(CoreStatement coreStatement) {
        if (coreStatement.sql == null) {
            throw new NullPointerException();
        }
        if (coreStatement.pointer != 0L) {
            this.finalize(coreStatement);
        }
        coreStatement.pointer = this.prepare(coreStatement.sql);
        this.stmts.put(new Long(coreStatement.pointer), coreStatement);
    }

    public final synchronized int finalize(CoreStatement coreStatement) {
        if (coreStatement.pointer == 0L) {
            return 0;
        }
        int n2 = 1;
        try {
            n2 = this.finalize(coreStatement.pointer);
        }
        finally {
            this.stmts.remove(new Long(coreStatement.pointer));
            coreStatement.pointer = 0L;
        }
        return n2;
    }

    protected abstract void _open(String var1, int var2);

    protected abstract void _close();

    public abstract int _exec(String var1);

    protected abstract long prepare(String var1);

    protected abstract int finalize(long var1);

    public abstract int step(long var1);

    public abstract int reset(long var1);

    public abstract int clear_bindings(long var1);

    abstract int bind_parameter_count(long var1);

    public abstract int column_count(long var1);

    public abstract int column_type(long var1, int var3);

    public abstract String column_decltype(long var1, int var3);

    public abstract String column_table_name(long var1, int var3);

    public abstract String column_name(long var1, int var3);

    public abstract String column_text(long var1, int var3);

    public abstract byte[] column_blob(long var1, int var3);

    public abstract double column_double(long var1, int var3);

    public abstract long column_long(long var1, int var3);

    public abstract int column_int(long var1, int var3);

    abstract int bind_null(long var1, int var3);

    abstract int bind_int(long var1, int var3, int var4);

    abstract int bind_long(long var1, int var3, long var4);

    abstract int bind_double(long var1, int var3, double var4);

    abstract int bind_text(long var1, int var3, String var4);

    abstract int bind_blob(long var1, int var3, byte[] var4);

    public abstract void result_null(long var1);

    public abstract void result_text(long var1, String var3);

    public abstract void result_blob(long var1, byte[] var3);

    public abstract void result_double(long var1, double var3);

    public abstract void result_long(long var1, long var3);

    public abstract void result_int(long var1, int var3);

    public abstract void result_error(long var1, String var3);

    public abstract String value_text(Function var1, int var2);

    public abstract byte[] value_blob(Function var1, int var2);

    public abstract double value_double(Function var1, int var2);

    public abstract long value_long(Function var1, int var2);

    public abstract int value_int(Function var1, int var2);

    public abstract int value_type(Function var1, int var2);

    public abstract int create_function(String var1, Function var2, int var3);

    public abstract int destroy_function(String var1);

    abstract void free_functions();

    public abstract int backup(String var1, String var2, ProgressObserver var3);

    public abstract int restore(String var1, String var2, ProgressObserver var3);

    public abstract void register_progress_handler(int var1, ProgressHandler var2);

    public abstract void clear_progress_handler();

    abstract boolean[][] column_metadata(long var1);

    public final synchronized String[] column_names(long l2) {
        String[] stringArray = new String[this.column_count(l2)];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.column_name(l2, i2);
        }
        return stringArray;
    }

    final synchronized int sqlbind(long l2, int n2, Object object) {
        ++n2;
        if (object == null) {
            return this.bind_null(l2, n2);
        }
        if (object instanceof Integer) {
            return this.bind_int(l2, n2, (Integer)object);
        }
        if (object instanceof Short) {
            return this.bind_int(l2, n2, ((Short)object).intValue());
        }
        if (object instanceof Long) {
            return this.bind_long(l2, n2, (Long)object);
        }
        if (object instanceof Float) {
            return this.bind_double(l2, n2, ((Float)object).doubleValue());
        }
        if (object instanceof Double) {
            return this.bind_double(l2, n2, (Double)object);
        }
        if (object instanceof String) {
            return this.bind_text(l2, n2, (String)object);
        }
        if (object instanceof byte[]) {
            return this.bind_blob(l2, n2, (byte[])object);
        }
        throw new SQLException("unexpected param type: " + object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized int[] executeBatch(long l2, int n2, Object[] objectArray, boolean bl2) {
        if (n2 < 1) {
            throw new SQLException("count (" + n2 + ") < 1");
        }
        int n3 = this.bind_parameter_count(l2);
        int[] nArray = new int[n2];
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4;
                this.reset(l2);
                for (int i3 = 0; i3 < n3; ++i3) {
                    n4 = this.sqlbind(l2, i3, objectArray[i2 * n3 + i3]);
                    if (n4 == 0) continue;
                    this.throwex(n4);
                }
                n4 = this.step(l2);
                if (n4 != 101) {
                    this.reset(l2);
                    if (n4 == 100) {
                        throw new BatchUpdateException("batch entry " + i2 + ": query returns results", nArray);
                    }
                    this.throwex(n4);
                }
                nArray[i2] = this.changes();
            }
        }
        finally {
            this.ensureAutoCommit(bl2);
        }
        this.reset(l2);
        return nArray;
    }

    public final synchronized boolean execute(CoreStatement coreStatement, Object[] objectArray) {
        int n2;
        if (objectArray != null) {
            n2 = this.bind_parameter_count(coreStatement.pointer);
            if (n2 > objectArray.length) {
                throw new SQLException("assertion failure: param count (" + n2 + ") > value count (" + objectArray.length + ")");
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.sqlbind(coreStatement.pointer, i2, objectArray[i2]);
                if (n3 == 0) continue;
                this.throwex(n3);
            }
        }
        n2 = this.step(coreStatement.pointer) & 0xFF;
        switch (n2) {
            case 101: {
                this.reset(coreStatement.pointer);
                this.ensureAutoCommit(coreStatement.conn.getAutoCommit());
                return false;
            }
            case 100: {
                return true;
            }
            case 5: 
            case 6: 
            case 19: 
            case 21: {
                throw this.newSQLException(n2);
            }
        }
        this.finalize(coreStatement);
        throw this.newSQLException(n2);
    }

    final synchronized boolean execute(String string, boolean bl2) {
        int n2 = this._exec(string);
        switch (n2) {
            case 0: {
                return false;
            }
            case 101: {
                this.ensureAutoCommit(bl2);
                return false;
            }
            case 100: {
                return true;
            }
        }
        throw this.newSQLException(n2);
    }

    public final synchronized int executeUpdate(CoreStatement coreStatement, Object[] objectArray) {
        try {
            if (this.execute(coreStatement, objectArray)) {
                throw new SQLException("query returns results");
            }
        }
        finally {
            if (coreStatement.pointer != 0L) {
                this.reset(coreStatement.pointer);
            }
        }
        return this.changes();
    }

    final void throwex() {
        throw new SQLException(this.errmsg());
    }

    public final void throwex(int n2) {
        throw this.newSQLException(n2);
    }

    static final void throwex(int n2, String string) {
        throw DB.newSQLException(n2, string);
    }

    public static SQLiteException newSQLException(int n2, String string) {
        SQLiteErrorCode sQLiteErrorCode = SQLiteErrorCode.getErrorCode(n2);
        SQLiteException sQLiteException = new SQLiteException(String.format("%s (%s)", new Object[]{sQLiteErrorCode, string}), sQLiteErrorCode);
        return sQLiteException;
    }

    private SQLiteException newSQLException(int n2) {
        return DB.newSQLException(n2, this.errmsg());
    }

    final void ensureAutoCommit(boolean bl2) {
        if (!bl2) {
            return;
        }
        if (this.begin == 0L) {
            this.begin = this.prepare("begin;");
        }
        if (this.commit == 0L) {
            this.commit = this.prepare("commit;");
        }
        try {
            if (this.step(this.begin) != 101) {
                return;
            }
            int n2 = this.step(this.commit);
            if (n2 != 101) {
                this.reset(this.commit);
                this.throwex(n2);
            }
        }
        finally {
            this.reset(this.begin);
            this.reset(this.commit);
        }
    }

    public static interface ProgressObserver {
        public void progress(int var1, int var2);
    }
}

