/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreResultSet;
import org.sqlite.core.DB;
import org.sqlite.jdbc4.JDBC4ResultSet;

public abstract class CoreStatement
implements Codes {
    public final SQLiteConnection conn;
    protected final CoreResultSet rs;
    public long pointer;
    protected String sql = null;
    protected int batchPos;
    protected Object[] batch = null;
    protected boolean resultsWaiting = false;

    protected CoreStatement(SQLiteConnection sQLiteConnection) {
        this.conn = sQLiteConnection;
        this.rs = new JDBC4ResultSet(this);
    }

    public DB getDatbase() {
        return this.conn.getDatabase();
    }

    public SQLiteConnectionConfig getConnectionConfig() {
        return this.conn.getConnectionConfig();
    }

    protected final void checkOpen() {
        if (this.pointer == 0L) {
            throw new SQLException("statement is not executing");
        }
    }

    boolean isOpen() {
        return this.pointer != 0L;
    }

    protected boolean exec() {
        if (this.sql == null) {
            throw new SQLException("SQLiteJDBC internal error: sql==null");
        }
        if (this.rs.isOpen()) {
            throw new SQLException("SQLite JDBC internal error: rs.isOpen() on exec.");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl3 = this.conn.getDatabase().execute(this, null);
            bl2 = true;
        }
        finally {
            this.resultsWaiting = bl3;
            if (!bl2) {
                this.conn.getDatabase().finalize(this);
            }
        }
        return this.conn.getDatabase().column_count(this.pointer) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exec(String string) {
        if (string == null) {
            throw new SQLException("SQLiteJDBC internal error: sql==null");
        }
        if (this.rs.isOpen()) {
            throw new SQLException("SQLite JDBC internal error: rs.isOpen() on exec.");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.conn.getDatabase().execute(string, this.conn.getAutoCommit());
            bl3 = true;
        }
        finally {
            this.resultsWaiting = bl2;
            if (!bl3) {
                this.conn.getDatabase().finalize(this);
            }
        }
        return this.conn.getDatabase().column_count(this.pointer) != 0;
    }

    protected void internalClose() {
        if (this.pointer == 0L) {
            return;
        }
        if (this.conn.isClosed()) {
            throw DB.newSQLException(1, "Connection is closed");
        }
        this.rs.close();
        this.batch = null;
        this.batchPos = 0;
        int n2 = this.conn.getDatabase().finalize(this);
        if (n2 != 0 && n2 != 21) {
            this.conn.getDatabase().throwex(n2);
        }
    }

    public abstract ResultSet executeQuery(String var1, boolean var2);
}

