/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.Date;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.DB;
import org.sqlite.date.FastDateFormat;
import org.sqlite.jdbc4.JDBC4Statement;

public abstract class CorePreparedStatement
extends JDBC4Statement {
    protected int columnCount;
    protected int paramCount;
    protected int batchQueryCount;
    protected BitSet paramValid;

    protected CorePreparedStatement(SQLiteConnection sQLiteConnection, String string) {
        super(sQLiteConnection);
        this.sql = string;
        DB dB2 = sQLiteConnection.getDatabase();
        dB2.prepare(this);
        this.rs.colsMeta = dB2.column_names(this.pointer);
        this.columnCount = dB2.column_count(this.pointer);
        this.paramCount = dB2.bind_parameter_count(this.pointer);
        this.paramValid = new BitSet(this.paramCount);
        this.batchQueryCount = 0;
        this.batch = null;
        this.batchPos = 0;
    }

    @Override
    protected void finalize() {
        this.close();
    }

    protected void checkParameters() {
        if (this.paramValid.cardinality() != this.paramCount) {
            throw new SQLException("Values not bound to statement");
        }
    }

    @Override
    public int[] executeBatch() {
        if (this.batchQueryCount == 0) {
            return new int[0];
        }
        this.checkParameters();
        try {
            int[] nArray = this.conn.getDatabase().executeBatch(this.pointer, this.batchQueryCount, this.batch, this.conn.getAutoCommit());
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public void clearBatch() {
        super.clearBatch();
        this.paramValid.clear();
        this.batchQueryCount = 0;
    }

    @Override
    public int getUpdateCount() {
        if (this.pointer == 0L || this.resultsWaiting || this.rs.isOpen()) {
            return -1;
        }
        return this.conn.getDatabase().changes();
    }

    protected void batch(int n2, Object object) {
        this.checkOpen();
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
            this.paramValid.clear();
        }
        this.batch[this.batchPos + n2 - 1] = object;
        this.paramValid.set(n2 - 1);
    }

    protected void setDateByMilliseconds(int n2, Long l2, Calendar calendar) {
        SQLiteConnectionConfig sQLiteConnectionConfig = this.conn.getConnectionConfig();
        switch (sQLiteConnectionConfig.getDateClass()) {
            case TEXT: {
                this.batch(n2, FastDateFormat.getInstance(sQLiteConnectionConfig.getDateStringFormat(), calendar.getTimeZone()).format(new Date(l2)));
                break;
            }
            case REAL: {
                this.batch(n2, new Double((double)l2.longValue() / 8.64E7 + 2440587.5));
                break;
            }
            default: {
                this.batch(n2, new Long(l2 / sQLiteConnectionConfig.getDateMultiplier()));
            }
        }
    }
}

