/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.CoreDatabaseMetaData;
import org.sqlite.core.DB;
import org.sqlite.core.NativeDB;
import org.sqlite.jdbc4.JDBC4DatabaseMetaData;

public abstract class SQLiteConnection
implements Connection {
    private static final String RESOURCE_NAME_PREFIX = ":resource:";
    private final DB db;
    private CoreDatabaseMetaData meta = null;
    private final SQLiteConnectionConfig connectionConfig;

    public SQLiteConnection(DB dB2) {
        this.db = dB2;
        this.connectionConfig = dB2.getConfig().newConnectionConfig();
    }

    public SQLiteConnection(String string, String string2) {
        this(string, string2, new Properties());
    }

    public SQLiteConnection(String string, String string2, Properties properties) {
        this.db = SQLiteConnection.open(string, string2, properties);
        SQLiteConfig sQLiteConfig = this.db.getConfig();
        this.connectionConfig = this.db.getConfig().newConnectionConfig();
        sQLiteConfig.apply(this);
    }

    public SQLiteConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public CoreDatabaseMetaData getSQLiteDatabaseMetaData() {
        this.checkOpen();
        if (this.meta == null) {
            this.meta = new JDBC4DatabaseMetaData(this);
        }
        return this.meta;
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return this.getSQLiteDatabaseMetaData();
    }

    public String getUrl() {
        return this.db.getUrl();
    }

    @Override
    public void setSchema(String string) {
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n2) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    protected void checkCursor(int n2, int n3, int n4) {
        if (n2 != 1003) {
            throw new SQLException("SQLite only supports TYPE_FORWARD_ONLY cursors");
        }
        if (n3 != 1007) {
            throw new SQLException("SQLite only supports CONCUR_READ_ONLY cursors");
        }
        if (n4 != 2) {
            throw new SQLException("SQLite only supports closing cursors at commit");
        }
    }

    protected void setTransactionMode(SQLiteConfig.TransactionMode transactionMode) {
        this.connectionConfig.setTransactionMode(transactionMode);
    }

    @Override
    public int getTransactionIsolation() {
        return this.connectionConfig.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int n2) {
        this.checkOpen();
        switch (n2) {
            case 8: {
                this.getDatabase().exec("PRAGMA read_uncommitted = false;", this.getAutoCommit());
                break;
            }
            case 1: {
                this.getDatabase().exec("PRAGMA read_uncommitted = true;", this.getAutoCommit());
                break;
            }
            default: {
                throw new SQLException("SQLite supports only TRANSACTION_SERIALIZABLE and TRANSACTION_READ_UNCOMMITTED.");
            }
        }
        this.connectionConfig.setTransactionIsolation(n2);
    }

    private static DB open(String string, String string2, Properties properties) {
        Serializable serializable;
        Object object;
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        String string3 = SQLiteConnection.extractPragmasFromFilename(string, string2, properties2);
        SQLiteConfig sQLiteConfig = new SQLiteConfig(properties2);
        if (!(string3.isEmpty() || ":memory:".equals(string3) || string3.startsWith("file:") || string3.contains("mode=memory"))) {
            Object object2;
            if (string3.startsWith(RESOURCE_NAME_PREFIX)) {
                object = string3.substring(RESOURCE_NAME_PREFIX.length());
                object2 = Thread.currentThread().getContextClassLoader();
                serializable = ((ClassLoader)object2).getResource((String)object);
                if (serializable == null) {
                    try {
                        serializable = new URL((String)object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new SQLException(String.format("resource %s not found: %s", object, malformedURLException));
                    }
                }
                try {
                    string3 = SQLiteConnection.extractResource((URL)serializable).getAbsolutePath();
                }
                catch (IOException iOException) {
                    throw new SQLException(String.format("failed to load %s: %s", object, iOException));
                }
            }
            object = new File(string3).getAbsoluteFile();
            object2 = ((File)object).getParentFile();
            if (object2 != null && !((File)object2).exists()) {
                for (Object object3 = object2; object3 != null && !((File)object3).exists(); object3 = ((File)object3).getParentFile()) {
                    object2 = object3;
                }
                throw new SQLException("path to '" + string3 + "': '" + object2 + "' does not exist");
            }
            try {
                if (!((File)object).exists() && ((File)object).createNewFile()) {
                    ((File)object).delete();
                }
            }
            catch (Exception exception) {
                throw new SQLException("opening db: '" + string3 + "': " + exception.getMessage());
            }
            string3 = ((File)object).getAbsolutePath();
        }
        object = null;
        try {
            NativeDB.load();
            object = new NativeDB(string, string3, sQLiteConfig);
        }
        catch (Exception exception) {
            serializable = new SQLException("Error opening connection");
            serializable.initCause(exception);
            throw serializable;
        }
        ((DB)object).open(string3, sQLiteConfig.getOpenModeFlags());
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractResource(URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            try {
                return new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException.getMessage());
            }
        }
        String string = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        String string2 = String.format("sqlite-jdbc-tmp-%d.db", uRL.hashCode());
        File file = new File(string, string2);
        if (file.exists()) {
            long l2;
            long l3 = uRL.openConnection().getLastModified();
            if (l3 < (l2 = file.lastModified())) {
                return file;
            }
            boolean bl2 = file.delete();
            if (!bl2) {
                throw new IOException("failed to remove existing DB file: " + file.getAbsolutePath());
            }
        }
        byte[] byArray = new byte[8192];
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = uRL.openStream();
        try {
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            File file2 = file;
            return file2;
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
    }

    public DB getDatabase() {
        return this.db;
    }

    @Override
    public boolean getAutoCommit() {
        this.checkOpen();
        return this.connectionConfig.isAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean bl2) {
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit() == bl2) {
            return;
        }
        this.connectionConfig.setAutoCommit(bl2);
        this.db.exec(this.connectionConfig.isAutoCommit() ? "commit;" : this.connectionConfig.transactionPrefix(), bl2);
    }

    public int getBusyTimeout() {
        return this.db.getConfig().getBusyTimeout();
    }

    public void setBusyTimeout(int n2) {
        this.db.getConfig().setBusyTimeout(n2);
        this.db.busy_timeout(n2);
    }

    @Override
    public boolean isClosed() {
        return this.db.isClosed();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        if (this.meta != null) {
            this.meta.close();
        }
        this.db.close();
    }

    protected void checkOpen() {
        if (this.isClosed()) {
            throw new SQLException("database connection closed");
        }
    }

    public String libversion() {
        this.checkOpen();
        return this.db.libversion();
    }

    @Override
    public void commit() {
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit()) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("commit;", this.getAutoCommit());
        this.db.exec(this.connectionConfig.transactionPrefix(), this.getAutoCommit());
    }

    @Override
    public void rollback() {
        this.checkOpen();
        if (this.connectionConfig.isAutoCommit()) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("rollback;", this.getAutoCommit());
        this.db.exec(this.connectionConfig.transactionPrefix(), this.getAutoCommit());
    }

    protected static String extractPragmasFromFilename(String string, String string2, Properties properties) {
        int n2 = string2.indexOf(63);
        if (n2 == -1) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2.substring(0, n2));
        int n3 = 0;
        String[] stringArray = string2.substring(n2 + 1).split("&");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[stringArray.length - 1 - i2].trim();
            if (string3.isEmpty()) continue;
            String[] stringArray2 = string3.split("=");
            String string4 = stringArray2[0].trim().toLowerCase();
            if (SQLiteConfig.pragmaSet.contains(string4)) {
                if (stringArray2.length == 1) {
                    throw new SQLException(String.format("Please specify a value for PRAGMA %s in URL %s", string4, string));
                }
                String string5 = stringArray2[1].trim();
                if (string5.isEmpty() || properties.containsKey(string4)) continue;
                properties.setProperty(string4, string5);
                continue;
            }
            stringBuilder.append(n3 == 0 ? (char)'?' : '&');
            stringBuilder.append(string3);
            ++n3;
        }
        String string6 = stringBuilder.toString();
        return string6;
    }
}

