/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.sqlite.JDBC;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.SQLiteOpenMode;

public class SQLiteConfig {
    public static final String DEFAULT_DATE_STRING_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final Properties pragmaTable;
    private int openModeFlag = 0;
    private final int busyTimeout;
    private final SQLiteConnectionConfig defaultConnectionConfig;
    private static final String[] OnOff = new String[]{"true", "false"};
    static final Set<String> pragmaSet = new TreeSet<String>();

    public SQLiteConfig() {
        this(new Properties());
    }

    public SQLiteConfig(Properties properties) {
        this.pragmaTable = properties;
        String string = this.pragmaTable.getProperty(Pragma.OPEN_MODE.pragmaName);
        if (string != null) {
            this.openModeFlag = Integer.parseInt(string);
        } else {
            this.setOpenMode(SQLiteOpenMode.READWRITE);
            this.setOpenMode(SQLiteOpenMode.CREATE);
        }
        this.setSharedCache(Boolean.parseBoolean(this.pragmaTable.getProperty(Pragma.SHARED_CACHE.pragmaName, "false")));
        this.setOpenMode(SQLiteOpenMode.OPEN_URI);
        this.busyTimeout = Integer.parseInt(this.pragmaTable.getProperty(Pragma.BUSY_TIMEOUT.pragmaName, "3000"));
        this.defaultConnectionConfig = SQLiteConnectionConfig.fromPragmaTable(this.pragmaTable);
    }

    public SQLiteConnectionConfig newConnectionConfig() {
        return this.defaultConnectionConfig.copyConfig();
    }

    public Connection createConnection(String string) {
        return JDBC.createConnection(string, this.toProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Connection connection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : Pragma.values()) {
            hashSet.add(object.pragmaName);
        }
        hashSet.remove(Pragma.OPEN_MODE.pragmaName);
        hashSet.remove(Pragma.SHARED_CACHE.pragmaName);
        hashSet.remove(Pragma.LOAD_EXTENSION.pragmaName);
        hashSet.remove(Pragma.DATE_PRECISION.pragmaName);
        hashSet.remove(Pragma.DATE_CLASS.pragmaName);
        hashSet.remove(Pragma.DATE_STRING_FORMAT.pragmaName);
        hashSet.remove(Pragma.PASSWORD.pragmaName);
        hashSet.remove(Pragma.HEXKEY_MODE.pragmaName);
        Statement statement = connection.createStatement();
        try {
            String string;
            Object object;
            if (this.pragmaTable.containsKey(Pragma.PASSWORD.pragmaName) && (string = this.pragmaTable.getProperty(Pragma.PASSWORD.pragmaName)) != null && !string.isEmpty()) {
                String string2 = this.pragmaTable.getProperty(Pragma.HEXKEY_MODE.pragmaName);
                object = HexKeyMode.SSE.name().equalsIgnoreCase(string2) ? "pragma hexkey = '%s'" : (HexKeyMode.SQLCIPHER.name().equalsIgnoreCase(string2) ? "pragma key = \"x'%s'\"" : "pragma key = '%s'");
                statement.execute(String.format((String)object, string.replace("'", "''")));
                statement.execute("select 1 from sqlite_master");
            }
            for (Object object2 : this.pragmaTable.keySet()) {
                String string3;
                object = object2.toString();
                if (!hashSet.contains(object) || (string3 = this.pragmaTable.getProperty((String)object)) == null) continue;
                statement.execute(String.format("pragma %s=%s", object, string3));
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void set(Pragma pragma, boolean bl2) {
        this.setPragma(pragma, Boolean.toString(bl2));
    }

    private void set(Pragma pragma, int n2) {
        this.setPragma(pragma, Integer.toString(n2));
    }

    private boolean getBoolean(Pragma pragma, String string) {
        return Boolean.parseBoolean(this.pragmaTable.getProperty(pragma.pragmaName, string));
    }

    public boolean isEnabledSharedCache() {
        return this.getBoolean(Pragma.SHARED_CACHE, "false");
    }

    public boolean isEnabledLoadExtension() {
        return this.getBoolean(Pragma.LOAD_EXTENSION, "false");
    }

    public int getOpenModeFlags() {
        return this.openModeFlag;
    }

    public void setPragma(Pragma pragma, String string) {
        this.pragmaTable.put(pragma.pragmaName, string);
    }

    public Properties toProperties() {
        this.pragmaTable.setProperty(Pragma.OPEN_MODE.pragmaName, Integer.toString(this.openModeFlag));
        this.pragmaTable.setProperty(Pragma.TRANSACTION_MODE.pragmaName, this.defaultConnectionConfig.getTransactionMode().getValue());
        this.pragmaTable.setProperty(Pragma.DATE_CLASS.pragmaName, this.defaultConnectionConfig.getDateClass().getValue());
        this.pragmaTable.setProperty(Pragma.DATE_PRECISION.pragmaName, this.defaultConnectionConfig.getDatePrecision().getValue());
        this.pragmaTable.setProperty(Pragma.DATE_STRING_FORMAT.pragmaName, this.defaultConnectionConfig.getDateStringFormat());
        return this.pragmaTable;
    }

    static DriverPropertyInfo[] getDriverPropertyInfo() {
        Pragma[] pragmaArray = Pragma.values();
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[pragmaArray.length];
        int n2 = 0;
        for (Pragma pragma : Pragma.values()) {
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(pragma.pragmaName, null);
            driverPropertyInfo.choices = pragma.choices;
            driverPropertyInfo.description = pragma.description;
            driverPropertyInfo.required = false;
            driverPropertyInfoArray[n2++] = driverPropertyInfo;
        }
        return driverPropertyInfoArray;
    }

    public void setOpenMode(SQLiteOpenMode sQLiteOpenMode) {
        this.openModeFlag |= sQLiteOpenMode.flag;
    }

    public void resetOpenMode(SQLiteOpenMode sQLiteOpenMode) {
        this.openModeFlag &= ~sQLiteOpenMode.flag;
    }

    public void setSharedCache(boolean bl2) {
        this.set(Pragma.SHARED_CACHE, bl2);
    }

    public void enableLoadExtension(boolean bl2) {
        this.set(Pragma.LOAD_EXTENSION, bl2);
    }

    public void setReadOnly(boolean bl2) {
        if (bl2) {
            this.setOpenMode(SQLiteOpenMode.READONLY);
            this.resetOpenMode(SQLiteOpenMode.CREATE);
            this.resetOpenMode(SQLiteOpenMode.READWRITE);
        } else {
            this.setOpenMode(SQLiteOpenMode.READWRITE);
            this.setOpenMode(SQLiteOpenMode.CREATE);
            this.resetOpenMode(SQLiteOpenMode.READONLY);
        }
    }

    public void setCacheSize(int n2) {
        this.set(Pragma.CACHE_SIZE, n2);
    }

    public void enableCaseSensitiveLike(boolean bl2) {
        this.set(Pragma.CASE_SENSITIVE_LIKE, bl2);
    }

    public void enableCountChanges(boolean bl2) {
        this.set(Pragma.COUNT_CHANGES, bl2);
    }

    public void setDefaultCacheSize(int n2) {
        this.set(Pragma.DEFAULT_CACHE_SIZE, n2);
    }

    public void enableEmptyResultCallBacks(boolean bl2) {
        this.set(Pragma.EMPTY_RESULT_CALLBACKS, bl2);
    }

    private static String[] toStringArray(PragmaValue[] pragmaValueArray) {
        String[] stringArray = new String[pragmaValueArray.length];
        for (int i2 = 0; i2 < pragmaValueArray.length; ++i2) {
            stringArray[i2] = pragmaValueArray[i2].getValue();
        }
        return stringArray;
    }

    public void setEncoding(Encoding encoding) {
        this.setPragma(Pragma.ENCODING, encoding.typeName);
    }

    public void enforceForeignKeys(boolean bl2) {
        this.set(Pragma.FOREIGN_KEYS, bl2);
    }

    public void enableFullColumnNames(boolean bl2) {
        this.set(Pragma.FULL_COLUMN_NAMES, bl2);
    }

    public void enableFullSync(boolean bl2) {
        this.set(Pragma.FULL_SYNC, bl2);
    }

    public void incrementalVacuum(int n2) {
        this.set(Pragma.INCREMENTAL_VACUUM, n2);
    }

    public void setJournalMode(JournalMode journalMode) {
        this.setPragma(Pragma.JOURNAL_MODE, journalMode.name());
    }

    public void setJounalSizeLimit(int n2) {
        this.set(Pragma.JOURNAL_SIZE_LIMIT, n2);
    }

    public void useLegacyFileFormat(boolean bl2) {
        this.set(Pragma.LEGACY_FILE_FORMAT, bl2);
    }

    public void setLockingMode(LockingMode lockingMode) {
        this.setPragma(Pragma.LOCKING_MODE, lockingMode.name());
    }

    public void setPageSize(int n2) {
        this.set(Pragma.PAGE_SIZE, n2);
    }

    public void setMaxPageCount(int n2) {
        this.set(Pragma.MAX_PAGE_COUNT, n2);
    }

    public void setReadUncommited(boolean bl2) {
        this.set(Pragma.READ_UNCOMMITED, bl2);
    }

    public void enableRecursiveTriggers(boolean bl2) {
        this.set(Pragma.RECURSIVE_TRIGGERS, bl2);
    }

    public void enableReverseUnorderedSelects(boolean bl2) {
        this.set(Pragma.REVERSE_UNORDERED_SELECTS, bl2);
    }

    public void enableShortColumnNames(boolean bl2) {
        this.set(Pragma.SHORT_COLUMN_NAMES, bl2);
    }

    public void setSynchronous(SynchronousMode synchronousMode) {
        this.setPragma(Pragma.SYNCHRONOUS, synchronousMode.name());
    }

    public void setHexKeyMode(HexKeyMode hexKeyMode) {
        this.setPragma(Pragma.HEXKEY_MODE, hexKeyMode.name());
    }

    public void setTempStore(TempStore tempStore) {
        this.setPragma(Pragma.TEMP_STORE, tempStore.name());
    }

    public void setTempStoreDirectory(String string) {
        this.setPragma(Pragma.TEMP_STORE_DIRECTORY, String.format("'%s'", string));
    }

    public void setUserVersion(int n2) {
        this.set(Pragma.USER_VERSION, n2);
    }

    public void setApplicationId(int n2) {
        this.set(Pragma.APPLICATION_ID, n2);
    }

    public void setTransactionMode(TransactionMode transactionMode) {
        this.defaultConnectionConfig.setTransactionMode(transactionMode);
    }

    public void setTransactionMode(String string) {
        this.setTransactionMode(TransactionMode.getMode(string));
    }

    public TransactionMode getTransactionMode() {
        return this.defaultConnectionConfig.getTransactionMode();
    }

    public void setDatePrecision(String string) {
        this.defaultConnectionConfig.setDatePrecision(DatePrecision.getPrecision(string));
    }

    public void setDateClass(String string) {
        this.defaultConnectionConfig.setDateClass(DateClass.getDateClass(string));
    }

    public void setDateStringFormat(String string) {
        this.defaultConnectionConfig.setDateStringFormat(string);
    }

    public void setBusyTimeout(int n2) {
        this.setPragma(Pragma.BUSY_TIMEOUT, Integer.toString(n2));
    }

    public int getBusyTimeout() {
        return this.busyTimeout;
    }

    static /* synthetic */ String[] access$000() {
        return OnOff;
    }

    static /* synthetic */ String[] access$100(PragmaValue[] pragmaValueArray) {
        return SQLiteConfig.toStringArray(pragmaValueArray);
    }

    static {
        for (Pragma pragma : Pragma.values()) {
            pragmaSet.add(pragma.pragmaName);
        }
    }

    public static enum DateClass implements PragmaValue
    {
        INTEGER,
        TEXT,
        REAL;


        @Override
        public String getValue() {
            return this.name();
        }

        public static DateClass getDateClass(String string) {
            return DateClass.valueOf(string.toUpperCase());
        }
    }

    public static enum DatePrecision implements PragmaValue
    {
        SECONDS,
        MILLISECONDS;


        @Override
        public String getValue() {
            return this.name();
        }

        public static DatePrecision getPrecision(String string) {
            return DatePrecision.valueOf(string.toUpperCase());
        }
    }

    public static enum TransactionMode implements PragmaValue
    {
        DEFFERED,
        DEFERRED,
        IMMEDIATE,
        EXCLUSIVE;


        @Override
        public String getValue() {
            return this.name();
        }

        public static TransactionMode getMode(String string) {
            if ("DEFFERED".equalsIgnoreCase(string)) {
                return DEFERRED;
            }
            return TransactionMode.valueOf(string.toUpperCase());
        }
    }

    public static enum HexKeyMode implements PragmaValue
    {
        NONE,
        SSE,
        SQLCIPHER;


        @Override
        public String getValue() {
            return this.name();
        }
    }

    public static enum TempStore implements PragmaValue
    {
        DEFAULT,
        FILE,
        MEMORY;


        @Override
        public String getValue() {
            return this.name();
        }
    }

    public static enum SynchronousMode implements PragmaValue
    {
        OFF,
        NORMAL,
        FULL;


        @Override
        public String getValue() {
            return this.name();
        }
    }

    public static enum LockingMode implements PragmaValue
    {
        NORMAL,
        EXCLUSIVE;


        @Override
        public String getValue() {
            return this.name();
        }
    }

    public static enum JournalMode implements PragmaValue
    {
        DELETE,
        TRUNCATE,
        PERSIST,
        MEMORY,
        WAL,
        OFF;


        @Override
        public String getValue() {
            return this.name();
        }
    }

    public static enum Encoding implements PragmaValue
    {
        UTF8("'UTF-8'"),
        UTF16("'UTF-16'"),
        UTF16_LITTLE_ENDIAN("'UTF-16le'"),
        UTF16_BIG_ENDIAN("'UTF-16be'"),
        UTF_8(UTF8),
        UTF_16(UTF16),
        UTF_16LE(UTF16_LITTLE_ENDIAN),
        UTF_16BE(UTF16_BIG_ENDIAN);

        public final String typeName;

        private Encoding(String string2) {
            this.typeName = string2;
        }

        private Encoding(Encoding encoding) {
            this.typeName = encoding.getValue();
        }

        @Override
        public String getValue() {
            return this.typeName;
        }

        public static Encoding getEncoding(String string) {
            return Encoding.valueOf(string.replaceAll("-", "_").toUpperCase());
        }
    }

    private static interface PragmaValue {
        public String getValue();
    }

    public static enum Pragma {
        OPEN_MODE("open_mode", "Database open-mode flag", null),
        SHARED_CACHE("shared_cache", "Enable SQLite Shared-Cache mode, native driver only", SQLiteConfig.access$000()),
        LOAD_EXTENSION("enable_load_extension", "Enable SQLite load_extention() function, native driver only", SQLiteConfig.access$000()),
        CACHE_SIZE("cache_size"),
        MMAP_SIZE("mmap_size"),
        CASE_SENSITIVE_LIKE("case_sensitive_like", SQLiteConfig.access$000()),
        COUNT_CHANGES("count_changes", SQLiteConfig.access$000()),
        DEFAULT_CACHE_SIZE("default_cache_size"),
        EMPTY_RESULT_CALLBACKS("empty_result_callback", SQLiteConfig.access$000()),
        ENCODING("encoding", SQLiteConfig.access$100(Encoding.values())),
        FOREIGN_KEYS("foreign_keys", SQLiteConfig.access$000()),
        FULL_COLUMN_NAMES("full_column_names", SQLiteConfig.access$000()),
        FULL_SYNC("fullsync", SQLiteConfig.access$000()),
        INCREMENTAL_VACUUM("incremental_vacuum"),
        JOURNAL_MODE("journal_mode", SQLiteConfig.access$100(JournalMode.values())),
        JOURNAL_SIZE_LIMIT("journal_size_limit"),
        LEGACY_FILE_FORMAT("legacy_file_format", SQLiteConfig.access$000()),
        LOCKING_MODE("locking_mode", SQLiteConfig.access$100(LockingMode.values())),
        PAGE_SIZE("page_size"),
        MAX_PAGE_COUNT("max_page_count"),
        READ_UNCOMMITED("read_uncommited", SQLiteConfig.access$000()),
        RECURSIVE_TRIGGERS("recursive_triggers", SQLiteConfig.access$000()),
        REVERSE_UNORDERED_SELECTS("reverse_unordered_selects", SQLiteConfig.access$000()),
        SECURE_DELETE("secure_delete", new String[]{"true", "false", "fast"}),
        SHORT_COLUMN_NAMES("short_column_names", SQLiteConfig.access$000()),
        SYNCHRONOUS("synchronous", SQLiteConfig.access$100(SynchronousMode.values())),
        TEMP_STORE("temp_store", SQLiteConfig.access$100(TempStore.values())),
        TEMP_STORE_DIRECTORY("temp_store_directory"),
        USER_VERSION("user_version"),
        APPLICATION_ID("application_id"),
        TRANSACTION_MODE("transaction_mode", SQLiteConfig.access$100(TransactionMode.values())),
        DATE_PRECISION("date_precision", "\"seconds\": Read and store integer dates as seconds from the Unix Epoch (SQLite standard).\n\"milliseconds\": (DEFAULT) Read and store integer dates as milliseconds from the Unix Epoch (Java standard).", SQLiteConfig.access$100(DatePrecision.values())),
        DATE_CLASS("date_class", "\"integer\": (Default) store dates as number of seconds or milliseconds from the Unix Epoch\n\"text\": store dates as a string of text\n\"real\": store dates as Julian Dates", SQLiteConfig.access$100(DateClass.values())),
        DATE_STRING_FORMAT("date_string_format", "Format to store and retrieve dates stored as text. Defaults to \"yyyy-MM-dd HH:mm:ss.SSS\"", null),
        BUSY_TIMEOUT("busy_timeout", null),
        HEXKEY_MODE("hexkey_mode", SQLiteConfig.access$100(HexKeyMode.values())),
        PASSWORD("password", null);

        public final String pragmaName;
        public final String[] choices;
        public final String description;

        private Pragma(String string2) {
            this(string2, null);
        }

        private Pragma(String string2, String[] stringArray) {
            this(string2, null, stringArray);
        }

        private Pragma(String string2, String string3, String[] stringArray) {
            this.pragmaName = string2;
            this.description = string3;
            this.choices = stringArray;
        }

        public final String getPragmaName() {
            return this.pragmaName;
        }
    }
}

