/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.DB;

public abstract class Function {
    public static final int FLAG_DETERMINISTIC = 2048;
    private SQLiteConnection conn;
    private DB db;
    long context = 0L;
    long value = 0L;
    int args = 0;

    public static final void create(Connection connection, String string, Function function) {
        Function.create(connection, string, function, 0);
    }

    public static final void create(Connection connection, String string, Function function, int n2) {
        if (connection == null || !(connection instanceof SQLiteConnection)) {
            throw new SQLException("connection must be to an SQLite db");
        }
        if (connection.isClosed()) {
            throw new SQLException("connection closed");
        }
        function.conn = (SQLiteConnection)connection;
        function.db = function.conn.getDatabase();
        if (string == null || string.length() > 255) {
            throw new SQLException("invalid function name: '" + string + "'");
        }
        if (function.db.create_function(string, function, n2) != 0) {
            throw new SQLException("error creating function");
        }
    }

    public static final void destroy(Connection connection, String string) {
        if (connection == null || !(connection instanceof SQLiteConnection)) {
            throw new SQLException("connection must be to an SQLite db");
        }
        ((SQLiteConnection)connection).getDatabase().destroy_function(string);
    }

    protected abstract void xFunc();

    protected final synchronized int args() {
        this.checkContext();
        return this.args;
    }

    protected final synchronized void result(byte[] byArray) {
        this.checkContext();
        this.db.result_blob(this.context, byArray);
    }

    protected final synchronized void result(double d2) {
        this.checkContext();
        this.db.result_double(this.context, d2);
    }

    protected final synchronized void result(int n2) {
        this.checkContext();
        this.db.result_int(this.context, n2);
    }

    protected final synchronized void result(long l2) {
        this.checkContext();
        this.db.result_long(this.context, l2);
    }

    protected final synchronized void result() {
        this.checkContext();
        this.db.result_null(this.context);
    }

    protected final synchronized void result(String string) {
        this.checkContext();
        this.db.result_text(this.context, string);
    }

    protected final synchronized void error(String string) {
        this.checkContext();
        this.db.result_error(this.context, string);
    }

    protected final synchronized String value_text(int n2) {
        this.checkValue(n2);
        return this.db.value_text(this, n2);
    }

    protected final synchronized byte[] value_blob(int n2) {
        this.checkValue(n2);
        return this.db.value_blob(this, n2);
    }

    protected final synchronized double value_double(int n2) {
        this.checkValue(n2);
        return this.db.value_double(this, n2);
    }

    protected final synchronized int value_int(int n2) {
        this.checkValue(n2);
        return this.db.value_int(this, n2);
    }

    protected final synchronized long value_long(int n2) {
        this.checkValue(n2);
        return this.db.value_long(this, n2);
    }

    protected final synchronized int value_type(int n2) {
        this.checkValue(n2);
        return this.db.value_type(this, n2);
    }

    private void checkContext() {
        if (this.conn == null || this.conn.getDatabase() == null || this.context == 0L) {
            throw new SQLException("no context, not allowed to read value");
        }
    }

    private void checkValue(int n2) {
        if (this.conn == null || this.conn.getDatabase() == null || this.value == 0L) {
            throw new SQLException("not in value access state");
        }
        if (n2 >= this.args) {
            throw new SQLException("arg " + n2 + " out bounds [0," + this.args + ")");
        }
    }

    public static abstract class Window
    extends Aggregate {
        protected abstract void xInverse();

        protected abstract void xValue();
    }

    public static abstract class Aggregate
    extends Function
    implements Cloneable {
        @Override
        protected final void xFunc() {
        }

        protected abstract void xStep();

        protected abstract void xFinal();

        public Object clone() {
            return super.clone();
        }
    }
}

