/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.util.LineBreakIterator;
import org.jfree.util.StringUtils;

public class SortedConfigurationWriter {
    private static final int ESCAPE_KEY = 0;
    private static final int ESCAPE_VALUE = 1;
    private static final int ESCAPE_COMMENT = 2;
    private static final String END_OF_LINE = StringUtils.getLineSeparator();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    protected String getDescription(String string) {
        return null;
    }

    public void save(String string, Configuration configuration) {
        this.save(new File(string), configuration);
    }

    public void save(File file, Configuration configuration) {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        this.save(bufferedOutputStream, configuration);
        bufferedOutputStream.close();
    }

    public void save(OutputStream outputStream, Configuration configuration) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = configuration.findPropertyKeys("");
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            arrayList.add((String)object);
        }
        Collections.sort(arrayList);
        object = new OutputStreamWriter(outputStream, "iso-8859-1");
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string = (String)arrayList.get(i2);
            String string2 = configuration.getConfigProperty(string);
            String string3 = this.getDescription(string);
            if (string3 != null) {
                this.writeDescription(string3, (Writer)object);
            }
            this.saveConvert(string, 0, (Writer)object);
            ((Writer)object).write("=");
            this.saveConvert(string2, 1, (Writer)object);
            ((Writer)object).write(END_OF_LINE);
        }
        ((OutputStreamWriter)object).flush();
    }

    private void writeDescription(String string, Writer writer) {
        if (string.length() == 0) {
            return;
        }
        writer.write("# ");
        writer.write(END_OF_LINE);
        LineBreakIterator lineBreakIterator = new LineBreakIterator(string);
        while (lineBreakIterator.hasNext()) {
            writer.write("# ");
            this.saveConvert((String)lineBreakIterator.next(), 2, writer);
            writer.write(END_OF_LINE);
        }
    }

    private void saveConvert(String string, int n2, Writer writer) {
        char[] cArray = string.toCharArray();
        block9: for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            switch (c2) {
                case ' ': {
                    if (n2 != 2 && (i2 == 0 || n2 == 0)) {
                        writer.write(92);
                    }
                    writer.write(32);
                    continue block9;
                }
                case '\\': {
                    writer.write(92);
                    writer.write(92);
                    continue block9;
                }
                case '\t': {
                    if (n2 == 2) {
                        writer.write(c2);
                        continue block9;
                    }
                    writer.write(92);
                    writer.write(116);
                    continue block9;
                }
                case '\n': {
                    writer.write(92);
                    writer.write(110);
                    continue block9;
                }
                case '\r': {
                    writer.write(92);
                    writer.write(114);
                    continue block9;
                }
                case '\f': {
                    if (n2 == 2) {
                        writer.write(c2);
                        continue block9;
                    }
                    writer.write(92);
                    writer.write(102);
                    continue block9;
                }
                case '!': 
                case '\"': 
                case '#': 
                case ':': 
                case '=': {
                    if (n2 == 2) {
                        writer.write(c2);
                        continue block9;
                    }
                    writer.write(92);
                    writer.write(c2);
                    continue block9;
                }
                default: {
                    if (c2 < ' ' || c2 > '~') {
                        writer.write(92);
                        writer.write(117);
                        writer.write(HEX_CHARS[c2 >> 12 & 0xF]);
                        writer.write(HEX_CHARS[c2 >> 8 & 0xF]);
                        writer.write(HEX_CHARS[c2 >> 4 & 0xF]);
                        writer.write(HEX_CHARS[c2 & 0xF]);
                        continue block9;
                    }
                    writer.write(c2);
                }
            }
        }
    }
}

