/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.util.ObjectUtilities;

public class ObjectTable
implements Serializable {
    private static final long serialVersionUID = -3968322452944912066L;
    private int rows;
    private int columns;
    private transient Object[][] data;
    private int rowIncrement;
    private int columnIncrement;

    public ObjectTable() {
        this(5, 5);
    }

    public ObjectTable(int n2) {
        this(n2, n2);
    }

    public ObjectTable(int n2, int n3) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        this.rows = 0;
        this.columns = 0;
        this.rowIncrement = n2;
        this.columnIncrement = n3;
        this.data = new Object[n2][];
    }

    public int getColumnIncrement() {
        return this.columnIncrement;
    }

    public int getRowIncrement() {
        return this.rowIncrement;
    }

    protected void ensureRowCapacity(int n2) {
        if (n2 >= this.data.length) {
            Object[][] objectArrayArray = new Object[n2 + this.rowIncrement][];
            System.arraycopy(this.data, 0, objectArrayArray, 0, this.data.length);
            this.data = objectArrayArray;
        }
    }

    public void ensureCapacity(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Row is invalid. " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("Column is invalid. " + n3);
        }
        this.ensureRowCapacity(n2);
        Object[] objectArray = this.data[n2];
        if (objectArray == null) {
            Object[] objectArray2 = new Object[Math.max(n3 + 1, this.columnIncrement)];
            this.data[n2] = objectArray2;
        } else if (n3 >= objectArray.length) {
            Object[] objectArray3 = new Object[n3 + this.columnIncrement];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
            this.data[n2] = objectArray3;
        }
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    protected Object getObject(int n2, int n3) {
        if (n2 < this.data.length) {
            Object[] objectArray = this.data[n2];
            if (objectArray == null) {
                return null;
            }
            if (n3 < objectArray.length) {
                return objectArray[n3];
            }
        }
        return null;
    }

    protected void setObject(int n2, int n3, Object object) {
        this.ensureCapacity(n2, n3);
        this.data[n2][n3] = object;
        this.rows = Math.max(this.rows, n2 + 1);
        this.columns = Math.max(this.columns, n3 + 1);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectTable)) {
            return false;
        }
        ObjectTable objectTable = (ObjectTable)object;
        if (this.getRowCount() != objectTable.getRowCount()) {
            return false;
        }
        if (this.getColumnCount() != objectTable.getColumnCount()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int i3 = 0; i3 < this.getColumnCount(); ++i3) {
                if (ObjectUtilities.equal(this.getObject(i2, i3), objectTable.getObject(i2, i3))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.rows;
        n2 = 29 * n2 + this.columns;
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        int n2 = this.data.length;
        objectOutputStream.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray = this.data[i2];
            objectOutputStream.writeBoolean(objectArray != null);
            if (objectArray == null) continue;
            int n3 = objectArray.length;
            objectOutputStream.writeInt(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                this.writeSerializedData(objectOutputStream, objectArray[i3]);
            }
        }
    }

    protected void writeSerializedData(ObjectOutputStream objectOutputStream, Object object) {
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.data = new Object[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2 = objectInputStream.readBoolean();
            if (!bl2) continue;
            int n3 = objectInputStream.readInt();
            Object[] objectArray = new Object[n3];
            this.data[i2] = objectArray;
            for (int i3 = 0; i3 < n3; ++i3) {
                objectArray[i3] = this.readSerializedData(objectInputStream);
            }
        }
    }

    protected Object readSerializedData(ObjectInputStream objectInputStream) {
        return objectInputStream.readObject();
    }

    public void clear() {
        this.rows = 0;
        this.columns = 0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            if (this.data[i2] == null) continue;
            Arrays.fill(this.data[i2], null);
        }
    }

    protected void copyColumn(int n2, int n3) {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            this.setObject(i2, n3, this.getObject(i2, n2));
        }
    }

    protected void copyRow(int n2, int n3) {
        this.ensureCapacity(n3, this.getColumnCount());
        Object[] objectArray = this.data[n2];
        if (objectArray == null) {
            Object[] objectArray2 = this.data[n3];
            if (objectArray2 != null) {
                Arrays.fill(objectArray2, null);
            }
        } else {
            this.data[n3] = (Object[])objectArray.clone();
        }
    }

    protected void setData(Object[][] objectArray, int n2) {
        if (objectArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.data = objectArray;
        this.rows = objectArray.length;
        this.columns = n2;
    }

    protected Object[][] getData() {
        return this.data;
    }
}

