/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EmptyStackException;

public final class FastStack
implements Serializable,
Cloneable {
    private Object[] contents;
    private int size;
    private int initialSize;

    public FastStack() {
        this.initialSize = 10;
    }

    public FastStack(int n2) {
        this.initialSize = Math.max(1, n2);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void push(Object object) {
        if (this.contents == null) {
            this.contents = new Object[this.initialSize];
            this.contents[0] = object;
            this.size = 1;
            return;
        }
        int n2 = this.size++;
        if (this.contents.length == this.size) {
            Object[] objectArray = new Object[this.size + this.initialSize];
            System.arraycopy(this.contents, 0, objectArray, 0, this.size);
            this.contents = objectArray;
        }
        this.contents[n2] = object;
    }

    public Object peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.contents[this.size - 1];
    }

    public Object pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        --this.size;
        Object object = this.contents[this.size];
        this.contents[this.size] = null;
        return object;
    }

    public Object clone() {
        try {
            FastStack fastStack = (FastStack)super.clone();
            if (this.contents != null) {
                fastStack.contents = (Object[])this.contents.clone();
            }
            return fastStack;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone not supported? Why?");
        }
    }

    public void clear() {
        this.size = 0;
        if (this.contents != null) {
            Arrays.fill(this.contents, null);
        }
    }

    public Object get(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.contents[n2];
    }
}

