/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.Arrays;

public class ArrayUtilities {
    private ArrayUtilities() {
    }

    public static float[][] clone(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        float[][] fArrayArray = new float[fArray.length][];
        System.arraycopy(fArray, 0, fArrayArray, 0, fArray.length);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float[] fArray2 = fArray[i2];
            float[] fArray3 = new float[fArray2.length];
            System.arraycopy(fArray2, 0, fArray3, 0, fArray2.length);
            fArrayArray[i2] = fArray3;
        }
        return fArrayArray;
    }

    public static boolean equalReferencesInArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null && objectArray2[i2] != null) {
                return false;
            }
            if (objectArray2[i2] == null && objectArray[i2] != null) {
                return false;
            }
            if (objectArray[i2] == objectArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(float[][] fArray, float[][] fArray2) {
        if (fArray == null) {
            return fArray2 == null;
        }
        if (fArray2 == null) {
            return false;
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (Arrays.equals(fArray[i2], fArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasDuplicateItems(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            for (int i3 = 0; i3 < i2; ++i3) {
                Object object = objectArray[i2];
                Object object2 = objectArray[i3];
                if (object == null || object2 == null || !object.equals(object2)) continue;
                return true;
            }
        }
        return false;
    }

    public static int compareVersionArrays(Comparable[] comparableArray, Comparable[] comparableArray2) {
        int n2 = Math.min(comparableArray.length, comparableArray2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable = comparableArray[i2];
            Comparable comparable2 = comparableArray2[i2];
            if (comparable == null && comparable2 == null) continue;
            if (comparable == null) {
                return 1;
            }
            if (comparable2 == null) {
                return -1;
            }
            int n3 = comparable.compareTo(comparable2);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }
}

