/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.jfree.util.Log;

public class ActionRadioButton
extends JRadioButton {
    private Action action;
    private ActionEnablePropertyChangeHandler propertyChangeHandler;

    public ActionRadioButton() {
    }

    public ActionRadioButton(String string) {
        super(string);
    }

    public ActionRadioButton(String string, Icon icon) {
        super(string, icon);
    }

    public ActionRadioButton(Icon icon) {
        super(icon);
    }

    public ActionRadioButton(Action action) {
        this.setAction(action);
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    private ActionEnablePropertyChangeHandler getPropertyChangeHandler() {
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new ActionEnablePropertyChangeHandler();
        }
        return this.propertyChangeHandler;
    }

    @Override
    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        if (this.getAction() != null) {
            this.getAction().setEnabled(bl2);
        }
    }

    @Override
    public void setAction(Action action) {
        Serializable serializable;
        Object object;
        Action action2 = this.getAction();
        if (action2 != null) {
            this.removeActionListener(action2);
            action2.removePropertyChangeListener(this.getPropertyChangeHandler());
            object = action2.getValue("AcceleratorKey");
            if (object instanceof KeyStroke && object != null) {
                serializable = (KeyStroke)object;
                this.unregisterKeyboardAction((KeyStroke)serializable);
            }
        }
        this.action = action;
        if (this.action != null) {
            this.addActionListener(action);
            action.addPropertyChangeListener(this.getPropertyChangeHandler());
            this.setText((String)action.getValue("Name"));
            this.setToolTipText((String)action.getValue("ShortDescription"));
            this.setIcon((Icon)action.getValue("SmallIcon"));
            this.setEnabled(this.action.isEnabled());
            object = action.getValue("MnemonicKey");
            if (object != null) {
                if (object instanceof Character) {
                    serializable = (Character)object;
                    this.setMnemonic(((Character)serializable).charValue());
                } else if (object instanceof Integer) {
                    serializable = (Integer)object;
                    this.setMnemonic((Integer)serializable);
                }
            }
            if ((object = action.getValue("AcceleratorKey")) instanceof KeyStroke && object != null) {
                serializable = (KeyStroke)object;
                this.registerKeyboardAction(action, (KeyStroke)serializable, 2);
            }
        }
    }

    private class ActionEnablePropertyChangeHandler
    implements PropertyChangeListener {
        private ActionEnablePropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    ActionRadioButton.this.setEnabled(ActionRadioButton.this.getAction().isEnabled());
                } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                    ActionRadioButton.this.setIcon((Icon)ActionRadioButton.this.getAction().getValue("SmallIcon"));
                } else if (propertyChangeEvent.getPropertyName().equals("Name")) {
                    ActionRadioButton.this.setText((String)ActionRadioButton.this.getAction().getValue("Name"));
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    ActionRadioButton.this.setToolTipText((String)ActionRadioButton.this.getAction().getValue("ShortDescription"));
                }
                Action action = ActionRadioButton.this.getAction();
                if (propertyChangeEvent.getPropertyName().equals("AcceleratorKey")) {
                    Object object2;
                    KeyStroke keyStroke = (KeyStroke)propertyChangeEvent.getOldValue();
                    if (keyStroke != null) {
                        ActionRadioButton.this.unregisterKeyboardAction(keyStroke);
                    }
                    if ((object2 = action.getValue("AcceleratorKey")) instanceof KeyStroke && object2 != null) {
                        KeyStroke keyStroke2 = (KeyStroke)object2;
                        ActionRadioButton.this.registerKeyboardAction(action, keyStroke2, 2);
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey") && (object = action.getValue("MnemonicKey")) != null) {
                    if (object instanceof Character) {
                        Character c2 = (Character)object;
                        ActionRadioButton.this.setMnemonic(c2.charValue());
                    } else if (object instanceof Integer) {
                        Integer n2 = (Integer)object;
                        ActionRadioButton.this.setMnemonic(n2);
                    }
                }
            }
            catch (Exception exception) {
                Log.warn("Error on PropertyChange in ActionButton: ", exception);
            }
        }
    }
}

