/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.jfree.util.Log;

public class ActionMenuItem
extends JMenuItem {
    private Action action;
    private ActionEnablePropertyChangeHandler propertyChangeHandler;

    public ActionMenuItem() {
    }

    public ActionMenuItem(Icon icon) {
        super(icon);
    }

    public ActionMenuItem(String string) {
        super(string);
    }

    public ActionMenuItem(String string, Icon icon) {
        super(string, icon);
    }

    public ActionMenuItem(String string, int n2) {
        super(string, n2);
    }

    public ActionMenuItem(Action action) {
        this.setAction(action);
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    private ActionEnablePropertyChangeHandler getPropertyChangeHandler() {
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new ActionEnablePropertyChangeHandler();
        }
        return this.propertyChangeHandler;
    }

    @Override
    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        if (this.getAction() != null) {
            this.getAction().setEnabled(bl2);
        }
    }

    @Override
    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (action2 != null) {
            this.removeActionListener(action2);
            action2.removePropertyChangeListener(this.getPropertyChangeHandler());
            this.setAccelerator(null);
        }
        this.action = action;
        if (this.action != null) {
            this.addActionListener(action);
            action.addPropertyChangeListener(this.getPropertyChangeHandler());
            this.setText((String)action.getValue("Name"));
            this.setToolTipText((String)action.getValue("ShortDescription"));
            this.setIcon((Icon)action.getValue("SmallIcon"));
            this.setEnabled(this.action.isEnabled());
            Object object = action.getValue("MnemonicKey");
            if (object != null) {
                if (object instanceof Character) {
                    Character c2 = (Character)object;
                    this.setMnemonic(c2.charValue());
                } else if (object instanceof Integer) {
                    Integer n2 = (Integer)object;
                    this.setMnemonic(n2);
                }
            } else {
                this.setMnemonic(0);
            }
            object = action.getValue("AcceleratorKey");
            if (object instanceof KeyStroke) {
                this.setAccelerator((KeyStroke)object);
            }
        }
    }

    private class ActionEnablePropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    ActionMenuItem.this.setEnabled(ActionMenuItem.this.getAction().isEnabled());
                } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                    ActionMenuItem.this.setIcon((Icon)ActionMenuItem.this.getAction().getValue("SmallIcon"));
                } else if (propertyChangeEvent.getPropertyName().equals("Name")) {
                    ActionMenuItem.this.setText((String)ActionMenuItem.this.getAction().getValue("Name"));
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    ActionMenuItem.this.setToolTipText((String)ActionMenuItem.this.getAction().getValue("ShortDescription"));
                }
                Action action = ActionMenuItem.this.getAction();
                if (propertyChangeEvent.getPropertyName().equals("AcceleratorKey")) {
                    ActionMenuItem.this.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
                } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                    Object object = action.getValue("MnemonicKey");
                    if (object != null) {
                        if (object instanceof Character) {
                            Character c2 = (Character)object;
                            ActionMenuItem.this.setMnemonic(c2.charValue());
                        } else if (object instanceof Integer) {
                            Integer n2 = (Integer)object;
                            ActionMenuItem.this.setMnemonic(n2);
                        }
                    } else {
                        ActionMenuItem.this.setMnemonic(0);
                    }
                }
            }
            catch (Exception exception) {
                Log.warn("Error on PropertyChange in ActionButton: ", exception);
            }
        }
    }
}

