/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.about;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jfree.ui.SortableTableModel;
import org.jfree.util.ResourceBundleWrapper;

public class SystemPropertiesTableModel
extends SortableTableModel {
    private List properties = new ArrayList();
    private String nameColumnLabel;
    private String valueColumnLabel;

    public SystemPropertiesTableModel() {
        Object object;
        try {
            object = System.getProperties();
            for (String string : ((Properties)object).keySet()) {
                String string2 = System.getProperty(string);
                SystemProperty systemProperty = new SystemProperty(string, string2);
                this.properties.add(systemProperty);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Collections.sort(this.properties, new SystemPropertyComparator(true));
        object = "org.jfree.ui.about.resources.AboutResources";
        ResourceBundle resourceBundle = ResourceBundleWrapper.getBundle("org.jfree.ui.about.resources.AboutResources");
        this.nameColumnLabel = resourceBundle.getString("system-properties-table.column.name");
        this.valueColumnLabel = resourceBundle.getString("system-properties-table.column.value");
    }

    @Override
    public boolean isSortable(int n2) {
        return n2 == 0;
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n2) {
        if (n2 == 0) {
            return this.nameColumnLabel;
        }
        return this.valueColumnLabel;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        SystemProperty systemProperty = (SystemProperty)this.properties.get(n2);
        if (n3 == 0) {
            return systemProperty.getName();
        }
        if (n3 == 1) {
            return systemProperty.getValue();
        }
        return null;
    }

    @Override
    public void sortByColumn(int n2, boolean bl2) {
        if (this.isSortable(n2)) {
            super.sortByColumn(n2, bl2);
            Collections.sort(this.properties, new SystemPropertyComparator(bl2));
        }
    }

    protected static class SystemPropertyComparator
    implements Comparator {
        private boolean ascending;

        public SystemPropertyComparator(boolean bl2) {
            this.ascending = bl2;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof SystemProperty && object2 instanceof SystemProperty) {
                SystemProperty systemProperty = (SystemProperty)object;
                SystemProperty systemProperty2 = (SystemProperty)object2;
                if (this.ascending) {
                    return systemProperty.getName().compareTo(systemProperty2.getName());
                }
                return systemProperty2.getName().compareTo(systemProperty.getName());
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SystemPropertyComparator)) {
                return false;
            }
            SystemPropertyComparator systemPropertyComparator = (SystemPropertyComparator)object;
            return this.ascending == systemPropertyComparator.ascending;
        }

        public int hashCode() {
            return this.ascending ? 1 : 0;
        }
    }

    protected static class SystemProperty {
        private String name;
        private String value;

        public SystemProperty(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

