/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public final class OverlayLayout
implements LayoutManager {
    private boolean ignoreInvisible;

    public OverlayLayout(boolean bl2) {
        this.ignoreInvisible = bl2;
    }

    public OverlayLayout() {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            Rectangle rectangle = container.getBounds();
            int n2 = rectangle.width - insets.left - insets.right;
            int n3 = rectangle.height - insets.top - insets.bottom;
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                Component component = componentArray[i2];
                if (!componentArray[i2].isVisible() && this.ignoreInvisible) continue;
                component.setBounds(insets.left, insets.top, n2, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            int n3 = 0;
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!componentArray[i2].isVisible() && this.ignoreInvisible) continue;
                Dimension dimension = componentArray[i2].getMinimumSize();
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                if (dimension.width <= n3) continue;
                n3 = dimension.width;
            }
            return new Dimension(n3 + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            int n3 = 0;
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!componentArray[i2].isVisible() && this.ignoreInvisible) continue;
                Dimension dimension = componentArray[i2].getPreferredSize();
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                if (dimension.width <= n3) continue;
                n3 = dimension.width;
            }
            return new Dimension(n3 + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }
    }
}

