/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KeyedComboBoxModel
implements ComboBoxModel {
    private int selectedItemIndex;
    private Object selectedItemValue;
    private ArrayList data = new ArrayList();
    private ArrayList listdatalistener = new ArrayList();
    private transient ListDataListener[] tempListeners;
    private boolean allowOtherValue;

    public KeyedComboBoxModel() {
    }

    public KeyedComboBoxModel(Object[] objectArray, Object[] objectArray2) {
        this();
        this.setData(objectArray, objectArray2);
    }

    public void setData(Object[] objectArray, Object[] objectArray2) {
        if (objectArray2.length != objectArray.length) {
            throw new IllegalArgumentException("Values and text must have the same length.");
        }
        this.data.clear();
        this.data.ensureCapacity(objectArray.length);
        for (int i2 = 0; i2 < objectArray2.length; ++i2) {
            this.add(objectArray[i2], objectArray2[i2]);
        }
        this.selectedItemIndex = -1;
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.data.size() - 1);
        this.fireListDataEvent(listDataEvent);
    }

    protected synchronized void fireListDataEvent(ListDataEvent listDataEvent) {
        if (this.tempListeners == null) {
            this.tempListeners = this.listdatalistener.toArray(new ListDataListener[this.listdatalistener.size()]);
        }
        ListDataListener[] listDataListenerArray = this.tempListeners;
        for (int i2 = 0; i2 < listDataListenerArray.length; ++i2) {
            ListDataListener listDataListener = listDataListenerArray[i2];
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItemValue;
    }

    public void setSelectedKey(Object object) {
        if (object == null) {
            this.selectedItemIndex = -1;
            this.selectedItemValue = null;
        } else {
            int n2 = this.findDataElementIndex(object);
            if (n2 == -1) {
                this.selectedItemIndex = -1;
                this.selectedItemValue = null;
            } else {
                this.selectedItemIndex = n2;
                this.selectedItemValue = this.getElementAt(this.selectedItemIndex);
            }
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object == null) {
            this.selectedItemIndex = -1;
            this.selectedItemValue = null;
        } else {
            int n2 = this.findElementIndex(object);
            if (n2 == -1) {
                if (this.isAllowOtherValue()) {
                    this.selectedItemIndex = -1;
                    this.selectedItemValue = object;
                } else {
                    this.selectedItemIndex = -1;
                    this.selectedItemValue = null;
                }
            } else {
                this.selectedItemIndex = n2;
                this.selectedItemValue = this.getElementAt(this.selectedItemIndex);
            }
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    private boolean isAllowOtherValue() {
        return this.allowOtherValue;
    }

    public void setAllowOtherValue(boolean bl2) {
        this.allowOtherValue = bl2;
    }

    @Override
    public synchronized void addListDataListener(ListDataListener listDataListener) {
        if (listDataListener == null) {
            throw new NullPointerException();
        }
        this.listdatalistener.add(listDataListener);
        this.tempListeners = null;
    }

    @Override
    public Object getElementAt(int n2) {
        if (n2 >= this.data.size()) {
            return null;
        }
        ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(n2);
        if (comboBoxItemPair == null) {
            return null;
        }
        return comboBoxItemPair.getValue();
    }

    public Object getKeyAt(int n2) {
        if (n2 >= this.data.size()) {
            return null;
        }
        if (n2 < 0) {
            return null;
        }
        ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(n2);
        if (comboBoxItemPair == null) {
            return null;
        }
        return comboBoxItemPair.getKey();
    }

    public Object getSelectedKey() {
        return this.getKeyAt(this.selectedItemIndex);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listdatalistener.remove(listDataListener);
        this.tempListeners = null;
    }

    private int findDataElementIndex(Object object) {
        if (object == null) {
            throw new NullPointerException("Item to find must not be null");
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(i2);
            if (!object.equals(comboBoxItemPair.getKey())) continue;
            return i2;
        }
        return -1;
    }

    public int findElementIndex(Object object) {
        if (object == null) {
            throw new NullPointerException("Item to find must not be null");
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            ComboBoxItemPair comboBoxItemPair = (ComboBoxItemPair)this.data.get(i2);
            if (!object.equals(comboBoxItemPair.getValue())) continue;
            return i2;
        }
        return -1;
    }

    public void removeDataElement(Object object) {
        int n2 = this.findDataElementIndex(object);
        if (n2 == -1) {
            return;
        }
        this.data.remove(n2);
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, n2, n2);
        this.fireListDataEvent(listDataEvent);
    }

    public void add(Object object, Object object2) {
        ComboBoxItemPair comboBoxItemPair = new ComboBoxItemPair(object, object2);
        this.data.add(comboBoxItemPair);
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, this.data.size() - 2, this.data.size() - 2);
        this.fireListDataEvent(listDataEvent);
    }

    public void clear() {
        int n2 = this.getSize();
        this.data.clear();
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, 0, n2 - 1);
        this.fireListDataEvent(listDataEvent);
    }

    private static class ComboBoxItemPair {
        private Object key;
        private Object value;

        public ComboBoxItemPair(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }
    }
}

