/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedString;
import java.text.BreakIterator;
import org.jfree.base.BaseBoot;
import org.jfree.text.TextBlock;
import org.jfree.text.TextFragment;
import org.jfree.text.TextLine;
import org.jfree.text.TextMeasurer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectUtilities;

public class TextUtilities {
    protected static final LogContext logger = Log.createContext(TextUtilities.class);
    private static boolean drawStringsWithFontAttributes = false;
    private static boolean useDrawRotatedStringWorkaround;
    private static boolean useFontMetricsGetStringBounds;

    private TextUtilities() {
    }

    public static TextBlock createTextBlock(String string, Font font, Paint paint) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        TextBlock textBlock = new TextBlock();
        String string2 = string;
        boolean bl2 = string.length() > 0;
        int n2 = 0;
        while (bl2) {
            int n3 = string2.indexOf("\n");
            if (n3 > n2) {
                String string3 = string2.substring(n2, n3);
                if (n3 < string2.length() - 1) {
                    textBlock.addLine(string3, font, paint);
                    string2 = string2.substring(n3 + 1);
                    continue;
                }
                bl2 = false;
                continue;
            }
            if (n3 == n2) {
                if (n3 < string2.length() - 1) {
                    string2 = string2.substring(n3 + 1);
                    continue;
                }
                bl2 = false;
                continue;
            }
            textBlock.addLine(string2, font, paint);
            bl2 = false;
        }
        return textBlock;
    }

    public static TextBlock createTextBlock(String string, Font font, Paint paint, float f2, TextMeasurer textMeasurer) {
        return TextUtilities.createTextBlock(string, font, paint, f2, Integer.MAX_VALUE, textMeasurer);
    }

    public static TextBlock createTextBlock(String string, Font font, Paint paint, float f2, int n2, TextMeasurer textMeasurer) {
        TextBlock textBlock = new TextBlock();
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n3 < n5 && n4 < n2) {
            int n6 = TextUtilities.nextLineBreak(string, n3, f2, breakIterator, textMeasurer);
            if (n6 == -1) {
                textBlock.addLine(string.substring(n3), font, paint);
                return textBlock;
            }
            if (n6 == n3) {
                ++n6;
            }
            textBlock.addLine(string.substring(n3, n6), font, paint);
            ++n4;
            for (n3 = n6; n3 < string.length() && string.charAt(n3) == '\n'; ++n3) {
            }
        }
        if (n3 < n5) {
            TextLine textLine = textBlock.getLastLine();
            TextFragment textFragment = textLine.getLastTextFragment();
            String string2 = textFragment.getText();
            String string3 = "...";
            if (string2.length() > 3) {
                string3 = string2.substring(0, string2.length() - 3) + "...";
            }
            textLine.removeFragment(textFragment);
            TextFragment textFragment2 = new TextFragment(string3, textFragment.getFont(), textFragment.getPaint());
            textLine.addFragment(textFragment2);
        }
        return textBlock;
    }

    private static int nextLineBreak(String string, int n2, float f2, BreakIterator breakIterator, TextMeasurer textMeasurer) {
        int n3;
        int n4 = n2;
        float f3 = 0.0f;
        boolean bl2 = true;
        int n5 = string.indexOf(10, n2);
        if (n5 < 0) {
            n5 = Integer.MAX_VALUE;
        }
        while ((n3 = breakIterator.following(n4)) != -1) {
            if ((f3 += textMeasurer.getStringWidth(string, n4, n3)) > f2) {
                if (bl2) {
                    while (textMeasurer.getStringWidth(string, n2, n3) > f2) {
                        if (--n3 > n2) continue;
                        return n3;
                    }
                    return n3;
                }
                n3 = breakIterator.previous();
                return n3;
            }
            if (n3 > n5) {
                return n5;
            }
            bl2 = false;
            n4 = n3;
        }
        return -1;
    }

    public static Rectangle2D getTextBounds(String string, Graphics2D graphics2D, FontMetrics fontMetrics) {
        Rectangle2D rectangle2D;
        if (useFontMetricsGetStringBounds) {
            rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            LineMetrics lineMetrics = fontMetrics.getFont().getLineMetrics(string, graphics2D.getFontRenderContext());
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), lineMetrics.getHeight());
        } else {
            double d2 = fontMetrics.stringWidth(string);
            double d3 = fontMetrics.getHeight();
            if (logger.isDebugEnabled()) {
                logger.debug("Height = " + d3);
            }
            rectangle2D = new Rectangle2D.Double(0.0, -fontMetrics.getAscent(), d2, d3);
        }
        return rectangle2D;
    }

    public static Rectangle2D drawAlignedString(String string, Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        float[] fArray = TextUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor, double_);
        ((Rectangle2D)double_).setRect(f2 + fArray[0], f3 + fArray[1] + fArray[2], ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
        if (!drawStringsWithFontAttributes) {
            graphics2D.drawString(string, f2 + fArray[0], f3 + fArray[1]);
        } else {
            AttributedString attributedString = new AttributedString(string, graphics2D.getFont().getAttributes());
            graphics2D.drawString(attributedString.getIterator(), f2 + fArray[0], f3 + fArray[1]);
        }
        return double_;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D graphics2D, String string, TextAnchor textAnchor, Rectangle2D rectangle2D) {
        float[] fArray = new float[3];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f2 = lineMetrics.getAscent();
        fArray[2] = -f2;
        float f3 = f2 / 2.0f;
        float f4 = lineMetrics.getDescent();
        float f5 = lineMetrics.getLeading();
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (textAnchor.isHorizontalCenter()) {
            f6 = (float)(-rectangle2D2.getWidth()) / 2.0f;
        } else if (textAnchor.isRight()) {
            f6 = (float)(-rectangle2D2.getWidth());
        }
        if (textAnchor.isTop()) {
            f7 = -f4 - f5 + (float)rectangle2D2.getHeight();
        } else if (textAnchor.isHalfAscent()) {
            f7 = f3;
        } else if (textAnchor.isVerticalCenter()) {
            f7 = -f4 - f5 + (float)(rectangle2D2.getHeight() / 2.0);
        } else if (textAnchor.isBaseline()) {
            f7 = 0.0f;
        } else if (textAnchor.isBottom()) {
            f7 = -lineMetrics.getDescent() - lineMetrics.getLeading();
        }
        if (rectangle2D != null) {
            rectangle2D.setRect(rectangle2D2);
        }
        fArray[0] = f6;
        fArray[1] = f7;
        return fArray;
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, double d2, float f2, float f3) {
        TextUtilities.drawRotatedString(string, graphics2D, f2, f3, d2, f2, f3);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f2, float f3, double d2, float f4, float f5) {
        if (string == null || string.equals("")) {
            return;
        }
        if (d2 == 0.0) {
            TextUtilities.drawAlignedString(string, graphics2D, f2, f3, TextAnchor.BASELINE_LEFT);
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d2, f4, f5);
        graphics2D.transform(affineTransform2);
        if (useDrawRotatedStringWorkaround) {
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, f2, f3);
        } else if (!drawStringsWithFontAttributes) {
            graphics2D.drawString(string, f2, f3);
        } else {
            AttributedString attributedString = new AttributedString(string, graphics2D.getFont().getAttributes());
            graphics2D.drawString(attributedString.getIterator(), f2, f3);
        }
        graphics2D.setTransform(affineTransform);
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor, double d2, float f4, float f5) {
        if (string == null || string.equals("")) {
            return;
        }
        if (d2 == 0.0) {
            TextUtilities.drawAlignedString(string, graphics2D, f2, f3, textAnchor);
        } else {
            float[] fArray = TextUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor);
            TextUtilities.drawRotatedString(string, graphics2D, f2 + fArray[0], f3 + fArray[1], d2, f4, f5);
        }
    }

    public static void drawRotatedString(String string, Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor, double d2, TextAnchor textAnchor2) {
        if (string == null || string.equals("")) {
            return;
        }
        if (d2 == 0.0) {
            TextUtilities.drawAlignedString(string, graphics2D, f2, f3, textAnchor);
        } else {
            float[] fArray = TextUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor);
            float[] fArray2 = TextUtilities.deriveRotationAnchorOffsets(graphics2D, string, textAnchor2);
            TextUtilities.drawRotatedString(string, graphics2D, f2 + fArray[0], f3 + fArray[1], d2, f2 + fArray[0] + fArray2[0], f3 + fArray[1] + fArray2[1]);
        }
    }

    public static Shape calculateRotatedStringBounds(String string, Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor, double d2, TextAnchor textAnchor2) {
        if (string == null || string.equals("")) {
            return null;
        }
        float[] fArray = TextUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor);
        if (logger.isDebugEnabled()) {
            logger.debug("TextBoundsAnchorOffsets = " + fArray[0] + ", " + fArray[1]);
        }
        float[] fArray2 = TextUtilities.deriveRotationAnchorOffsets(graphics2D, string, textAnchor2);
        if (logger.isDebugEnabled()) {
            logger.debug("RotationAnchorOffsets = " + fArray2[0] + ", " + fArray2[1]);
        }
        Shape shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f2 + fArray[0], f3 + fArray[1], d2, f2 + fArray[0] + fArray2[0], f3 + fArray[1] + fArray2[1]);
        return shape;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D graphics2D, String string, TextAnchor textAnchor) {
        float[] fArray = new float[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f2 = lineMetrics.getAscent();
        float f3 = f2 / 2.0f;
        float f4 = lineMetrics.getDescent();
        float f5 = lineMetrics.getLeading();
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (textAnchor.isHorizontalCenter()) {
            f6 = (float)(-rectangle2D.getWidth()) / 2.0f;
        } else if (textAnchor.isRight()) {
            f6 = (float)(-rectangle2D.getWidth());
        }
        if (textAnchor.isTop()) {
            f7 = -f4 - f5 + (float)rectangle2D.getHeight();
        } else if (textAnchor.isHalfAscent()) {
            f7 = f3;
        } else if (textAnchor.isVerticalCenter()) {
            f7 = -f4 - f5 + (float)(rectangle2D.getHeight() / 2.0);
        } else if (textAnchor.isBaseline()) {
            f7 = 0.0f;
        } else if (textAnchor.isBottom()) {
            f7 = -lineMetrics.getDescent() - lineMetrics.getLeading();
        }
        fArray[0] = f6;
        fArray[1] = f7;
        return fArray;
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D graphics2D, String string, TextAnchor textAnchor) {
        float[] fArray = new float[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = graphics2D.getFont().getLineMetrics(string, fontRenderContext);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        float f2 = lineMetrics.getAscent();
        float f3 = f2 / 2.0f;
        float f4 = lineMetrics.getDescent();
        float f5 = lineMetrics.getLeading();
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (textAnchor.isLeft()) {
            f6 = 0.0f;
        } else if (textAnchor.isHorizontalCenter()) {
            f6 = (float)rectangle2D.getWidth() / 2.0f;
        } else if (textAnchor.isRight()) {
            f6 = (float)rectangle2D.getWidth();
        }
        if (textAnchor.isTop()) {
            f7 = f4 + f5 - (float)rectangle2D.getHeight();
        } else if (textAnchor.isVerticalCenter()) {
            f7 = f4 + f5 - (float)(rectangle2D.getHeight() / 2.0);
        } else if (textAnchor.isHalfAscent()) {
            f7 = -f3;
        } else if (textAnchor.isBaseline()) {
            f7 = 0.0f;
        } else if (textAnchor.isBottom()) {
            f7 = lineMetrics.getDescent() + lineMetrics.getLeading();
        }
        fArray[0] = f6;
        fArray[1] = f7;
        return fArray;
    }

    public static Shape calculateRotatedStringBounds(String string, Graphics2D graphics2D, float f2, float f3, double d2, float f4, float f5) {
        if (string == null || string.equals("")) {
            return null;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        Shape shape = affineTransform.createTransformedShape(rectangle2D);
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d2, f4, f5);
        Shape shape2 = affineTransform2.createTransformedShape(shape);
        return shape2;
    }

    public static boolean getUseFontMetricsGetStringBounds() {
        return useFontMetricsGetStringBounds;
    }

    public static void setUseFontMetricsGetStringBounds(boolean bl2) {
        useFontMetricsGetStringBounds = bl2;
    }

    public static boolean isUseDrawRotatedStringWorkaround() {
        return useDrawRotatedStringWorkaround;
    }

    public static void setUseDrawRotatedStringWorkaround(boolean bl2) {
        useDrawRotatedStringWorkaround = bl2;
    }

    public static boolean getDrawStringsWithFontAttributes() {
        return drawStringsWithFontAttributes;
    }

    public static void setDrawStringsWithFontAttributes(boolean bl2) {
        drawStringsWithFontAttributes = bl2;
    }

    static {
        try {
            boolean bl2 = ObjectUtilities.isJDK14();
            String string = BaseBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.text.UseDrawRotatedStringWorkaround", "auto");
            useDrawRotatedStringWorkaround = string.equals("auto") ? !bl2 : string.equals("true");
            String string2 = BaseBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.text.UseFontMetricsGetStringBounds", "auto");
            useFontMetricsGetStringBounds = string2.equals("auto") ? bl2 : string2.equals("true");
        }
        catch (Exception exception) {
            useDrawRotatedStringWorkaround = true;
            useFontMetricsGetStringBounds = true;
        }
    }
}

