/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.text.TextFragment;
import org.jfree.ui.Size2D;
import org.jfree.ui.TextAnchor;

public class TextLine
implements Serializable {
    private static final long serialVersionUID = 7100085690160465444L;
    private List fragments;

    public TextLine() {
        this.fragments = new ArrayList();
    }

    public TextLine(String string) {
        this(string, TextFragment.DEFAULT_FONT);
    }

    public TextLine(String string, Font font) {
        this.fragments = new ArrayList();
        TextFragment textFragment = new TextFragment(string, font);
        this.fragments.add(textFragment);
    }

    public TextLine(String string, Font font, Paint paint) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.fragments = new ArrayList();
        TextFragment textFragment = new TextFragment(string, font, paint);
        this.fragments.add(textFragment);
    }

    public void addFragment(TextFragment textFragment) {
        this.fragments.add(textFragment);
    }

    public void removeFragment(TextFragment textFragment) {
        this.fragments.remove(textFragment);
    }

    public void draw(Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor, float f4, float f5, double d2) {
        Size2D size2D = this.calculateDimensions(graphics2D);
        float f6 = 0.0f;
        if (textAnchor.isHorizontalCenter()) {
            f6 = (float)(-size2D.getWidth()) / 2.0f;
        } else if (textAnchor.isRight()) {
            f6 = (float)(-size2D.getWidth());
        }
        float f7 = f2 + f6;
        float f8 = this.calculateBaselineOffset(graphics2D, textAnchor);
        for (TextFragment textFragment : this.fragments) {
            Size2D size2D2 = textFragment.calculateDimensions(graphics2D);
            textFragment.draw(graphics2D, f7, f3 + f8, TextAnchor.BASELINE_LEFT, f4, f5, d2);
            f7 += (float)size2D2.getWidth();
        }
    }

    public Size2D calculateDimensions(Graphics2D graphics2D) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (TextFragment textFragment : this.fragments) {
            Size2D size2D = textFragment.calculateDimensions(graphics2D);
            d2 += size2D.getWidth();
            d3 = Math.max(d3, size2D.getHeight());
        }
        return new Size2D(d2, d3);
    }

    public TextFragment getFirstTextFragment() {
        TextFragment textFragment = null;
        if (this.fragments.size() > 0) {
            textFragment = (TextFragment)this.fragments.get(0);
        }
        return textFragment;
    }

    public TextFragment getLastTextFragment() {
        TextFragment textFragment = null;
        if (this.fragments.size() > 0) {
            textFragment = (TextFragment)this.fragments.get(this.fragments.size() - 1);
        }
        return textFragment;
    }

    private float calculateBaselineOffset(Graphics2D graphics2D, TextAnchor textAnchor) {
        float f2 = 0.0f;
        for (TextFragment textFragment : this.fragments) {
            f2 = Math.max(f2, textFragment.calculateBaselineOffset(graphics2D, textAnchor));
        }
        return f2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TextLine) {
            TextLine textLine = (TextLine)object;
            return this.fragments.equals(textLine.fragments);
        }
        return false;
    }

    public int hashCode() {
        return this.fragments != null ? this.fragments.hashCode() : 0;
    }
}

