/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainInfo;
import org.jfree.data.DomainOrder;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.general.Series;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYSeriesCollection
extends AbstractIntervalXYDataset
implements VetoableChangeListener,
Serializable,
DomainInfo,
RangeInfo,
IntervalXYDataset,
PublicCloneable {
    private static final long serialVersionUID = -7590013825931496766L;
    private List data = new ArrayList();
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this, false);

    public XYSeriesCollection() {
        this(null);
    }

    public XYSeriesCollection(XYSeries xYSeries) {
        this.addChangeListener(this.intervalDelegate);
        if (xYSeries != null) {
            this.data.add(xYSeries);
            xYSeries.addChangeListener(this);
            xYSeries.addVetoableChangeListener(this);
        }
    }

    @Override
    public DomainOrder getDomainOrder() {
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            XYSeries xYSeries = this.getSeries(i2);
            if (xYSeries.getAutoSort()) continue;
            return DomainOrder.NONE;
        }
        return DomainOrder.ASCENDING;
    }

    public void addSeries(XYSeries xYSeries) {
        ParamChecks.nullNotPermitted(xYSeries, "series");
        if (this.getSeriesIndex(xYSeries.getKey()) >= 0) {
            throw new IllegalArgumentException("This dataset already contains a series with the key " + xYSeries.getKey());
        }
        this.data.add(xYSeries);
        xYSeries.addChangeListener(this);
        xYSeries.addVetoableChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XYSeries xYSeries = (XYSeries)this.data.get(n2);
        if (xYSeries != null) {
            this.removeSeries(xYSeries);
        }
    }

    public void removeSeries(XYSeries xYSeries) {
        ParamChecks.nullNotPermitted(xYSeries, "series");
        if (this.data.contains(xYSeries)) {
            xYSeries.removeChangeListener(this);
            xYSeries.removeVetoableChangeListener(this);
            this.data.remove(xYSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            XYSeries xYSeries = (XYSeries)this.data.get(i2);
            xYSeries.removeChangeListener(this);
            xYSeries.removeVetoableChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public int indexOf(XYSeries xYSeries) {
        ParamChecks.nullNotPermitted(xYSeries, "series");
        return this.data.indexOf(xYSeries);
    }

    public XYSeries getSeries(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XYSeries)this.data.get(n2);
    }

    public XYSeries getSeries(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        for (XYSeries xYSeries : this.data) {
            if (!comparable.equals(xYSeries.getKey())) continue;
            return xYSeries;
        }
        throw new UnknownKeyException("Key not found: " + comparable);
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        return this.getSeries(n2).getKey();
    }

    public int getSeriesIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            XYSeries xYSeries = (XYSeries)this.data.get(i2);
            if (!comparable.equals(xYSeries.getKey())) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getItemCount(int n2) {
        return this.getSeries(n2).getItemCount();
    }

    @Override
    public Number getX(int n2, int n3) {
        XYSeries xYSeries = (XYSeries)this.data.get(n2);
        return xYSeries.getX(n3);
    }

    @Override
    public Number getStartX(int n2, int n3) {
        return this.intervalDelegate.getStartX(n2, n3);
    }

    @Override
    public Number getEndX(int n2, int n3) {
        return this.intervalDelegate.getEndX(n2, n3);
    }

    @Override
    public Number getY(int n2, int n3) {
        XYSeries xYSeries = (XYSeries)this.data.get(n2);
        return xYSeries.getY(n3);
    }

    @Override
    public Number getStartY(int n2, int n3) {
        return this.getY(n2, n3);
    }

    @Override
    public Number getEndY(int n2, int n3) {
        return this.getY(n2, n3);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSeriesCollection)) {
            return false;
        }
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)object;
        if (!this.intervalDelegate.equals(xYSeriesCollection.intervalDelegate)) {
            return false;
        }
        return ObjectUtilities.equal(this.data, xYSeriesCollection.data);
    }

    @Override
    public Object clone() {
        XYSeriesCollection xYSeriesCollection = (XYSeriesCollection)super.clone();
        xYSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        xYSeriesCollection.intervalDelegate = (IntervalXYDelegate)this.intervalDelegate.clone();
        return xYSeriesCollection;
    }

    public int hashCode() {
        int n2 = 5;
        n2 = HashUtilities.hashCode(n2, this.intervalDelegate);
        n2 = HashUtilities.hashCode(n2, this.data);
        return n2;
    }

    @Override
    public double getDomainLowerBound(boolean bl2) {
        if (bl2) {
            return this.intervalDelegate.getDomainLowerBound(bl2);
        }
        double d2 = Double.NaN;
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            XYSeries xYSeries = this.getSeries(i2);
            double d3 = xYSeries.getMinX();
            if (Double.isNaN(d2)) {
                d2 = d3;
                continue;
            }
            if (Double.isNaN(d3)) continue;
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    @Override
    public double getDomainUpperBound(boolean bl2) {
        if (bl2) {
            return this.intervalDelegate.getDomainUpperBound(bl2);
        }
        double d2 = Double.NaN;
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            XYSeries xYSeries = this.getSeries(i2);
            double d3 = xYSeries.getMaxX();
            if (Double.isNaN(d2)) {
                d2 = d3;
                continue;
            }
            if (Double.isNaN(d3)) continue;
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    @Override
    public Range getDomainBounds(boolean bl2) {
        if (bl2) {
            return this.intervalDelegate.getDomainBounds(bl2);
        }
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4;
            XYSeries xYSeries = this.getSeries(i2);
            double d5 = xYSeries.getMinX();
            if (!Double.isNaN(d5)) {
                d2 = Math.min(d2, d5);
            }
            if (Double.isNaN(d4 = xYSeries.getMaxX())) continue;
            d3 = Math.max(d3, d4);
        }
        if (d2 > d3) {
            return null;
        }
        return new Range(d2, d3);
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Negative 'width' argument.");
        }
        this.intervalDelegate.setFixedIntervalWidth(d2);
        this.fireDatasetChanged();
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d2) {
        this.intervalDelegate.setIntervalPositionFactor(d2);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean bl2) {
        this.intervalDelegate.setAutoWidth(bl2);
        this.fireDatasetChanged();
    }

    @Override
    public Range getRangeBounds(boolean bl2) {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4;
            XYSeries xYSeries = this.getSeries(i2);
            double d5 = xYSeries.getMinY();
            if (!Double.isNaN(d5)) {
                d2 = Math.min(d2, d5);
            }
            if (Double.isNaN(d4 = xYSeries.getMaxY())) continue;
            d3 = Math.max(d3, d4);
        }
        if (d2 > d3) {
            return null;
        }
        return new Range(d2, d3);
    }

    @Override
    public double getRangeLowerBound(boolean bl2) {
        double d2 = Double.NaN;
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            XYSeries xYSeries = this.getSeries(i2);
            double d3 = xYSeries.getMinY();
            if (Double.isNaN(d2)) {
                d2 = d3;
                continue;
            }
            if (Double.isNaN(d3)) continue;
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    @Override
    public double getRangeUpperBound(boolean bl2) {
        double d2 = Double.NaN;
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            XYSeries xYSeries = this.getSeries(i2);
            double d3 = xYSeries.getMaxY();
            if (Double.isNaN(d2)) {
                d2 = d3;
                continue;
            }
            if (Double.isNaN(d3)) continue;
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"Key".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        Series series = (Series)propertyChangeEvent.getSource();
        if (this.getSeriesIndex(series.getKey()) == -1) {
            throw new IllegalStateException("Receiving events from a series that does not belong to this collection.");
        }
        Comparable comparable = (Comparable)propertyChangeEvent.getNewValue();
        if (this.getSeriesIndex(comparable) >= 0) {
            throw new PropertyVetoException("Duplicate key2", propertyChangeEvent);
        }
    }
}

