/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.util.ObjectUtilities;

public class XYSeries
extends Series
implements Serializable,
Cloneable {
    static final long serialVersionUID = -5908509288197150436L;
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean autoSort;
    private boolean allowDuplicateXValues;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public XYSeries(Comparable comparable) {
        this(comparable, true, true);
    }

    public XYSeries(Comparable comparable, boolean bl2) {
        this(comparable, bl2, true);
    }

    public XYSeries(Comparable comparable, boolean bl2, boolean bl3) {
        super(comparable);
        this.data = new ArrayList();
        this.autoSort = bl2;
        this.allowDuplicateXValues = bl3;
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    private void updateBoundsForAddedItem(XYDataItem xYDataItem) {
        double d2 = xYDataItem.getXValue();
        this.minX = this.minIgnoreNaN(this.minX, d2);
        this.maxX = this.maxIgnoreNaN(this.maxX, d2);
        if (xYDataItem.getY() != null) {
            double d3 = xYDataItem.getYValue();
            this.minY = this.minIgnoreNaN(this.minY, d3);
            this.maxY = this.maxIgnoreNaN(this.maxY, d3);
        }
    }

    private void updateBoundsForRemovedItem(XYDataItem xYDataItem) {
        double d2;
        boolean bl2 = false;
        boolean bl3 = false;
        double d3 = xYDataItem.getXValue();
        if (!Double.isNaN(d3) && (d3 <= this.minX || d3 >= this.maxX)) {
            bl2 = true;
        }
        if (xYDataItem.getY() != null && !Double.isNaN(d2 = xYDataItem.getYValue()) && (d2 <= this.minY || d2 >= this.maxY)) {
            bl3 = true;
        }
        if (bl3) {
            this.findBoundsByIteration();
        } else if (bl2) {
            if (this.getAutoSort()) {
                this.minX = this.getX(0).doubleValue();
                this.maxX = this.getX(this.getItemCount() - 1).doubleValue();
            } else {
                this.findBoundsByIteration();
            }
        }
    }

    private void findBoundsByIteration() {
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        for (XYDataItem xYDataItem : this.data) {
            this.updateBoundsForAddedItem(xYDataItem);
        }
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n2) {
        this.maximumItemCount = n2;
        int n3 = this.data.size() - n2;
        if (n3 > 0) {
            this.data.subList(0, n3).clear();
            this.findBoundsByIteration();
            this.fireSeriesChanged();
        }
    }

    public void add(XYDataItem xYDataItem) {
        this.add(xYDataItem, true);
    }

    public void add(double d2, double d3) {
        this.add(new Double(d2), (Number)new Double(d3), true);
    }

    public void add(double d2, double d3, boolean bl2) {
        this.add(new Double(d2), (Number)new Double(d3), bl2);
    }

    public void add(double d2, Number number) {
        this.add(new Double(d2), number);
    }

    public void add(double d2, Number number, boolean bl2) {
        this.add(new Double(d2), number, bl2);
    }

    public void add(Number number, Number number2) {
        this.add(number, number2, true);
    }

    public void add(Number number, Number number2, boolean bl2) {
        XYDataItem xYDataItem = new XYDataItem(number, number2);
        this.add(xYDataItem, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(XYDataItem xYDataItem, boolean bl2) {
        int n2;
        ParamChecks.nullNotPermitted(xYDataItem, "item");
        xYDataItem = (XYDataItem)xYDataItem.clone();
        if (this.autoSort) {
            n2 = Collections.binarySearch(this.data, xYDataItem);
            if (n2 < 0) {
                this.data.add(-n2 - 1, xYDataItem);
            } else {
                if (!this.allowDuplicateXValues) throw new SeriesException("X-value already exists.");
                int n3 = this.data.size();
                while (n2 < n3 && xYDataItem.compareTo(this.data.get(n2)) == 0) {
                    ++n2;
                }
                if (n2 < this.data.size()) {
                    this.data.add(n2, xYDataItem);
                } else {
                    this.data.add(xYDataItem);
                }
            }
        } else {
            if (!this.allowDuplicateXValues && (n2 = this.indexOf(xYDataItem.getX())) >= 0) {
                throw new SeriesException("X-value already exists.");
            }
            this.data.add(xYDataItem);
        }
        this.updateBoundsForAddedItem(xYDataItem);
        if (this.getItemCount() > this.maximumItemCount) {
            XYDataItem xYDataItem2 = (XYDataItem)this.data.remove(0);
            this.updateBoundsForRemovedItem(xYDataItem2);
        }
        if (!bl2) return;
        this.fireSeriesChanged();
    }

    public void delete(int n2, int n3) {
        this.data.subList(n2, n3 + 1).clear();
        this.findBoundsByIteration();
        this.fireSeriesChanged();
    }

    public XYDataItem remove(int n2) {
        XYDataItem xYDataItem = (XYDataItem)this.data.remove(n2);
        this.updateBoundsForRemovedItem(xYDataItem);
        this.fireSeriesChanged();
        return xYDataItem;
    }

    public XYDataItem remove(Number number) {
        return this.remove(this.indexOf(number));
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.minX = Double.NaN;
            this.maxX = Double.NaN;
            this.minY = Double.NaN;
            this.maxY = Double.NaN;
            this.fireSeriesChanged();
        }
    }

    public XYDataItem getDataItem(int n2) {
        XYDataItem xYDataItem = (XYDataItem)this.data.get(n2);
        return (XYDataItem)xYDataItem.clone();
    }

    XYDataItem getRawDataItem(int n2) {
        return (XYDataItem)this.data.get(n2);
    }

    public Number getX(int n2) {
        return this.getRawDataItem(n2).getX();
    }

    public Number getY(int n2) {
        return this.getRawDataItem(n2).getY();
    }

    public void update(int n2, Number number) {
        XYDataItem xYDataItem = this.getRawDataItem(n2);
        boolean bl2 = false;
        double d2 = xYDataItem.getYValue();
        if (!Double.isNaN(d2)) {
            bl2 = d2 <= this.minY || d2 >= this.maxY;
        }
        xYDataItem.setY(number);
        if (bl2) {
            this.findBoundsByIteration();
        } else if (number != null) {
            double d3 = number.doubleValue();
            this.minY = this.minIgnoreNaN(this.minY, d3);
            this.maxY = this.maxIgnoreNaN(this.maxY, d3);
        }
        this.fireSeriesChanged();
    }

    private double minIgnoreNaN(double d2, double d3) {
        if (Double.isNaN(d2)) {
            return d3;
        }
        if (Double.isNaN(d3)) {
            return d2;
        }
        return Math.min(d2, d3);
    }

    private double maxIgnoreNaN(double d2, double d3) {
        if (Double.isNaN(d2)) {
            return d3;
        }
        if (Double.isNaN(d3)) {
            return d2;
        }
        return Math.max(d2, d3);
    }

    public void updateByIndex(int n2, Number number) {
        this.update(n2, number);
    }

    public void update(Number number, Number number2) {
        int n2 = this.indexOf(number);
        if (n2 < 0) {
            throw new SeriesException("No observation for x = " + number);
        }
        this.updateByIndex(n2, number2);
    }

    public XYDataItem addOrUpdate(double d2, double d3) {
        return this.addOrUpdate(new Double(d2), new Double(d3));
    }

    public XYDataItem addOrUpdate(Number number, Number number2) {
        return this.addOrUpdate(new XYDataItem(number, number2));
    }

    public XYDataItem addOrUpdate(XYDataItem xYDataItem) {
        ParamChecks.nullNotPermitted(xYDataItem, "item");
        if (this.allowDuplicateXValues) {
            this.add(xYDataItem);
            return null;
        }
        XYDataItem xYDataItem2 = null;
        int n2 = this.indexOf(xYDataItem.getX());
        if (n2 >= 0) {
            XYDataItem xYDataItem3 = (XYDataItem)this.data.get(n2);
            xYDataItem2 = (XYDataItem)xYDataItem3.clone();
            boolean bl2 = false;
            double d2 = xYDataItem3.getYValue();
            if (!Double.isNaN(d2)) {
                bl2 = d2 <= this.minY || d2 >= this.maxY;
            }
            xYDataItem3.setY(xYDataItem.getY());
            if (bl2) {
                this.findBoundsByIteration();
            } else if (xYDataItem.getY() != null) {
                double d3 = xYDataItem.getY().doubleValue();
                this.minY = this.minIgnoreNaN(this.minY, d3);
                this.maxY = this.maxIgnoreNaN(this.maxY, d3);
            }
        } else {
            xYDataItem = (XYDataItem)xYDataItem.clone();
            if (this.autoSort) {
                this.data.add(-n2 - 1, xYDataItem);
            } else {
                this.data.add(xYDataItem);
            }
            this.updateBoundsForAddedItem(xYDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                XYDataItem xYDataItem4 = (XYDataItem)this.data.remove(0);
                this.updateBoundsForRemovedItem(xYDataItem4);
            }
        }
        this.fireSeriesChanged();
        return xYDataItem2;
    }

    public int indexOf(Number number) {
        if (this.autoSort) {
            return Collections.binarySearch(this.data, new XYDataItem(number, null));
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            XYDataItem xYDataItem = (XYDataItem)this.data.get(i2);
            if (!xYDataItem.getX().equals(number)) continue;
            return i2;
        }
        return -1;
    }

    public double[][] toArray() {
        int n2 = this.getItemCount();
        double[][] dArray = new double[2][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[0][i2] = this.getX(i2).doubleValue();
            Number number = this.getY(i2);
            dArray[1][i2] = number != null ? number.doubleValue() : Double.NaN;
        }
        return dArray;
    }

    @Override
    public Object clone() {
        XYSeries xYSeries = (XYSeries)super.clone();
        xYSeries.data = (List)ObjectUtilities.deepClone(this.data);
        return xYSeries;
    }

    public XYSeries createCopy(int n2, int n3) {
        XYSeries xYSeries = (XYSeries)super.clone();
        xYSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                XYDataItem xYDataItem = (XYDataItem)this.data.get(i2);
                XYDataItem xYDataItem2 = (XYDataItem)xYDataItem.clone();
                try {
                    xYSeries.add(xYDataItem2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    throw new RuntimeException("Unable to add cloned data item.", seriesException);
                }
            }
        }
        return xYSeries;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSeries)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYSeries xYSeries = (XYSeries)object;
        if (this.maximumItemCount != xYSeries.maximumItemCount) {
            return false;
        }
        if (this.autoSort != xYSeries.autoSort) {
            return false;
        }
        if (this.allowDuplicateXValues != xYSeries.allowDuplicateXValues) {
            return false;
        }
        return ObjectUtilities.equal(this.data, xYSeries.data);
    }

    @Override
    public int hashCode() {
        XYDataItem xYDataItem;
        int n2 = super.hashCode();
        int n3 = this.getItemCount();
        if (n3 > 0) {
            xYDataItem = this.getRawDataItem(0);
            n2 = 29 * n2 + xYDataItem.hashCode();
        }
        if (n3 > 1) {
            xYDataItem = this.getRawDataItem(n3 - 1);
            n2 = 29 * n2 + xYDataItem.hashCode();
        }
        if (n3 > 2) {
            xYDataItem = this.getRawDataItem(n3 / 2);
            n2 = 29 * n2 + xYDataItem.hashCode();
        }
        n2 = 29 * n2 + this.maximumItemCount;
        n2 = 29 * n2 + (this.autoSort ? 1 : 0);
        n2 = 29 * n2 + (this.allowDuplicateXValues ? 1 : 0);
        return n2;
    }
}

