/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYIntervalSeriesCollection
extends AbstractIntervalXYDataset
implements Serializable,
IntervalXYDataset,
PublicCloneable {
    private List data = new ArrayList();

    public void addSeries(XYIntervalSeries xYIntervalSeries) {
        ParamChecks.nullNotPermitted(xYIntervalSeries, "series");
        this.data.add(xYIntervalSeries);
        xYIntervalSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public XYIntervalSeries getSeries(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (XYIntervalSeries)this.data.get(n2);
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        return this.getSeries(n2).getKey();
    }

    @Override
    public int getItemCount(int n2) {
        return this.getSeries(n2).getItemCount();
    }

    @Override
    public Number getX(int n2, int n3) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n2);
        return xYIntervalSeries.getX(n3);
    }

    @Override
    public double getStartXValue(int n2, int n3) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n2);
        return xYIntervalSeries.getXLowValue(n3);
    }

    @Override
    public double getEndXValue(int n2, int n3) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n2);
        return xYIntervalSeries.getXHighValue(n3);
    }

    @Override
    public double getYValue(int n2, int n3) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n2);
        return xYIntervalSeries.getYValue(n3);
    }

    @Override
    public double getStartYValue(int n2, int n3) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n2);
        return xYIntervalSeries.getYLowValue(n3);
    }

    @Override
    public double getEndYValue(int n2, int n3) {
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n2);
        return xYIntervalSeries.getYHighValue(n3);
    }

    @Override
    public Number getY(int n2, int n3) {
        return new Double(this.getYValue(n2, n3));
    }

    @Override
    public Number getStartX(int n2, int n3) {
        return new Double(this.getStartXValue(n2, n3));
    }

    @Override
    public Number getEndX(int n2, int n3) {
        return new Double(this.getEndXValue(n2, n3));
    }

    @Override
    public Number getStartY(int n2, int n3) {
        return new Double(this.getStartYValue(n2, n3));
    }

    @Override
    public Number getEndY(int n2, int n3) {
        return new Double(this.getEndYValue(n2, n3));
    }

    public void removeSeries(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds.");
        }
        XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(n2);
        xYIntervalSeries.removeChangeListener(this);
        this.data.remove(n2);
        this.fireDatasetChanged();
    }

    public void removeSeries(XYIntervalSeries xYIntervalSeries) {
        ParamChecks.nullNotPermitted(xYIntervalSeries, "series");
        if (this.data.contains(xYIntervalSeries)) {
            xYIntervalSeries.removeChangeListener(this);
            this.data.remove(xYIntervalSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeAllSeries() {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            XYIntervalSeries xYIntervalSeries = (XYIntervalSeries)this.data.get(i2);
            xYIntervalSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYIntervalSeriesCollection)) {
            return false;
        }
        XYIntervalSeriesCollection xYIntervalSeriesCollection = (XYIntervalSeriesCollection)object;
        return ObjectUtilities.equal(this.data, xYIntervalSeriesCollection.data);
    }

    @Override
    public Object clone() {
        XYIntervalSeriesCollection xYIntervalSeriesCollection = (XYIntervalSeriesCollection)super.clone();
        int n2 = this.getSeriesCount();
        xYIntervalSeriesCollection.data = new ArrayList(n2);
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            xYIntervalSeriesCollection.data.set(i2, this.getSeries(i2).clone());
        }
        return xYIntervalSeriesCollection;
    }
}

