/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.Vector;
import org.jfree.data.xy.VectorDataItem;
import org.jfree.data.xy.VectorSeries;
import org.jfree.data.xy.VectorXYDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class VectorSeriesCollection
extends AbstractXYDataset
implements Serializable,
VectorXYDataset,
PublicCloneable {
    private List data = new ArrayList();

    public void addSeries(VectorSeries vectorSeries) {
        ParamChecks.nullNotPermitted(vectorSeries, "series");
        this.data.add(vectorSeries);
        vectorSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean removeSeries(VectorSeries vectorSeries) {
        ParamChecks.nullNotPermitted(vectorSeries, "series");
        boolean bl2 = this.data.remove(vectorSeries);
        if (bl2) {
            vectorSeries.removeChangeListener(this);
            this.fireDatasetChanged();
        }
        return bl2;
    }

    public void removeAllSeries() {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            VectorSeries vectorSeries = (VectorSeries)this.data.get(i2);
            vectorSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public VectorSeries getSeries(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (VectorSeries)this.data.get(n2);
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        return this.getSeries(n2).getKey();
    }

    public int indexOf(VectorSeries vectorSeries) {
        ParamChecks.nullNotPermitted(vectorSeries, "series");
        return this.data.indexOf(vectorSeries);
    }

    @Override
    public int getItemCount(int n2) {
        return this.getSeries(n2).getItemCount();
    }

    @Override
    public double getXValue(int n2, int n3) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n2);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n3);
        return vectorDataItem.getXValue();
    }

    @Override
    public Number getX(int n2, int n3) {
        return new Double(this.getXValue(n2, n3));
    }

    @Override
    public double getYValue(int n2, int n3) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n2);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n3);
        return vectorDataItem.getYValue();
    }

    @Override
    public Number getY(int n2, int n3) {
        return new Double(this.getYValue(n2, n3));
    }

    @Override
    public Vector getVector(int n2, int n3) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n2);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n3);
        return vectorDataItem.getVector();
    }

    @Override
    public double getVectorXValue(int n2, int n3) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n2);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n3);
        return vectorDataItem.getVectorX();
    }

    @Override
    public double getVectorYValue(int n2, int n3) {
        VectorSeries vectorSeries = (VectorSeries)this.data.get(n2);
        VectorDataItem vectorDataItem = (VectorDataItem)vectorSeries.getDataItem(n3);
        return vectorDataItem.getVectorY();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VectorSeriesCollection)) {
            return false;
        }
        VectorSeriesCollection vectorSeriesCollection = (VectorSeriesCollection)object;
        return ObjectUtilities.equal(this.data, vectorSeriesCollection.data);
    }

    @Override
    public Object clone() {
        VectorSeriesCollection vectorSeriesCollection = (VectorSeriesCollection)super.clone();
        vectorSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        return vectorSeriesCollection;
    }
}

