/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.MatrixSeries;
import org.jfree.data.xy.XYZDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class MatrixSeriesCollection
extends AbstractXYZDataset
implements Serializable,
XYZDataset,
PublicCloneable {
    private static final long serialVersionUID = -3197705779242543945L;
    private List seriesList = new ArrayList();

    public MatrixSeriesCollection() {
        this(null);
    }

    public MatrixSeriesCollection(MatrixSeries matrixSeries) {
        if (matrixSeries != null) {
            this.seriesList.add(matrixSeries);
            matrixSeries.addChangeListener(this);
        }
    }

    @Override
    public int getItemCount(int n2) {
        return this.getSeries(n2).getItemCount();
    }

    public MatrixSeries getSeries(int n2) {
        if (n2 < 0 || n2 > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n2);
        return matrixSeries;
    }

    @Override
    public int getSeriesCount() {
        return this.seriesList.size();
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        return this.getSeries(n2).getKey();
    }

    @Override
    public Number getX(int n2, int n3) {
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n2);
        int n4 = matrixSeries.getItemColumn(n3);
        return new Integer(n4);
    }

    @Override
    public Number getY(int n2, int n3) {
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n2);
        int n4 = matrixSeries.getItemRow(n3);
        return new Integer(n4);
    }

    @Override
    public Number getZ(int n2, int n3) {
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n2);
        Number number = matrixSeries.getItem(n3);
        return number;
    }

    public void addSeries(MatrixSeries matrixSeries) {
        ParamChecks.nullNotPermitted(matrixSeries, "series");
        this.seriesList.add(matrixSeries);
        matrixSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof MatrixSeriesCollection) {
            MatrixSeriesCollection matrixSeriesCollection = (MatrixSeriesCollection)object;
            return ObjectUtilities.equal(this.seriesList, matrixSeriesCollection.seriesList);
        }
        return false;
    }

    public int hashCode() {
        return this.seriesList != null ? this.seriesList.hashCode() : 0;
    }

    @Override
    public Object clone() {
        MatrixSeriesCollection matrixSeriesCollection = (MatrixSeriesCollection)super.clone();
        matrixSeriesCollection.seriesList = (List)ObjectUtilities.deepClone(this.seriesList);
        return matrixSeriesCollection;
    }

    public void removeAllSeries() {
        for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
            MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(i2);
            matrixSeries.removeChangeListener(this);
        }
        this.seriesList.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(MatrixSeries matrixSeries) {
        ParamChecks.nullNotPermitted(matrixSeries, "series");
        if (this.seriesList.contains(matrixSeries)) {
            matrixSeries.removeChangeListener(this);
            this.seriesList.remove(matrixSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int n2) {
        if (n2 < 0 || n2 > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n2);
        matrixSeries.removeChangeListener(this);
        this.seriesList.remove(n2);
        this.fireDatasetChanged();
    }
}

