/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.data.general.Series;

public class MatrixSeries
extends Series
implements Serializable {
    private static final long serialVersionUID = 7934188527308315704L;
    protected double[][] data;

    public MatrixSeries(String string, int n2, int n3) {
        super((Comparable)((Object)string));
        this.data = new double[n2][n3];
        this.zeroAll();
    }

    public int getColumnsCount() {
        return this.data[0].length;
    }

    public Number getItem(int n2) {
        int n3 = this.getItemRow(n2);
        int n4 = this.getItemColumn(n2);
        Double d2 = new Double(this.get(n3, n4));
        return d2;
    }

    public int getItemColumn(int n2) {
        return n2 % this.getColumnsCount();
    }

    @Override
    public int getItemCount() {
        return this.getRowCount() * this.getColumnsCount();
    }

    public int getItemRow(int n2) {
        return n2 / this.getColumnsCount();
    }

    public int getRowCount() {
        return this.data.length;
    }

    public double get(int n2, int n3) {
        return this.data[n2][n3];
    }

    public void update(int n2, int n3, double d2) {
        this.data[n2][n3] = d2;
        this.fireSeriesChanged();
    }

    public void zeroAll() {
        int n2 = this.getRowCount();
        int n3 = this.getColumnsCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                this.data[i2][i3] = 0.0;
            }
        }
        this.fireSeriesChanged();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MatrixSeries)) {
            return false;
        }
        MatrixSeries matrixSeries = (MatrixSeries)object;
        if (this.getRowCount() != matrixSeries.getRowCount()) {
            return false;
        }
        if (this.getColumnsCount() != matrixSeries.getColumnsCount()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int i3 = 0; i3 < this.getColumnsCount(); ++i3) {
                if (this.get(i2, i3) == matrixSeries.get(i2, i3)) continue;
                return false;
            }
        }
        return super.equals(object);
    }
}

