/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class IntervalXYDelegate
implements Serializable,
Cloneable,
DomainInfo,
DatasetChangeListener,
PublicCloneable {
    private static final long serialVersionUID = -685166711639592857L;
    private XYDataset dataset;
    private boolean autoWidth;
    private double intervalPositionFactor;
    private double fixedIntervalWidth;
    private double autoIntervalWidth;

    public IntervalXYDelegate(XYDataset xYDataset) {
        this(xYDataset, true);
    }

    public IntervalXYDelegate(XYDataset xYDataset, boolean bl2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        this.dataset = xYDataset;
        this.autoWidth = bl2;
        this.intervalPositionFactor = 0.5;
        this.autoIntervalWidth = Double.POSITIVE_INFINITY;
        this.fixedIntervalWidth = 1.0;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public void setAutoWidth(boolean bl2) {
        this.autoWidth = bl2;
        if (bl2) {
            this.autoIntervalWidth = this.recalculateInterval();
        }
    }

    public double getIntervalPositionFactor() {
        return this.intervalPositionFactor;
    }

    public void setIntervalPositionFactor(double d2) {
        if (d2 < 0.0 || 1.0 < d2) {
            throw new IllegalArgumentException("Argument 'd' outside valid range.");
        }
        this.intervalPositionFactor = d2;
    }

    public double getFixedIntervalWidth() {
        return this.fixedIntervalWidth;
    }

    public void setFixedIntervalWidth(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Negative 'w' argument.");
        }
        this.fixedIntervalWidth = d2;
        this.autoWidth = false;
    }

    public double getIntervalWidth() {
        if (this.isAutoWidth() && !Double.isInfinite(this.autoIntervalWidth)) {
            return this.autoIntervalWidth;
        }
        return this.fixedIntervalWidth;
    }

    public Number getStartX(int n2, int n3) {
        Double d2 = null;
        Number number = this.dataset.getX(n2, n3);
        if (number != null) {
            d2 = new Double(number.doubleValue() - this.getIntervalPositionFactor() * this.getIntervalWidth());
        }
        return d2;
    }

    public double getStartXValue(int n2, int n3) {
        return this.dataset.getXValue(n2, n3) - this.getIntervalPositionFactor() * this.getIntervalWidth();
    }

    public Number getEndX(int n2, int n3) {
        Double d2 = null;
        Number number = this.dataset.getX(n2, n3);
        if (number != null) {
            d2 = new Double(number.doubleValue() + (1.0 - this.getIntervalPositionFactor()) * this.getIntervalWidth());
        }
        return d2;
    }

    public double getEndXValue(int n2, int n3) {
        return this.dataset.getXValue(n2, n3) + (1.0 - this.getIntervalPositionFactor()) * this.getIntervalWidth();
    }

    @Override
    public double getDomainLowerBound(boolean bl2) {
        double d2 = Double.NaN;
        Range range = this.getDomainBounds(bl2);
        if (range != null) {
            d2 = range.getLowerBound();
        }
        return d2;
    }

    @Override
    public double getDomainUpperBound(boolean bl2) {
        double d2 = Double.NaN;
        Range range = this.getDomainBounds(bl2);
        if (range != null) {
            d2 = range.getUpperBound();
        }
        return d2;
    }

    @Override
    public Range getDomainBounds(boolean bl2) {
        Range range = DatasetUtilities.findDomainBounds(this.dataset, false);
        if (bl2 && range != null) {
            double d2 = this.getIntervalWidth() * this.getIntervalPositionFactor();
            double d3 = this.getIntervalWidth() - d2;
            range = new Range(range.getLowerBound() - d2, range.getUpperBound() + d3);
        }
        return range;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.autoWidth) {
            this.autoIntervalWidth = this.recalculateInterval();
        }
    }

    private double recalculateInterval() {
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = this.dataset.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 = Math.min(d2, this.calculateIntervalForSeries(i2));
        }
        return d2;
    }

    private double calculateIntervalForSeries(int n2) {
        double d2 = Double.POSITIVE_INFINITY;
        int n3 = this.dataset.getItemCount(n2);
        if (n3 > 1) {
            double d3 = this.dataset.getXValue(n2, 0);
            for (int i2 = 1; i2 < n3; ++i2) {
                double d4 = this.dataset.getXValue(n2, i2);
                d2 = Math.min(d2, d4 - d3);
                d3 = d4;
            }
        }
        return d2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntervalXYDelegate)) {
            return false;
        }
        IntervalXYDelegate intervalXYDelegate = (IntervalXYDelegate)object;
        if (this.autoWidth != intervalXYDelegate.autoWidth) {
            return false;
        }
        if (this.intervalPositionFactor != intervalXYDelegate.intervalPositionFactor) {
            return false;
        }
        return this.fixedIntervalWidth == intervalXYDelegate.fixedIntervalWidth;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public int hashCode() {
        int n2 = 5;
        n2 = HashUtilities.hashCode(n2, this.autoWidth);
        n2 = HashUtilities.hashCode(n2, this.intervalPositionFactor);
        n2 = HashUtilities.hashCode(n2, this.fixedIntervalWidth);
        return n2;
    }
}

