/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.util.PublicCloneable;

public class DefaultXYZDataset
extends AbstractXYZDataset
implements XYZDataset,
PublicCloneable {
    private List seriesKeys = new ArrayList();
    private List seriesList = new ArrayList();

    @Override
    public int getSeriesCount() {
        return this.seriesList.size();
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (Comparable)this.seriesKeys.get(n2);
    }

    @Override
    public int indexOf(Comparable comparable) {
        return this.seriesKeys.indexOf(comparable);
    }

    @Override
    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    @Override
    public int getItemCount(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[0].length;
    }

    @Override
    public double getXValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[0][n3];
    }

    @Override
    public Number getX(int n2, int n3) {
        return new Double(this.getXValue(n2, n3));
    }

    @Override
    public double getYValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[1][n3];
    }

    @Override
    public Number getY(int n2, int n3) {
        return new Double(this.getYValue(n2, n3));
    }

    @Override
    public double getZValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[2][n3];
    }

    @Override
    public Number getZ(int n2, int n3) {
        return new Double(this.getZValue(n2, n3));
    }

    public void addSeries(Comparable comparable, double[][] dArray) {
        if (comparable == null) {
            throw new IllegalArgumentException("The 'seriesKey' cannot be null.");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("The 'data' is null.");
        }
        if (dArray.length != 3) {
            throw new IllegalArgumentException("The 'data' array must have length == 3.");
        }
        if (dArray[0].length != dArray[1].length || dArray[0].length != dArray[2].length) {
            throw new IllegalArgumentException("The 'data' array must contain three arrays all having the same length.");
        }
        int n2 = this.indexOf(comparable);
        if (n2 == -1) {
            this.seriesKeys.add(comparable);
            this.seriesList.add(dArray);
        } else {
            this.seriesList.remove(n2);
            this.seriesList.add(n2, dArray);
        }
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void removeSeries(Comparable comparable) {
        int n2 = this.indexOf(comparable);
        if (n2 >= 0) {
            this.seriesKeys.remove(n2);
            this.seriesList.remove(n2);
            this.notifyListeners(new DatasetChangeEvent(this, this));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultXYZDataset)) {
            return false;
        }
        DefaultXYZDataset defaultXYZDataset = (DefaultXYZDataset)object;
        if (!this.seriesKeys.equals(defaultXYZDataset.seriesKeys)) {
            return false;
        }
        for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
            double[][] dArray;
            double[] dArray2;
            double[][] dArray3 = (double[][])this.seriesList.get(i2);
            double[] dArray4 = dArray3[0];
            if (!Arrays.equals(dArray4, dArray2 = (dArray = (double[][])defaultXYZDataset.seriesList.get(i2))[0])) {
                return false;
            }
            double[] dArray5 = dArray3[1];
            double[] dArray6 = dArray[1];
            if (!Arrays.equals(dArray5, dArray6)) {
                return false;
            }
            double[] dArray7 = dArray3[2];
            double[] dArray8 = dArray[2];
            if (Arrays.equals(dArray7, dArray8)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.seriesKeys.hashCode();
        n2 = 29 * n2 + this.seriesList.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        DefaultXYZDataset defaultXYZDataset = (DefaultXYZDataset)super.clone();
        defaultXYZDataset.seriesKeys = new ArrayList(this.seriesKeys);
        defaultXYZDataset.seriesList = new ArrayList(this.seriesList.size());
        for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
            double[][] dArray = (double[][])this.seriesList.get(i2);
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            double[] dArray4 = dArray[2];
            double[] dArray5 = new double[dArray2.length];
            double[] dArray6 = new double[dArray3.length];
            double[] dArray7 = new double[dArray4.length];
            System.arraycopy(dArray2, 0, dArray5, 0, dArray2.length);
            System.arraycopy(dArray3, 0, dArray6, 0, dArray3.length);
            System.arraycopy(dArray4, 0, dArray7, 0, dArray4.length);
            defaultXYZDataset.seriesList.add(i2, new double[][]{dArray5, dArray6, dArray7});
        }
        return defaultXYZDataset;
    }
}

