/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.WindDataItem;
import org.jfree.data.xy.WindDataset;
import org.jfree.util.PublicCloneable;

public class DefaultWindDataset
extends AbstractXYDataset
implements WindDataset,
PublicCloneable {
    private List seriesKeys;
    private List allSeriesData;

    public DefaultWindDataset() {
        this.seriesKeys = new ArrayList();
        this.allSeriesData = new ArrayList();
    }

    public DefaultWindDataset(Object[][][] objectArray) {
        this(DefaultWindDataset.seriesNameListFromDataArray((Object[][])objectArray), objectArray);
    }

    public DefaultWindDataset(String[] stringArray, Object[][][] objectArray) {
        this(Arrays.asList(stringArray), objectArray);
    }

    public DefaultWindDataset(List list, Object[][][] objectArray) {
        ParamChecks.nullNotPermitted(list, "seriesKeys");
        if (list.size() != objectArray.length) {
            throw new IllegalArgumentException("The number of series keys does not match the number of series in the data array.");
        }
        this.seriesKeys = list;
        int n2 = objectArray.length;
        this.allSeriesData = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList<WindDataItem> arrayList = new ArrayList<WindDataItem>();
            int n3 = objectArray[i2].length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Serializable serializable;
                Number number;
                Object object = objectArray[i2][i3][0];
                if (object == null) continue;
                if (object instanceof Number) {
                    number = (Number)object;
                } else if (object instanceof Date) {
                    serializable = (Date)object;
                    number = new Long(serializable.getTime());
                } else {
                    number = new Integer(0);
                }
                serializable = (Number)objectArray[i2][i3][1];
                Number number2 = (Number)objectArray[i2][i3][2];
                arrayList.add(new WindDataItem(number, (Number)serializable, number2));
            }
            Collections.sort(arrayList);
            this.allSeriesData.add(i2, arrayList);
        }
    }

    @Override
    public int getSeriesCount() {
        return this.allSeriesData.size();
    }

    @Override
    public int getItemCount(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series index: " + n2);
        }
        List list = (List)this.allSeriesData.get(n2);
        return list.size();
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series index: " + n2);
        }
        return (Comparable)this.seriesKeys.get(n2);
    }

    @Override
    public Number getX(int n2, int n3) {
        List list = (List)this.allSeriesData.get(n2);
        WindDataItem windDataItem = (WindDataItem)list.get(n3);
        return windDataItem.getX();
    }

    @Override
    public Number getY(int n2, int n3) {
        return this.getWindForce(n2, n3);
    }

    @Override
    public Number getWindDirection(int n2, int n3) {
        List list = (List)this.allSeriesData.get(n2);
        WindDataItem windDataItem = (WindDataItem)list.get(n3);
        return windDataItem.getWindDirection();
    }

    @Override
    public Number getWindForce(int n2, int n3) {
        List list = (List)this.allSeriesData.get(n2);
        WindDataItem windDataItem = (WindDataItem)list.get(n3);
        return windDataItem.getWindForce();
    }

    public static List seriesNameListFromDataArray(Object[][] objectArray) {
        int n2 = objectArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add("Series " + (i2 + 1));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultWindDataset)) {
            return false;
        }
        DefaultWindDataset defaultWindDataset = (DefaultWindDataset)object;
        if (!this.seriesKeys.equals(defaultWindDataset.seriesKeys)) {
            return false;
        }
        return this.allSeriesData.equals(defaultWindDataset.allSeriesData);
    }
}

