/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.util.PublicCloneable;

public class DefaultIntervalXYDataset
extends AbstractIntervalXYDataset
implements PublicCloneable {
    private List seriesKeys = new ArrayList();
    private List seriesList = new ArrayList();

    @Override
    public int getSeriesCount() {
        return this.seriesList.size();
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (Comparable)this.seriesKeys.get(n2);
    }

    @Override
    public int getItemCount(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[0].length;
    }

    @Override
    public double getXValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[0][n3];
    }

    @Override
    public double getYValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[3][n3];
    }

    @Override
    public double getStartXValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[1][n3];
    }

    @Override
    public double getEndXValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[2][n3];
    }

    @Override
    public double getStartYValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[4][n3];
    }

    @Override
    public double getEndYValue(int n2, int n3) {
        double[][] dArray = (double[][])this.seriesList.get(n2);
        return dArray[5][n3];
    }

    @Override
    public Number getEndX(int n2, int n3) {
        return new Double(this.getEndXValue(n2, n3));
    }

    @Override
    public Number getEndY(int n2, int n3) {
        return new Double(this.getEndYValue(n2, n3));
    }

    @Override
    public Number getStartX(int n2, int n3) {
        return new Double(this.getStartXValue(n2, n3));
    }

    @Override
    public Number getStartY(int n2, int n3) {
        return new Double(this.getStartYValue(n2, n3));
    }

    @Override
    public Number getX(int n2, int n3) {
        return new Double(this.getXValue(n2, n3));
    }

    @Override
    public Number getY(int n2, int n3) {
        return new Double(this.getYValue(n2, n3));
    }

    public void addSeries(Comparable comparable, double[][] dArray) {
        if (comparable == null) {
            throw new IllegalArgumentException("The 'seriesKey' cannot be null.");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("The 'data' is null.");
        }
        if (dArray.length != 6) {
            throw new IllegalArgumentException("The 'data' array must have length == 6.");
        }
        int n2 = dArray[0].length;
        if (n2 != dArray[1].length || n2 != dArray[2].length || n2 != dArray[3].length || n2 != dArray[4].length || n2 != dArray[5].length) {
            throw new IllegalArgumentException("The 'data' array must contain six arrays with equal length.");
        }
        int n3 = this.indexOf(comparable);
        if (n3 == -1) {
            this.seriesKeys.add(comparable);
            this.seriesList.add(dArray);
        } else {
            this.seriesList.remove(n3);
            this.seriesList.add(n3, dArray);
        }
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultIntervalXYDataset)) {
            return false;
        }
        DefaultIntervalXYDataset defaultIntervalXYDataset = (DefaultIntervalXYDataset)object;
        if (!this.seriesKeys.equals(defaultIntervalXYDataset.seriesKeys)) {
            return false;
        }
        for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
            double[][] dArray;
            double[] dArray2;
            double[][] dArray3 = (double[][])this.seriesList.get(i2);
            double[] dArray4 = dArray3[0];
            if (!Arrays.equals(dArray4, dArray2 = (dArray = (double[][])defaultIntervalXYDataset.seriesList.get(i2))[0])) {
                return false;
            }
            double[] dArray5 = dArray3[1];
            double[] dArray6 = dArray[1];
            if (!Arrays.equals(dArray5, dArray6)) {
                return false;
            }
            double[] dArray7 = dArray3[2];
            double[] dArray8 = dArray[2];
            if (!Arrays.equals(dArray7, dArray8)) {
                return false;
            }
            double[] dArray9 = dArray3[3];
            double[] dArray10 = dArray[3];
            if (!Arrays.equals(dArray9, dArray10)) {
                return false;
            }
            double[] dArray11 = dArray3[4];
            double[] dArray12 = dArray[4];
            if (!Arrays.equals(dArray11, dArray12)) {
                return false;
            }
            double[] dArray13 = dArray3[5];
            double[] dArray14 = dArray[5];
            if (Arrays.equals(dArray13, dArray14)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.seriesKeys.hashCode();
        n2 = 29 * n2 + this.seriesList.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        DefaultIntervalXYDataset defaultIntervalXYDataset = (DefaultIntervalXYDataset)super.clone();
        defaultIntervalXYDataset.seriesKeys = new ArrayList(this.seriesKeys);
        defaultIntervalXYDataset.seriesList = new ArrayList(this.seriesList.size());
        for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
            double[][] dArray = (double[][])this.seriesList.get(i2);
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            double[] dArray4 = dArray[2];
            double[] dArray5 = dArray[3];
            double[] dArray6 = dArray[4];
            double[] dArray7 = dArray[5];
            double[] dArray8 = new double[dArray2.length];
            double[] dArray9 = new double[dArray3.length];
            double[] dArray10 = new double[dArray4.length];
            double[] dArray11 = new double[dArray5.length];
            double[] dArray12 = new double[dArray6.length];
            double[] dArray13 = new double[dArray7.length];
            System.arraycopy(dArray2, 0, dArray8, 0, dArray2.length);
            System.arraycopy(dArray3, 0, dArray9, 0, dArray3.length);
            System.arraycopy(dArray4, 0, dArray10, 0, dArray4.length);
            System.arraycopy(dArray5, 0, dArray11, 0, dArray5.length);
            System.arraycopy(dArray6, 0, dArray12, 0, dArray6.length);
            System.arraycopy(dArray7, 0, dArray13, 0, dArray7.length);
            defaultIntervalXYDataset.seriesList.add(i2, new double[][]{dArray8, dArray9, dArray10, dArray11, dArray12, dArray13});
        }
        return defaultIntervalXYDataset;
    }
}

