/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.ohlc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.ohlc.OHLCItem;
import org.jfree.data.time.ohlc.OHLCSeries;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.util.ObjectUtilities;

public class OHLCSeriesCollection
extends AbstractXYDataset
implements Serializable,
OHLCDataset {
    private List data;
    private TimePeriodAnchor xPosition = TimePeriodAnchor.MIDDLE;

    public OHLCSeriesCollection() {
        this.data = new ArrayList();
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor timePeriodAnchor) {
        ParamChecks.nullNotPermitted(timePeriodAnchor, "anchor");
        this.xPosition = timePeriodAnchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void addSeries(OHLCSeries oHLCSeries) {
        ParamChecks.nullNotPermitted(oHLCSeries, "series");
        this.data.add(oHLCSeries);
        oHLCSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public OHLCSeries getSeries(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (OHLCSeries)this.data.get(n2);
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        return this.getSeries(n2).getKey();
    }

    @Override
    public int getItemCount(int n2) {
        return this.getSeries(n2).getItemCount();
    }

    protected synchronized long getX(RegularTimePeriod regularTimePeriod) {
        long l2 = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            l2 = regularTimePeriod.getFirstMillisecond();
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            l2 = regularTimePeriod.getMiddleMillisecond();
        } else if (this.xPosition == TimePeriodAnchor.END) {
            l2 = regularTimePeriod.getLastMillisecond();
        }
        return l2;
    }

    @Override
    public double getXValue(int n2, int n3) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n2);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n3);
        RegularTimePeriod regularTimePeriod = oHLCItem.getPeriod();
        return this.getX(regularTimePeriod);
    }

    @Override
    public Number getX(int n2, int n3) {
        return new Double(this.getXValue(n2, n3));
    }

    @Override
    public Number getY(int n2, int n3) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n2);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n3);
        return new Double(oHLCItem.getYValue());
    }

    @Override
    public double getOpenValue(int n2, int n3) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n2);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n3);
        return oHLCItem.getOpenValue();
    }

    @Override
    public Number getOpen(int n2, int n3) {
        return new Double(this.getOpenValue(n2, n3));
    }

    @Override
    public double getCloseValue(int n2, int n3) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n2);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n3);
        return oHLCItem.getCloseValue();
    }

    @Override
    public Number getClose(int n2, int n3) {
        return new Double(this.getCloseValue(n2, n3));
    }

    @Override
    public double getHighValue(int n2, int n3) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n2);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n3);
        return oHLCItem.getHighValue();
    }

    @Override
    public Number getHigh(int n2, int n3) {
        return new Double(this.getHighValue(n2, n3));
    }

    @Override
    public double getLowValue(int n2, int n3) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n2);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n3);
        return oHLCItem.getLowValue();
    }

    @Override
    public Number getLow(int n2, int n3) {
        return new Double(this.getLowValue(n2, n3));
    }

    @Override
    public Number getVolume(int n2, int n3) {
        return null;
    }

    @Override
    public double getVolumeValue(int n2, int n3) {
        return Double.NaN;
    }

    public void removeSeries(int n2) {
        OHLCSeries oHLCSeries = this.getSeries(n2);
        if (oHLCSeries != null) {
            this.removeSeries(oHLCSeries);
        }
    }

    public boolean removeSeries(OHLCSeries oHLCSeries) {
        ParamChecks.nullNotPermitted(oHLCSeries, "series");
        boolean bl2 = this.data.remove(oHLCSeries);
        if (bl2) {
            oHLCSeries.removeChangeListener(this);
            this.fireDatasetChanged();
        }
        return bl2;
    }

    public void removeAllSeries() {
        if (this.data.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(i2);
            oHLCSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OHLCSeriesCollection)) {
            return false;
        }
        OHLCSeriesCollection oHLCSeriesCollection = (OHLCSeriesCollection)object;
        if (!this.xPosition.equals(oHLCSeriesCollection.xPosition)) {
            return false;
        }
        return ObjectUtilities.equal(this.data, oHLCSeriesCollection.data);
    }

    public int hashCode() {
        int n2 = 137;
        n2 = HashUtilities.hashCode(n2, this.xPosition);
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            n2 = HashUtilities.hashCode(n2, this.data.get(i2));
        }
        return n2;
    }

    @Override
    public Object clone() {
        OHLCSeriesCollection oHLCSeriesCollection = (OHLCSeriesCollection)super.clone();
        oHLCSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        return oHLCSeriesCollection;
    }
}

