/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import javax.swing.table.AbstractTableModel;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class TimeSeriesTableModel
extends AbstractTableModel
implements SeriesChangeListener {
    private TimeSeries series;
    private boolean editable;
    private RegularTimePeriod newTimePeriod;
    private Number newValue;

    public TimeSeriesTableModel() {
        this(new TimeSeries((Comparable)((Object)"Untitled")));
    }

    public TimeSeriesTableModel(TimeSeries timeSeries) {
        this(timeSeries, false);
    }

    public TimeSeriesTableModel(TimeSeries timeSeries, boolean bl2) {
        this.series = timeSeries;
        this.series.addChangeListener(this);
        this.editable = bl2;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int n2) {
        if (n2 == 0) {
            return String.class;
        }
        if (n2 == 1) {
            return Double.class;
        }
        return null;
    }

    @Override
    public String getColumnName(int n2) {
        if (n2 == 0) {
            return "Period:";
        }
        if (n2 == 1) {
            return "Value:";
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.series.getItemCount();
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        if (n2 < this.series.getItemCount()) {
            if (n3 == 0) {
                return this.series.getTimePeriod(n2);
            }
            if (n3 == 1) {
                return this.series.getValue(n2);
            }
            return null;
        }
        if (n3 == 0) {
            return this.newTimePeriod;
        }
        if (n3 == 1) {
            return this.newValue;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        if (this.editable) {
            return n3 == 0 || n3 == 1;
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        if (n2 < this.series.getItemCount()) {
            if (n3 == 1) {
                try {
                    Double d2 = Double.valueOf(object.toString());
                    this.series.update(n2, (Number)d2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Number format exception");
                }
            }
        } else if (n3 == 0) {
            this.newTimePeriod = null;
        } else if (n3 == 1) {
            this.newValue = Double.valueOf(object.toString());
        }
    }

    @Override
    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        this.fireTableDataChanged();
    }
}

