/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.util.ObjectUtilities;

public class TimeSeriesDataItem
implements Serializable,
Cloneable,
Comparable {
    private static final long serialVersionUID = -2235346966016401302L;
    private RegularTimePeriod period;
    private Number value;

    public TimeSeriesDataItem(RegularTimePeriod regularTimePeriod, Number number) {
        ParamChecks.nullNotPermitted(regularTimePeriod, "period");
        this.period = regularTimePeriod;
        this.value = number;
    }

    public TimeSeriesDataItem(RegularTimePeriod regularTimePeriod, double d2) {
        this(regularTimePeriod, new Double(d2));
    }

    public RegularTimePeriod getPeriod() {
        return this.period;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number number) {
        this.value = number;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TimeSeriesDataItem)) {
            return false;
        }
        TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)object;
        if (!ObjectUtilities.equal(this.period, timeSeriesDataItem.period)) {
            return false;
        }
        return ObjectUtilities.equal(this.value, timeSeriesDataItem.value);
    }

    public int hashCode() {
        int n2 = this.period != null ? this.period.hashCode() : 0;
        n2 = 29 * n2 + (this.value != null ? this.value.hashCode() : 0);
        return n2;
    }

    public int compareTo(Object object) {
        int n2;
        if (object instanceof TimeSeriesDataItem) {
            TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)object;
            n2 = this.getPeriod().compareTo(timeSeriesDataItem.getPeriod());
        } else {
            n2 = 1;
        }
        return n2;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return object;
    }
}

