/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainInfo;
import org.jfree.data.DomainOrder;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.Series;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYDomainInfo;
import org.jfree.data.xy.XYRangeInfo;
import org.jfree.util.ObjectUtilities;

public class TimeSeriesCollection
extends AbstractIntervalXYDataset
implements VetoableChangeListener,
Serializable,
DomainInfo,
IntervalXYDataset,
XYDataset,
XYDomainInfo,
XYRangeInfo {
    private static final long serialVersionUID = 834149929022371137L;
    private List data;
    private Calendar workingCalendar;
    private TimePeriodAnchor xPosition;
    private boolean domainIsPointsInTime;

    public TimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeZone timeZone) {
        this(null, timeZone);
    }

    public TimeSeriesCollection(TimeSeries timeSeries) {
        this(timeSeries, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeSeries timeSeries, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.workingCalendar = Calendar.getInstance(timeZone);
        this.data = new ArrayList();
        if (timeSeries != null) {
            this.data.add(timeSeries);
            timeSeries.addChangeListener(this);
        }
        this.xPosition = TimePeriodAnchor.START;
        this.domainIsPointsInTime = true;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean bl2) {
        this.domainIsPointsInTime = bl2;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    @Override
    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor timePeriodAnchor) {
        ParamChecks.nullNotPermitted(timePeriodAnchor, "anchor");
        this.xPosition = timePeriodAnchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public int indexOf(TimeSeries timeSeries) {
        ParamChecks.nullNotPermitted(timeSeries, "series");
        return this.data.indexOf(timeSeries);
    }

    public TimeSeries getSeries(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("The 'series' argument is out of bounds (" + n2 + ").");
        }
        return (TimeSeries)this.data.get(n2);
    }

    public TimeSeries getSeries(Comparable comparable) {
        TimeSeries timeSeries = null;
        for (TimeSeries timeSeries2 : this.data) {
            Comparable comparable2 = timeSeries2.getKey();
            if (comparable2 == null || !comparable2.equals(comparable)) continue;
            timeSeries = timeSeries2;
        }
        return timeSeries;
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        return this.getSeries(n2).getKey();
    }

    public int getSeriesIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        int n2 = this.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimeSeries timeSeries = (TimeSeries)this.data.get(i2);
            if (!comparable.equals(timeSeries.getKey())) continue;
            return i2;
        }
        return -1;
    }

    public void addSeries(TimeSeries timeSeries) {
        ParamChecks.nullNotPermitted(timeSeries, "series");
        this.data.add(timeSeries);
        timeSeries.addChangeListener(this);
        timeSeries.addVetoableChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(TimeSeries timeSeries) {
        ParamChecks.nullNotPermitted(timeSeries, "series");
        this.data.remove(timeSeries);
        timeSeries.removeChangeListener(this);
        timeSeries.removeVetoableChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n2) {
        TimeSeries timeSeries = this.getSeries(n2);
        if (timeSeries != null) {
            this.removeSeries(timeSeries);
        }
    }

    public void removeAllSeries() {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            TimeSeries timeSeries = (TimeSeries)this.data.get(i2);
            timeSeries.removeChangeListener(this);
            timeSeries.removeVetoableChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public int getItemCount(int n2) {
        return this.getSeries(n2).getItemCount();
    }

    @Override
    public double getXValue(int n2, int n3) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n2);
        RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(n3);
        return this.getX(regularTimePeriod);
    }

    @Override
    public Number getX(int n2, int n3) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n2);
        RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(n3);
        return new Long(this.getX(regularTimePeriod));
    }

    protected synchronized long getX(RegularTimePeriod regularTimePeriod) {
        long l2 = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            l2 = regularTimePeriod.getFirstMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            l2 = regularTimePeriod.getMiddleMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.END) {
            l2 = regularTimePeriod.getLastMillisecond(this.workingCalendar);
        }
        return l2;
    }

    @Override
    public synchronized Number getStartX(int n2, int n3) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n2);
        return new Long(timeSeries.getTimePeriod(n3).getFirstMillisecond(this.workingCalendar));
    }

    @Override
    public synchronized Number getEndX(int n2, int n3) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n2);
        return new Long(timeSeries.getTimePeriod(n3).getLastMillisecond(this.workingCalendar));
    }

    @Override
    public Number getY(int n2, int n3) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n2);
        return timeSeries.getValue(n3);
    }

    @Override
    public Number getStartY(int n2, int n3) {
        return this.getY(n2, n3);
    }

    @Override
    public Number getEndY(int n2, int n3) {
        return this.getY(n2, n3);
    }

    public int[] getSurroundingItems(int n2, long l2) {
        int[] nArray = new int[]{-1, -1};
        TimeSeries timeSeries = this.getSeries(n2);
        for (int i2 = 0; i2 < timeSeries.getItemCount(); ++i2) {
            Number number = this.getX(n2, i2);
            long l3 = number.longValue();
            if (l3 <= l2) {
                nArray[0] = i2;
            }
            if (l3 < l2) continue;
            nArray[1] = i2;
            break;
        }
        return nArray;
    }

    @Override
    public double getDomainLowerBound(boolean bl2) {
        double d2 = Double.NaN;
        Range range = this.getDomainBounds(bl2);
        if (range != null) {
            d2 = range.getLowerBound();
        }
        return d2;
    }

    @Override
    public double getDomainUpperBound(boolean bl2) {
        double d2 = Double.NaN;
        Range range = this.getDomainBounds(bl2);
        if (range != null) {
            d2 = range.getUpperBound();
        }
        return d2;
    }

    @Override
    public Range getDomainBounds(boolean bl2) {
        Range range = null;
        for (TimeSeries timeSeries : this.data) {
            int n2 = timeSeries.getItemCount();
            if (n2 <= 0) continue;
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(0);
            RegularTimePeriod regularTimePeriod2 = timeSeries.getTimePeriod(n2 - 1);
            Range range2 = !bl2 ? new Range(this.getX(regularTimePeriod), this.getX(regularTimePeriod2)) : new Range(regularTimePeriod.getFirstMillisecond(this.workingCalendar), regularTimePeriod2.getLastMillisecond(this.workingCalendar));
            range = Range.combine(range, range2);
        }
        return range;
    }

    @Override
    public Range getDomainBounds(List list, boolean bl2) {
        Range range = null;
        for (Comparable comparable : list) {
            TimeSeries timeSeries = this.getSeries(comparable);
            int n2 = timeSeries.getItemCount();
            if (n2 <= 0) continue;
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(0);
            RegularTimePeriod regularTimePeriod2 = timeSeries.getTimePeriod(n2 - 1);
            Range range2 = !bl2 ? new Range(this.getX(regularTimePeriod), this.getX(regularTimePeriod2)) : new Range(regularTimePeriod.getFirstMillisecond(this.workingCalendar), regularTimePeriod2.getLastMillisecond(this.workingCalendar));
            range = Range.combine(range, range2);
        }
        return range;
    }

    public Range getRangeBounds(boolean bl2) {
        Range range = null;
        for (TimeSeries timeSeries : this.data) {
            Range range2 = new Range(timeSeries.getMinY(), timeSeries.getMaxY());
            range = Range.combineIgnoringNaN(range, range2);
        }
        return range;
    }

    @Override
    public Range getRangeBounds(List list, Range range, boolean bl2) {
        Range range2 = null;
        for (Comparable comparable : list) {
            TimeSeries timeSeries = this.getSeries(comparable);
            Range range3 = timeSeries.findValueRange(range, this.xPosition, this.workingCalendar.getTimeZone());
            range2 = Range.combineIgnoringNaN(range2, range3);
        }
        return range2;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"Key".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        Series series = (Series)propertyChangeEvent.getSource();
        if (this.getSeriesIndex(series.getKey()) == -1) {
            throw new IllegalStateException("Receiving events from a series that does not belong to this collection.");
        }
        Comparable comparable = (Comparable)propertyChangeEvent.getNewValue();
        if (this.getSeriesIndex(comparable) >= 0) {
            throw new PropertyVetoException("Duplicate key2", propertyChangeEvent);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeSeriesCollection)) {
            return false;
        }
        TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)object;
        if (this.xPosition != timeSeriesCollection.xPosition) {
            return false;
        }
        if (this.domainIsPointsInTime != timeSeriesCollection.domainIsPointsInTime) {
            return false;
        }
        return ObjectUtilities.equal(this.data, timeSeriesCollection.data);
    }

    public int hashCode() {
        int n2 = this.data.hashCode();
        n2 = 29 * n2 + (this.workingCalendar != null ? this.workingCalendar.hashCode() : 0);
        n2 = 29 * n2 + (this.xPosition != null ? this.xPosition.hashCode() : 0);
        n2 = 29 * n2 + (this.domainIsPointsInTime ? 1 : 0);
        return n2;
    }

    @Override
    public Object clone() {
        TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)super.clone();
        timeSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        timeSeriesCollection.workingCalendar = (Calendar)this.workingCalendar.clone();
        return timeSeriesCollection;
    }
}

