/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.util.ObjectUtilities;

public class TimeSeries
extends Series
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5032960206869675528L;
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    protected Class timePeriodClass;
    protected List data;
    private int maximumItemCount;
    private long maximumItemAge;
    private double minY;
    private double maxY;

    public TimeSeries(Comparable comparable) {
        this(comparable, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION);
    }

    public TimeSeries(Comparable comparable, String string, String string2) {
        super(comparable);
        this.domain = string;
        this.range = string2;
        this.timePeriodClass = null;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.maximumItemAge = Long.MAX_VALUE;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative 'maximum' argument.");
        }
        this.maximumItemCount = n2;
        int n3 = this.data.size();
        if (n3 > n2) {
            this.delete(0, n3 - n2 - 1);
        }
    }

    public long getMaximumItemAge() {
        return this.maximumItemAge;
    }

    public void setMaximumItemAge(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative 'periods' argument.");
        }
        this.maximumItemAge = l2;
        this.removeAgedItems(true);
    }

    public Range findValueRange() {
        if (this.data.isEmpty()) {
            return null;
        }
        return new Range(this.minY, this.maxY);
    }

    public Range findValueRange(Range range, TimeZone timeZone) {
        return this.findValueRange(range, TimePeriodAnchor.MIDDLE, timeZone);
    }

    public Range findValueRange(Range range, TimePeriodAnchor timePeriodAnchor, TimeZone timeZone) {
        ParamChecks.nullNotPermitted(range, "xRange");
        ParamChecks.nullNotPermitted(timePeriodAnchor, "xAnchor");
        ParamChecks.nullNotPermitted(timeZone, "zone");
        if (this.data.isEmpty()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            Number number;
            TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(i2);
            long l2 = timeSeriesDataItem.getPeriod().getMillisecond(timePeriodAnchor, calendar);
            if (!range.contains(l2) || (number = timeSeriesDataItem.getValue()) == null) continue;
            double d4 = number.doubleValue();
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4);
        }
        if (Double.isInfinite(d2) && Double.isInfinite(d3)) {
            if (d2 < d3) {
                return new Range(d2, d3);
            }
            return new Range(Double.NaN, Double.NaN);
        }
        return new Range(d2, d3);
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public TimeSeriesDataItem getDataItem(int n2) {
        TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(n2);
        return (TimeSeriesDataItem)timeSeriesDataItem.clone();
    }

    public TimeSeriesDataItem getDataItem(RegularTimePeriod regularTimePeriod) {
        int n2 = this.getIndex(regularTimePeriod);
        if (n2 >= 0) {
            return this.getDataItem(n2);
        }
        return null;
    }

    TimeSeriesDataItem getRawDataItem(int n2) {
        return (TimeSeriesDataItem)this.data.get(n2);
    }

    TimeSeriesDataItem getRawDataItem(RegularTimePeriod regularTimePeriod) {
        int n2 = this.getIndex(regularTimePeriod);
        if (n2 >= 0) {
            return (TimeSeriesDataItem)this.data.get(n2);
        }
        return null;
    }

    public RegularTimePeriod getTimePeriod(int n2) {
        return this.getRawDataItem(n2).getPeriod();
    }

    public RegularTimePeriod getNextTimePeriod() {
        RegularTimePeriod regularTimePeriod = this.getTimePeriod(this.getItemCount() - 1);
        return regularTimePeriod.next();
    }

    public Collection getTimePeriods() {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            arrayList.add(this.getTimePeriod(i2));
        }
        return arrayList;
    }

    public Collection getTimePeriodsUniqueToOtherSeries(TimeSeries timeSeries) {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        for (int i2 = 0; i2 < timeSeries.getItemCount(); ++i2) {
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(i2);
            int n2 = this.getIndex(regularTimePeriod);
            if (n2 >= 0) continue;
            arrayList.add(regularTimePeriod);
        }
        return arrayList;
    }

    public int getIndex(RegularTimePeriod regularTimePeriod) {
        ParamChecks.nullNotPermitted(regularTimePeriod, "period");
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, -2.147483648E9);
        return Collections.binarySearch(this.data, timeSeriesDataItem);
    }

    public Number getValue(int n2) {
        return this.getRawDataItem(n2).getValue();
    }

    public Number getValue(RegularTimePeriod regularTimePeriod) {
        int n2 = this.getIndex(regularTimePeriod);
        if (n2 >= 0) {
            return this.getValue(n2);
        }
        return null;
    }

    public void add(TimeSeriesDataItem timeSeriesDataItem) {
        this.add(timeSeriesDataItem, true);
    }

    public void add(TimeSeriesDataItem timeSeriesDataItem, boolean bl2) {
        Comparable comparable;
        ParamChecks.nullNotPermitted(timeSeriesDataItem, "item");
        timeSeriesDataItem = (TimeSeriesDataItem)timeSeriesDataItem.clone();
        Class<?> clazz = timeSeriesDataItem.getPeriod().getClass();
        if (this.timePeriodClass == null) {
            this.timePeriodClass = clazz;
        } else if (!this.timePeriodClass.equals(clazz)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("You are trying to add data where the time period class ");
            stringBuilder.append("is ");
            stringBuilder.append(timeSeriesDataItem.getPeriod().getClass().getName());
            stringBuilder.append(", but the TimeSeries is expecting an instance of ");
            stringBuilder.append(this.timePeriodClass.getName());
            stringBuilder.append(".");
            throw new SeriesException(stringBuilder.toString());
        }
        boolean bl3 = false;
        int n2 = this.getItemCount();
        if (n2 == 0) {
            this.data.add(timeSeriesDataItem);
            bl3 = true;
        } else {
            comparable = this.getTimePeriod(this.getItemCount() - 1);
            if (timeSeriesDataItem.getPeriod().compareTo(comparable) > 0) {
                this.data.add(timeSeriesDataItem);
                bl3 = true;
            } else {
                int n3 = Collections.binarySearch(this.data, timeSeriesDataItem);
                if (n3 < 0) {
                    this.data.add(-n3 - 1, timeSeriesDataItem);
                    bl3 = true;
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("You are attempting to add an observation for ");
                    stringBuilder.append("the time period ");
                    stringBuilder.append(timeSeriesDataItem.getPeriod().toString());
                    stringBuilder.append(" but the series already contains an observation");
                    stringBuilder.append(" for that time period. Duplicates are not ");
                    stringBuilder.append("permitted.  Try using the addOrUpdate() method.");
                    throw new SeriesException(stringBuilder.toString());
                }
            }
        }
        if (bl3) {
            this.updateBoundsForAddedItem(timeSeriesDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                comparable = (TimeSeriesDataItem)this.data.remove(0);
                this.updateBoundsForRemovedItem((TimeSeriesDataItem)comparable);
            }
            this.removeAgedItems(false);
            if (bl2) {
                this.fireSeriesChanged();
            }
        }
    }

    public void add(RegularTimePeriod regularTimePeriod, double d2) {
        this.add(regularTimePeriod, d2, true);
    }

    public void add(RegularTimePeriod regularTimePeriod, double d2, boolean bl2) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, d2);
        this.add(timeSeriesDataItem, bl2);
    }

    public void add(RegularTimePeriod regularTimePeriod, Number number) {
        this.add(regularTimePeriod, number, true);
    }

    public void add(RegularTimePeriod regularTimePeriod, Number number, boolean bl2) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        this.add(timeSeriesDataItem, bl2);
    }

    public void update(RegularTimePeriod regularTimePeriod, double d2) {
        this.update(regularTimePeriod, (Number)new Double(d2));
    }

    public void update(RegularTimePeriod regularTimePeriod, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        int n2 = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n2 < 0) {
            throw new SeriesException("There is no existing value for the specified 'period'.");
        }
        this.update(n2, number);
    }

    public void update(int n2, Number number) {
        double d2;
        TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(n2);
        boolean bl2 = false;
        Number number2 = timeSeriesDataItem.getValue();
        if (number2 != null && !Double.isNaN(d2 = number2.doubleValue())) {
            bl2 = d2 <= this.minY || d2 >= this.maxY;
        }
        timeSeriesDataItem.setValue(number);
        if (bl2) {
            this.updateMinMaxYByIteration();
        } else if (number != null) {
            d2 = number.doubleValue();
            this.minY = this.minIgnoreNaN(this.minY, d2);
            this.maxY = this.maxIgnoreNaN(this.maxY, d2);
        }
        this.fireSeriesChanged();
    }

    public TimeSeries addAndOrUpdate(TimeSeries timeSeries) {
        TimeSeries timeSeries2 = new TimeSeries((Comparable)((Object)("Overwritten values from: " + this.getKey())));
        for (int i2 = 0; i2 < timeSeries.getItemCount(); ++i2) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getRawDataItem(i2);
            TimeSeriesDataItem timeSeriesDataItem2 = this.addOrUpdate(timeSeriesDataItem.getPeriod(), timeSeriesDataItem.getValue());
            if (timeSeriesDataItem2 == null) continue;
            timeSeries2.add(timeSeriesDataItem2);
        }
        return timeSeries2;
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod regularTimePeriod, double d2) {
        return this.addOrUpdate(regularTimePeriod, new Double(d2));
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod regularTimePeriod, Number number) {
        return this.addOrUpdate(new TimeSeriesDataItem(regularTimePeriod, number));
    }

    public TimeSeriesDataItem addOrUpdate(TimeSeriesDataItem timeSeriesDataItem) {
        ParamChecks.nullNotPermitted(timeSeriesDataItem, "item");
        Class<?> clazz = timeSeriesDataItem.getPeriod().getClass();
        if (this.timePeriodClass == null) {
            this.timePeriodClass = clazz;
        } else if (!this.timePeriodClass.equals(clazz)) {
            String string = "You are trying to add data where the time period class is " + clazz.getName() + ", but the TimeSeries is expecting an instance of " + this.timePeriodClass.getName() + ".";
            throw new SeriesException(string);
        }
        TimeSeriesDataItem timeSeriesDataItem2 = null;
        int n2 = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n2 >= 0) {
            double d2;
            TimeSeriesDataItem timeSeriesDataItem3 = (TimeSeriesDataItem)this.data.get(n2);
            timeSeriesDataItem2 = (TimeSeriesDataItem)timeSeriesDataItem3.clone();
            boolean bl2 = false;
            Number number = timeSeriesDataItem3.getValue();
            double d3 = d2 = number != null ? number.doubleValue() : Double.NaN;
            if (!Double.isNaN(d2)) {
                bl2 = d2 <= this.minY || d2 >= this.maxY;
            }
            timeSeriesDataItem3.setValue(timeSeriesDataItem.getValue());
            if (bl2) {
                this.updateMinMaxYByIteration();
            } else if (timeSeriesDataItem.getValue() != null) {
                double d4 = timeSeriesDataItem.getValue().doubleValue();
                this.minY = this.minIgnoreNaN(this.minY, d4);
                this.maxY = this.maxIgnoreNaN(this.maxY, d4);
            }
        } else {
            timeSeriesDataItem = (TimeSeriesDataItem)timeSeriesDataItem.clone();
            this.data.add(-n2 - 1, timeSeriesDataItem);
            this.updateBoundsForAddedItem(timeSeriesDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                TimeSeriesDataItem timeSeriesDataItem4 = (TimeSeriesDataItem)this.data.remove(0);
                this.updateBoundsForRemovedItem(timeSeriesDataItem4);
            }
        }
        this.removeAgedItems(false);
        this.fireSeriesChanged();
        return timeSeriesDataItem2;
    }

    public void removeAgedItems(boolean bl2) {
        if (this.getItemCount() > 1) {
            long l2 = this.getTimePeriod(this.getItemCount() - 1).getSerialIndex();
            boolean bl3 = false;
            while (l2 - this.getTimePeriod(0).getSerialIndex() > this.maximumItemAge) {
                this.data.remove(0);
                bl3 = true;
            }
            if (bl3) {
                this.updateMinMaxYByIteration();
                if (bl2) {
                    this.fireSeriesChanged();
                }
            }
        }
    }

    public void removeAgedItems(long l2, boolean bl2) {
        if (this.data.isEmpty()) {
            return;
        }
        long l3 = Long.MAX_VALUE;
        try {
            Method method = RegularTimePeriod.class.getDeclaredMethod("createInstance", Class.class, Date.class, TimeZone.class);
            RegularTimePeriod regularTimePeriod = (RegularTimePeriod)method.invoke((Object)this.timePeriodClass, this.timePeriodClass, new Date(l2), TimeZone.getDefault());
            l3 = regularTimePeriod.getSerialIndex();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        boolean bl3 = false;
        while (this.getItemCount() > 0 && l3 - this.getTimePeriod(0).getSerialIndex() > this.maximumItemAge) {
            this.data.remove(0);
            bl3 = true;
        }
        if (bl3) {
            this.updateMinMaxYByIteration();
            if (bl2) {
                this.fireSeriesChanged();
            }
        }
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.timePeriodClass = null;
            this.minY = Double.NaN;
            this.maxY = Double.NaN;
            this.fireSeriesChanged();
        }
    }

    public void delete(RegularTimePeriod regularTimePeriod) {
        int n2 = this.getIndex(regularTimePeriod);
        if (n2 >= 0) {
            TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.remove(n2);
            this.updateBoundsForRemovedItem(timeSeriesDataItem);
            if (this.data.isEmpty()) {
                this.timePeriodClass = null;
            }
            this.fireSeriesChanged();
        }
    }

    public void delete(int n2, int n3) {
        this.delete(n2, n3, true);
    }

    public void delete(int n2, int n3, boolean bl2) {
        if (n3 < n2) {
            throw new IllegalArgumentException("Requires start <= end.");
        }
        for (int i2 = 0; i2 <= n3 - n2; ++i2) {
            this.data.remove(n2);
        }
        this.updateMinMaxYByIteration();
        if (this.data.isEmpty()) {
            this.timePeriodClass = null;
        }
        if (bl2) {
            this.fireSeriesChanged();
        }
    }

    @Override
    public Object clone() {
        TimeSeries timeSeries = (TimeSeries)super.clone();
        timeSeries.data = (List)ObjectUtilities.deepClone(this.data);
        return timeSeries;
    }

    public TimeSeries createCopy(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Requires start >= 0.");
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("Requires start <= end.");
        }
        TimeSeries timeSeries = (TimeSeries)super.clone();
        timeSeries.minY = Double.NaN;
        timeSeries.maxY = Double.NaN;
        timeSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(i2);
                TimeSeriesDataItem timeSeriesDataItem2 = (TimeSeriesDataItem)timeSeriesDataItem.clone();
                try {
                    timeSeries.add(timeSeriesDataItem2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    throw new RuntimeException(seriesException);
                }
            }
        }
        return timeSeries;
    }

    public TimeSeries createCopy(RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) {
        int n2;
        ParamChecks.nullNotPermitted(regularTimePeriod, "start");
        ParamChecks.nullNotPermitted(regularTimePeriod2, "end");
        if (regularTimePeriod.compareTo(regularTimePeriod2) > 0) {
            throw new IllegalArgumentException("Requires start on or before end.");
        }
        boolean bl2 = false;
        int n3 = this.getIndex(regularTimePeriod);
        if (n3 < 0 && (n3 = -(n3 + 1)) == this.data.size()) {
            bl2 = true;
        }
        if ((n2 = this.getIndex(regularTimePeriod2)) < 0) {
            n2 = -(n2 + 1);
            --n2;
        }
        if (n2 < 0 || n2 < n3) {
            bl2 = true;
        }
        if (bl2) {
            TimeSeries timeSeries = (TimeSeries)super.clone();
            timeSeries.data = new ArrayList();
            return timeSeries;
        }
        return this.createCopy(n3, n2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeSeries)) {
            return false;
        }
        TimeSeries timeSeries = (TimeSeries)object;
        if (!ObjectUtilities.equal(this.getDomainDescription(), timeSeries.getDomainDescription())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getRangeDescription(), timeSeries.getRangeDescription())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.timePeriodClass, timeSeries.timePeriodClass)) {
            return false;
        }
        if (this.getMaximumItemAge() != timeSeries.getMaximumItemAge()) {
            return false;
        }
        if (this.getMaximumItemCount() != timeSeries.getMaximumItemCount()) {
            return false;
        }
        int n2 = this.getItemCount();
        if (n2 != timeSeries.getItemCount()) {
            return false;
        }
        if (!ObjectUtilities.equal(this.data, timeSeries.data)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        TimeSeriesDataItem timeSeriesDataItem;
        int n2 = super.hashCode();
        n2 = 29 * n2 + (this.domain != null ? this.domain.hashCode() : 0);
        n2 = 29 * n2 + (this.range != null ? this.range.hashCode() : 0);
        n2 = 29 * n2 + (this.timePeriodClass != null ? this.timePeriodClass.hashCode() : 0);
        int n3 = this.getItemCount();
        if (n3 > 0) {
            timeSeriesDataItem = this.getRawDataItem(0);
            n2 = 29 * n2 + timeSeriesDataItem.hashCode();
        }
        if (n3 > 1) {
            timeSeriesDataItem = this.getRawDataItem(n3 - 1);
            n2 = 29 * n2 + timeSeriesDataItem.hashCode();
        }
        if (n3 > 2) {
            timeSeriesDataItem = this.getRawDataItem(n3 / 2);
            n2 = 29 * n2 + timeSeriesDataItem.hashCode();
        }
        n2 = 29 * n2 + this.maximumItemCount;
        n2 = 29 * n2 + (int)this.maximumItemAge;
        return n2;
    }

    private void updateBoundsForAddedItem(TimeSeriesDataItem timeSeriesDataItem) {
        Number number = timeSeriesDataItem.getValue();
        if (timeSeriesDataItem.getValue() != null) {
            double d2 = number.doubleValue();
            this.minY = this.minIgnoreNaN(this.minY, d2);
            this.maxY = this.maxIgnoreNaN(this.maxY, d2);
        }
    }

    private void updateBoundsForRemovedItem(TimeSeriesDataItem timeSeriesDataItem) {
        double d2;
        Number number = timeSeriesDataItem.getValue();
        if (number != null && !Double.isNaN(d2 = number.doubleValue()) && (d2 <= this.minY || d2 >= this.maxY)) {
            this.updateMinMaxYByIteration();
        }
    }

    private void updateMinMaxYByIteration() {
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        for (TimeSeriesDataItem timeSeriesDataItem : this.data) {
            this.updateBoundsForAddedItem(timeSeriesDataItem);
        }
    }

    private double minIgnoreNaN(double d2, double d3) {
        if (Double.isNaN(d2)) {
            return d3;
        }
        if (Double.isNaN(d3)) {
            return d2;
        }
        return Math.min(d2, d3);
    }

    private double maxIgnoreNaN(double d2, double d3) {
        if (Double.isNaN(d2)) {
            return d3;
        }
        if (Double.isNaN(d3)) {
            return d2;
        }
        return Math.max(d2, d3);
    }

    public TimeSeries(Comparable comparable, Class clazz) {
        this(comparable, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, clazz);
    }

    public TimeSeries(Comparable comparable, String string, String string2, Class clazz) {
        super(comparable);
        this.domain = string;
        this.range = string2;
        this.timePeriodClass = clazz;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.maximumItemAge = Long.MAX_VALUE;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
    }
}

