/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValue;
import org.jfree.util.ObjectUtilities;

public class TimePeriodValues
extends Series
implements Serializable {
    static final long serialVersionUID = -2210593619794989709L;
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    private List data;
    private int minStartIndex = -1;
    private int maxStartIndex = -1;
    private int minMiddleIndex = -1;
    private int maxMiddleIndex = -1;
    private int minEndIndex = -1;
    private int maxEndIndex = -1;

    public TimePeriodValues(String string) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION);
    }

    public TimePeriodValues(String string, String string2, String string3) {
        super((Comparable)((Object)string));
        this.domain = string2;
        this.range = string3;
        this.data = new ArrayList();
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    public TimePeriodValue getDataItem(int n2) {
        return (TimePeriodValue)this.data.get(n2);
    }

    public TimePeriod getTimePeriod(int n2) {
        return this.getDataItem(n2).getPeriod();
    }

    public Number getValue(int n2) {
        return this.getDataItem(n2).getValue();
    }

    public void add(TimePeriodValue timePeriodValue) {
        ParamChecks.nullNotPermitted(timePeriodValue, "item");
        this.data.add(timePeriodValue);
        this.updateBounds(timePeriodValue.getPeriod(), this.data.size() - 1);
        this.fireSeriesChanged();
    }

    private void updateBounds(TimePeriod timePeriod, int n2) {
        long l2;
        long l3;
        long l4;
        long l5 = timePeriod.getStart().getTime();
        long l6 = timePeriod.getEnd().getTime();
        long l7 = l5 + (l6 - l5) / 2L;
        if (this.minStartIndex >= 0) {
            l4 = this.getDataItem(this.minStartIndex).getPeriod().getStart().getTime();
            if (l5 < l4) {
                this.minStartIndex = n2;
            }
        } else {
            this.minStartIndex = n2;
        }
        if (this.maxStartIndex >= 0) {
            l4 = this.getDataItem(this.maxStartIndex).getPeriod().getStart().getTime();
            if (l5 > l4) {
                this.maxStartIndex = n2;
            }
        } else {
            this.maxStartIndex = n2;
        }
        if (this.minMiddleIndex >= 0) {
            l4 = this.getDataItem(this.minMiddleIndex).getPeriod().getStart().getTime();
            l2 = l4 + ((l3 = this.getDataItem(this.minMiddleIndex).getPeriod().getEnd().getTime()) - l4) / 2L;
            if (l7 < l2) {
                this.minMiddleIndex = n2;
            }
        } else {
            this.minMiddleIndex = n2;
        }
        if (this.maxMiddleIndex >= 0) {
            l4 = this.getDataItem(this.maxMiddleIndex).getPeriod().getStart().getTime();
            l2 = l4 + ((l3 = this.getDataItem(this.maxMiddleIndex).getPeriod().getEnd().getTime()) - l4) / 2L;
            if (l7 > l2) {
                this.maxMiddleIndex = n2;
            }
        } else {
            this.maxMiddleIndex = n2;
        }
        if (this.minEndIndex >= 0) {
            l4 = this.getDataItem(this.minEndIndex).getPeriod().getEnd().getTime();
            if (l6 < l4) {
                this.minEndIndex = n2;
            }
        } else {
            this.minEndIndex = n2;
        }
        if (this.maxEndIndex >= 0) {
            l4 = this.getDataItem(this.maxEndIndex).getPeriod().getEnd().getTime();
            if (l6 > l4) {
                this.maxEndIndex = n2;
            }
        } else {
            this.maxEndIndex = n2;
        }
    }

    private void recalculateBounds() {
        this.minStartIndex = -1;
        this.minMiddleIndex = -1;
        this.minEndIndex = -1;
        this.maxStartIndex = -1;
        this.maxMiddleIndex = -1;
        this.maxEndIndex = -1;
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            TimePeriodValue timePeriodValue = (TimePeriodValue)this.data.get(i2);
            this.updateBounds(timePeriodValue.getPeriod(), i2);
        }
    }

    public void add(TimePeriod timePeriod, double d2) {
        TimePeriodValue timePeriodValue = new TimePeriodValue(timePeriod, d2);
        this.add(timePeriodValue);
    }

    public void add(TimePeriod timePeriod, Number number) {
        TimePeriodValue timePeriodValue = new TimePeriodValue(timePeriod, number);
        this.add(timePeriodValue);
    }

    public void update(int n2, Number number) {
        TimePeriodValue timePeriodValue = this.getDataItem(n2);
        timePeriodValue.setValue(number);
        this.fireSeriesChanged();
    }

    public void delete(int n2, int n3) {
        for (int i2 = 0; i2 <= n3 - n2; ++i2) {
            this.data.remove(n2);
        }
        this.recalculateBounds();
        this.fireSeriesChanged();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimePeriodValues)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TimePeriodValues timePeriodValues = (TimePeriodValues)object;
        if (!ObjectUtilities.equal(this.getDomainDescription(), timePeriodValues.getDomainDescription())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getRangeDescription(), timePeriodValues.getRangeDescription())) {
            return false;
        }
        int n2 = this.getItemCount();
        if (n2 != timePeriodValues.getItemCount()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.getDataItem(i2).equals(timePeriodValues.getDataItem(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = this.domain != null ? this.domain.hashCode() : 0;
        n2 = 29 * n2 + (this.range != null ? this.range.hashCode() : 0);
        n2 = 29 * n2 + this.data.hashCode();
        n2 = 29 * n2 + this.minStartIndex;
        n2 = 29 * n2 + this.maxStartIndex;
        n2 = 29 * n2 + this.minMiddleIndex;
        n2 = 29 * n2 + this.maxMiddleIndex;
        n2 = 29 * n2 + this.minEndIndex;
        n2 = 29 * n2 + this.maxEndIndex;
        return n2;
    }

    @Override
    public Object clone() {
        TimePeriodValues timePeriodValues = this.createCopy(0, this.getItemCount() - 1);
        return timePeriodValues;
    }

    public TimePeriodValues createCopy(int n2, int n3) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)super.clone();
        timePeriodValues.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                TimePeriodValue timePeriodValue = (TimePeriodValue)this.data.get(i2);
                TimePeriodValue timePeriodValue2 = (TimePeriodValue)timePeriodValue.clone();
                try {
                    timePeriodValues.add(timePeriodValue2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    System.err.println("Failed to add cloned item.");
                }
            }
        }
        return timePeriodValues;
    }

    public int getMinStartIndex() {
        return this.minStartIndex;
    }

    public int getMaxStartIndex() {
        return this.maxStartIndex;
    }

    public int getMinMiddleIndex() {
        return this.minMiddleIndex;
    }

    public int getMaxMiddleIndex() {
        return this.maxMiddleIndex;
    }

    public int getMinEndIndex() {
        return this.minEndIndex;
    }

    public int getMaxEndIndex() {
        return this.maxEndIndex;
    }
}

