/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Date;
import org.jfree.data.time.TimePeriod;

public class SimpleTimePeriod
implements Serializable,
Comparable,
TimePeriod {
    private static final long serialVersionUID = 8684672361131829554L;
    private long start;
    private long end;

    public SimpleTimePeriod(long l2, long l3) {
        if (l2 > l3) {
            throw new IllegalArgumentException("Requires start <= end.");
        }
        this.start = l2;
        this.end = l3;
    }

    public SimpleTimePeriod(Date date, Date date2) {
        this(date.getTime(), date2.getTime());
    }

    @Override
    public Date getStart() {
        return new Date(this.start);
    }

    public long getStartMillis() {
        return this.start;
    }

    @Override
    public Date getEnd() {
        return new Date(this.end);
    }

    public long getEndMillis() {
        return this.end;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimePeriod)) {
            return false;
        }
        TimePeriod timePeriod = (TimePeriod)object;
        if (!this.getStart().equals(timePeriod.getStart())) {
            return false;
        }
        return this.getEnd().equals(timePeriod.getEnd());
    }

    public int compareTo(Object object) {
        long l2;
        long l3;
        long l4;
        long l5;
        TimePeriod timePeriod = (TimePeriod)object;
        long l6 = this.getStart().getTime();
        long l7 = l6 + ((l5 = this.getEnd().getTime()) - l6) / 2L;
        if (l7 < (l4 = (l3 = timePeriod.getStart().getTime()) + ((l2 = timePeriod.getEnd().getTime()) - l3) / 2L)) {
            return -1;
        }
        if (l7 > l4) {
            return 1;
        }
        if (l6 < l3) {
            return -1;
        }
        if (l6 > l3) {
            return 1;
        }
        if (l5 < l2) {
            return -1;
        }
        if (l5 > l2) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + (int)this.start;
        n2 = 37 * n2 + (int)this.end;
        return n2;
    }
}

