/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.Year;
import org.jfree.date.MonthConstants;

public abstract class RegularTimePeriod
implements Comparable,
TimePeriod,
MonthConstants {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    public static final Calendar WORKING_CALENDAR = Calendar.getInstance(DEFAULT_TIME_ZONE);

    public static RegularTimePeriod createInstance(Class clazz, Date date, TimeZone timeZone) {
        RegularTimePeriod regularTimePeriod = null;
        try {
            Constructor constructor = clazz.getDeclaredConstructor(Date.class, TimeZone.class);
            regularTimePeriod = (RegularTimePeriod)constructor.newInstance(date, timeZone);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return regularTimePeriod;
    }

    public static Class downsize(Class clazz) {
        if (clazz.equals(Year.class)) {
            return Quarter.class;
        }
        if (clazz.equals(Quarter.class)) {
            return Month.class;
        }
        if (clazz.equals(Month.class)) {
            return Day.class;
        }
        if (clazz.equals(Day.class)) {
            return Hour.class;
        }
        if (clazz.equals(Hour.class)) {
            return Minute.class;
        }
        if (clazz.equals(Minute.class)) {
            return Second.class;
        }
        if (clazz.equals(Second.class)) {
            return Millisecond.class;
        }
        return Millisecond.class;
    }

    public abstract RegularTimePeriod previous();

    public abstract RegularTimePeriod next();

    public abstract long getSerialIndex();

    public abstract void peg(Calendar var1);

    @Override
    public Date getStart() {
        return new Date(this.getFirstMillisecond());
    }

    @Override
    public Date getEnd() {
        return new Date(this.getLastMillisecond());
    }

    public abstract long getFirstMillisecond();

    public long getFirstMillisecond(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        return this.getFirstMillisecond(calendar);
    }

    public abstract long getFirstMillisecond(Calendar var1);

    public abstract long getLastMillisecond();

    public long getLastMillisecond(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        return this.getLastMillisecond(calendar);
    }

    public abstract long getLastMillisecond(Calendar var1);

    public long getMiddleMillisecond() {
        long l2 = this.getFirstMillisecond();
        long l3 = this.getLastMillisecond();
        return l2 + (l3 - l2) / 2L;
    }

    public long getMiddleMillisecond(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        long l2 = this.getFirstMillisecond(calendar);
        long l3 = this.getLastMillisecond(calendar);
        return l2 + (l3 - l2) / 2L;
    }

    public long getMiddleMillisecond(Calendar calendar) {
        long l2 = this.getFirstMillisecond(calendar);
        long l3 = this.getLastMillisecond(calendar);
        return l2 + (l3 - l2) / 2L;
    }

    public long getMillisecond(TimePeriodAnchor timePeriodAnchor, Calendar calendar) {
        if (timePeriodAnchor.equals(TimePeriodAnchor.START)) {
            return this.getFirstMillisecond(calendar);
        }
        if (timePeriodAnchor.equals(TimePeriodAnchor.MIDDLE)) {
            return this.getMiddleMillisecond(calendar);
        }
        if (timePeriodAnchor.equals(TimePeriodAnchor.END)) {
            return this.getLastMillisecond(calendar);
        }
        throw new IllegalStateException("Unrecognised anchor: " + timePeriodAnchor);
    }

    public String toString() {
        return String.valueOf(this.getStart());
    }
}

