/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import org.jfree.chart.util.ParamChecks;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MovingAverage {
    public static TimeSeriesCollection createMovingAverage(TimeSeriesCollection timeSeriesCollection, String string, int n2, int n3) {
        ParamChecks.nullNotPermitted(timeSeriesCollection, "source");
        if (n2 < 1) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 1.");
        }
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection();
        for (int i2 = 0; i2 < timeSeriesCollection.getSeriesCount(); ++i2) {
            TimeSeries timeSeries = timeSeriesCollection.getSeries(i2);
            TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, timeSeries.getKey() + string, n2, n3);
            timeSeriesCollection2.addSeries(timeSeries2);
        }
        return timeSeriesCollection2;
    }

    public static TimeSeries createMovingAverage(TimeSeries timeSeries, String string, int n2, int n3) {
        ParamChecks.nullNotPermitted(timeSeries, "source");
        if (n2 < 1) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 1.");
        }
        TimeSeries timeSeries2 = new TimeSeries((Comparable)((Object)string));
        if (timeSeries.getItemCount() > 0) {
            long l2 = timeSeries.getTimePeriod(0).getSerialIndex() + (long)n3;
            for (int i2 = timeSeries.getItemCount() - 1; i2 >= 0; --i2) {
                RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(i2);
                long l3 = regularTimePeriod.getSerialIndex();
                if (l3 < l2) continue;
                int n4 = 0;
                double d2 = 0.0;
                long l4 = regularTimePeriod.getSerialIndex() - (long)n2;
                boolean bl2 = false;
                for (int i3 = 0; i3 < n2 && !bl2; ++i3) {
                    if (i2 - i3 < 0) continue;
                    TimeSeriesDataItem timeSeriesDataItem = timeSeries.getRawDataItem(i2 - i3);
                    RegularTimePeriod regularTimePeriod2 = timeSeriesDataItem.getPeriod();
                    Number number = timeSeriesDataItem.getValue();
                    long l5 = regularTimePeriod2.getSerialIndex();
                    if (l5 > l4) {
                        if (number == null) continue;
                        d2 += number.doubleValue();
                        ++n4;
                        continue;
                    }
                    bl2 = true;
                }
                if (n4 > 0) {
                    timeSeries2.add(regularTimePeriod, d2 / (double)n4);
                    continue;
                }
                timeSeries2.add(regularTimePeriod, null);
            }
        }
        return timeSeries2;
    }

    public static TimeSeries createPointMovingAverage(TimeSeries timeSeries, String string, int n2) {
        ParamChecks.nullNotPermitted(timeSeries, "source");
        if (n2 < 2) {
            throw new IllegalArgumentException("periodCount must be greater than or equal to 2.");
        }
        TimeSeries timeSeries2 = new TimeSeries((Comparable)((Object)string));
        double d2 = 0.0;
        for (int i2 = 0; i2 < timeSeries.getItemCount(); ++i2) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getRawDataItem(i2);
            RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
            d2 += timeSeriesDataItem.getValue().doubleValue();
            if (i2 > n2 - 1) {
                TimeSeriesDataItem timeSeriesDataItem2 = timeSeries.getRawDataItem(i2 - n2);
                timeSeries2.add(regularTimePeriod, (d2 -= timeSeriesDataItem2.getValue().doubleValue()) / (double)n2);
                continue;
            }
            if (i2 != n2 - 1) continue;
            timeSeries2.add(regularTimePeriod, d2 / (double)n2);
        }
        return timeSeries2;
    }

    public static XYDataset createMovingAverage(XYDataset xYDataset, String string, long l2, long l3) {
        return MovingAverage.createMovingAverage(xYDataset, string, (double)l2, (double)l3);
    }

    public static XYDataset createMovingAverage(XYDataset xYDataset, String string, double d2, double d3) {
        ParamChecks.nullNotPermitted(xYDataset, "source");
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i2 = 0; i2 < xYDataset.getSeriesCount(); ++i2) {
            XYSeries xYSeries = MovingAverage.createMovingAverage(xYDataset, i2, xYDataset.getSeriesKey(i2) + string, d2, d3);
            xYSeriesCollection.addSeries(xYSeries);
        }
        return xYSeriesCollection;
    }

    public static XYSeries createMovingAverage(XYDataset xYDataset, int n2, String string, double d2, double d3) {
        ParamChecks.nullNotPermitted(xYDataset, "source");
        if (d2 < Double.MIN_VALUE) {
            throw new IllegalArgumentException("period must be positive.");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("skip must be >= 0.0.");
        }
        XYSeries xYSeries = new XYSeries((Comparable)((Object)string));
        if (xYDataset.getItemCount(n2) > 0) {
            double d4 = xYDataset.getXValue(n2, 0) + d3;
            for (int i2 = xYDataset.getItemCount(n2) - 1; i2 >= 0; --i2) {
                double d5 = xYDataset.getXValue(n2, i2);
                if (!(d5 >= d4)) continue;
                int n3 = 0;
                double d6 = 0.0;
                double d7 = d5 - d2;
                int n4 = 0;
                boolean bl2 = false;
                while (!bl2) {
                    if (i2 - n4 >= 0) {
                        double d8 = xYDataset.getXValue(n2, i2 - n4);
                        Number number = xYDataset.getY(n2, i2 - n4);
                        if (d8 > d7) {
                            if (number != null) {
                                d6 += number.doubleValue();
                                ++n3;
                            }
                        } else {
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    ++n4;
                }
                if (n3 > 0) {
                    xYSeries.add(d5, d6 / (double)n3);
                    continue;
                }
                xYSeries.add(d5, (Number)null);
            }
        }
        return xYSeries;
    }
}

