/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;
import org.jfree.date.SerialDate;

public class Month
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = -5090216912548722570L;
    private int month;
    private int year;
    private long firstMillisecond;
    private long lastMillisecond;

    public Month() {
        this(new Date());
    }

    public Month(int n2, int n3) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Month outside valid range.");
        }
        this.month = n2;
        this.year = n3;
        this.peg(Calendar.getInstance());
    }

    public Month(int n2, Year year) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Month outside valid range.");
        }
        this.month = n2;
        this.year = year.getYear();
        this.peg(Calendar.getInstance());
    }

    public Month(Date date) {
        this(date, TimeZone.getDefault());
    }

    public Month(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Month(Date date, TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
        this.peg(calendar);
    }

    public Year getYear() {
        return new Year(this.year);
    }

    public int getYearValue() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    @Override
    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    @Override
    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    @Override
    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    @Override
    public RegularTimePeriod previous() {
        Month month = this.month != 1 ? new Month(this.month - 1, this.year) : (this.year > 1900 ? new Month(12, this.year - 1) : null);
        return month;
    }

    @Override
    public RegularTimePeriod next() {
        Month month = this.month != 12 ? new Month(this.month + 1, this.year) : (this.year < 9999 ? new Month(1, this.year + 1) : null);
        return month;
    }

    @Override
    public long getSerialIndex() {
        return (long)this.year * 12L + (long)this.month;
    }

    @Override
    public String toString() {
        return SerialDate.monthCodeToString(this.month) + " " + this.year;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Month)) {
            return false;
        }
        Month month = (Month)object;
        if (this.month != month.month) {
            return false;
        }
        return this.year == month.year;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.month;
        n2 = 37 * n2 + this.year;
        return n2;
    }

    public int compareTo(Object object) {
        int n2;
        if (object instanceof Month) {
            Month month = (Month)object;
            n2 = this.year - month.getYearValue();
            if (n2 == 0) {
                n2 = this.month - month.getMonth();
            }
        } else {
            n2 = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n2;
    }

    @Override
    public long getFirstMillisecond(Calendar calendar) {
        calendar.set(this.year, this.month - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public long getLastMillisecond(Calendar calendar) {
        int n2 = SerialDate.lastDayOfMonth(this.month, this.year);
        calendar.set(this.year, this.month - 1, n2, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis();
    }

    public static Month parseMonth(String string) {
        int n2;
        Year year;
        String string2;
        String string3;
        boolean bl2;
        Month month = null;
        if (string == null) {
            return month;
        }
        int n3 = Month.findSeparator(string = string.trim());
        if (n3 == -1) {
            bl2 = true;
            string3 = string.substring(0, 5);
            string2 = string.substring(5);
        } else {
            string3 = string.substring(0, n3).trim();
            string2 = string.substring(n3 + 1, string.length()).trim();
            year = Month.evaluateAsYear(string3);
            if (year == null) {
                bl2 = false;
            } else {
                Year year2 = Month.evaluateAsYear(string2);
                if (year2 == null) {
                    bl2 = true;
                } else {
                    boolean bl3 = bl2 = string3.length() > string2.length();
                }
            }
        }
        if (bl2) {
            year = Month.evaluateAsYear(string3);
            n2 = SerialDate.stringToMonthCode(string2);
        } else {
            year = Month.evaluateAsYear(string2);
            n2 = SerialDate.stringToMonthCode(string3);
        }
        if (n2 == -1) {
            throw new TimePeriodFormatException("Can't evaluate the month.");
        }
        if (year == null) {
            throw new TimePeriodFormatException("Can't evaluate the year.");
        }
        month = new Month(n2, year);
        return month;
    }

    private static int findSeparator(String string) {
        int n2 = string.indexOf(45);
        if (n2 == -1) {
            n2 = string.indexOf(44);
        }
        if (n2 == -1) {
            n2 = string.indexOf(32);
        }
        if (n2 == -1) {
            n2 = string.indexOf(46);
        }
        return n2;
    }

    private static Year evaluateAsYear(String string) {
        Year year = null;
        try {
            year = Year.parseYear(string);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            // empty catch block
        }
        return year;
    }
}

