/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;

public class Millisecond
extends RegularTimePeriod
implements Serializable {
    static final long serialVersionUID = -5316836467277638485L;
    public static final int FIRST_MILLISECOND_IN_SECOND = 0;
    public static final int LAST_MILLISECOND_IN_SECOND = 999;
    private Day day;
    private byte hour;
    private byte minute;
    private byte second;
    private int millisecond;
    private long firstMillisecond;

    public Millisecond() {
        this(new Date());
    }

    public Millisecond(int n2, Second second) {
        this.millisecond = n2;
        this.second = (byte)second.getSecond();
        this.minute = (byte)second.getMinute().getMinute();
        this.hour = (byte)second.getMinute().getHourValue();
        this.day = second.getMinute().getDay();
        this.peg(Calendar.getInstance());
    }

    public Millisecond(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(n2, new Second(n3, n4, n5, n6, n7, n8));
    }

    public Millisecond(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public Millisecond(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Millisecond(Date date, TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        this.millisecond = calendar.get(14);
        this.second = (byte)calendar.get(13);
        this.minute = (byte)calendar.get(12);
        this.hour = (byte)calendar.get(11);
        this.day = new Day(date, timeZone, locale);
        this.peg(calendar);
    }

    public Second getSecond() {
        return new Second(this.second, this.minute, this.hour, this.day.getDayOfMonth(), this.day.getMonth(), this.day.getYear());
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    @Override
    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    @Override
    public long getLastMillisecond() {
        return this.firstMillisecond;
    }

    @Override
    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
    }

    @Override
    public RegularTimePeriod previous() {
        Millisecond millisecond = null;
        if (this.millisecond != 0) {
            millisecond = new Millisecond(this.millisecond - 1, this.getSecond());
        } else {
            Second second = (Second)this.getSecond().previous();
            if (second != null) {
                millisecond = new Millisecond(999, second);
            }
        }
        return millisecond;
    }

    @Override
    public RegularTimePeriod next() {
        Millisecond millisecond = null;
        if (this.millisecond != 999) {
            millisecond = new Millisecond(this.millisecond + 1, this.getSecond());
        } else {
            Second second = (Second)this.getSecond().next();
            if (second != null) {
                millisecond = new Millisecond(0, second);
            }
        }
        return millisecond;
    }

    @Override
    public long getSerialIndex() {
        long l2 = this.day.getSerialIndex() * 24L + (long)this.hour;
        long l3 = l2 * 60L + (long)this.minute;
        long l4 = l3 * 60L + (long)this.second;
        return l4 * 1000L + (long)this.millisecond;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Millisecond)) {
            return false;
        }
        Millisecond millisecond = (Millisecond)object;
        if (this.millisecond != millisecond.millisecond) {
            return false;
        }
        if (this.second != millisecond.second) {
            return false;
        }
        if (this.minute != millisecond.minute) {
            return false;
        }
        if (this.hour != millisecond.hour) {
            return false;
        }
        return this.day.equals(millisecond.day);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.millisecond;
        n2 = 37 * n2 + this.getSecond().hashCode();
        return n2;
    }

    public int compareTo(Object object) {
        int n2;
        if (object instanceof Millisecond) {
            Millisecond millisecond = (Millisecond)object;
            long l2 = this.getFirstMillisecond() - millisecond.getFirstMillisecond();
            n2 = l2 > 0L ? 1 : (l2 < 0L ? -1 : 0);
        } else if (object instanceof RegularTimePeriod) {
            long l3;
            RegularTimePeriod regularTimePeriod = (RegularTimePeriod)object;
            long l4 = this.getFirstMillisecond();
            n2 = l4 < (l3 = regularTimePeriod.getFirstMillisecond()) ? -1 : (l4 == l3 ? 0 : 1);
        } else {
            n2 = 1;
        }
        return n2;
    }

    @Override
    public long getFirstMillisecond(Calendar calendar) {
        int n2 = this.day.getYear();
        int n3 = this.day.getMonth() - 1;
        int n4 = this.day.getDayOfMonth();
        calendar.clear();
        calendar.set(n2, n3, n4, this.hour, this.minute, this.second);
        calendar.set(14, this.millisecond);
        return calendar.getTimeInMillis();
    }

    @Override
    public long getLastMillisecond(Calendar calendar) {
        return this.getFirstMillisecond(calendar);
    }
}

