/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;

public class Hour
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = -835471579831937652L;
    public static final int FIRST_HOUR_IN_DAY = 0;
    public static final int LAST_HOUR_IN_DAY = 23;
    private Day day;
    private byte hour;
    private long firstMillisecond;
    private long lastMillisecond;

    public Hour() {
        this(new Date());
    }

    public Hour(int n2, Day day) {
        ParamChecks.nullNotPermitted(day, "day");
        this.hour = (byte)n2;
        this.day = day;
        this.peg(Calendar.getInstance());
    }

    public Hour(int n2, int n3, int n4, int n5) {
        this(n2, new Day(n3, n4, n5));
    }

    public Hour(Date date) {
        this(date, TimeZone.getDefault(), Locale.getDefault());
    }

    public Hour(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Hour(Date date, TimeZone timeZone, Locale locale) {
        ParamChecks.nullNotPermitted(date, "time");
        ParamChecks.nullNotPermitted(timeZone, "zone");
        ParamChecks.nullNotPermitted(locale, "locale");
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        this.hour = (byte)calendar.get(11);
        this.day = new Day(date, timeZone, locale);
        this.peg(calendar);
    }

    public int getHour() {
        return this.hour;
    }

    public Day getDay() {
        return this.day;
    }

    public int getYear() {
        return this.day.getYear();
    }

    public int getMonth() {
        return this.day.getMonth();
    }

    public int getDayOfMonth() {
        return this.day.getDayOfMonth();
    }

    @Override
    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    @Override
    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    @Override
    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    @Override
    public RegularTimePeriod previous() {
        Day day;
        Hour hour = this.hour != 0 ? new Hour(this.hour - 1, this.day) : ((day = (Day)this.day.previous()) != null ? new Hour(23, day) : null);
        return hour;
    }

    @Override
    public RegularTimePeriod next() {
        Day day;
        Hour hour = this.hour != 23 ? new Hour(this.hour + 1, this.day) : ((day = (Day)this.day.next()) != null ? new Hour(0, day) : null);
        return hour;
    }

    @Override
    public long getSerialIndex() {
        return this.day.getSerialIndex() * 24L + (long)this.hour;
    }

    @Override
    public long getFirstMillisecond(Calendar calendar) {
        int n2 = this.day.getYear();
        int n3 = this.day.getMonth() - 1;
        int n4 = this.day.getDayOfMonth();
        calendar.set(n2, n3, n4, this.hour, 0, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public long getLastMillisecond(Calendar calendar) {
        int n2 = this.day.getYear();
        int n3 = this.day.getMonth() - 1;
        int n4 = this.day.getDayOfMonth();
        calendar.set(n2, n3, n4, this.hour, 59, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Hour)) {
            return false;
        }
        Hour hour = (Hour)object;
        if (this.hour != hour.hour) {
            return false;
        }
        return this.day.equals(hour.day);
    }

    @Override
    public String toString() {
        return "[" + this.hour + "," + this.getDayOfMonth() + "/" + this.getMonth() + "/" + this.getYear() + "]";
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.hour;
        n2 = 37 * n2 + this.day.hashCode();
        return n2;
    }

    public int compareTo(Object object) {
        int n2;
        if (object instanceof Hour) {
            Hour hour = (Hour)object;
            n2 = this.getDay().compareTo(hour.getDay());
            if (n2 == 0) {
                n2 = this.hour - hour.getHour();
            }
        } else {
            n2 = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n2;
    }

    public static Hour parseHour(String string) {
        Hour hour = null;
        String string2 = (string = string.trim()).substring(0, Math.min(10, string.length()));
        Day day = Day.parseDay(string2);
        if (day != null) {
            String string3 = string.substring(Math.min(string2.length() + 1, string.length()), string.length());
            int n2 = Integer.parseInt(string3 = string3.trim());
            if (n2 >= 0 && n2 <= 23) {
                hour = new Hour(n2, day);
            }
        }
        return hour;
    }
}

