/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.jfree.data.time.RegularTimePeriod;

public class FixedMillisecond
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = 7867521484545646931L;
    private long time;

    public FixedMillisecond() {
        this(new Date());
    }

    public FixedMillisecond(long l2) {
        this(new Date(l2));
    }

    public FixedMillisecond(Date date) {
        this.time = date.getTime();
    }

    public Date getTime() {
        return new Date(this.time);
    }

    @Override
    public void peg(Calendar calendar) {
    }

    @Override
    public RegularTimePeriod previous() {
        FixedMillisecond fixedMillisecond = null;
        long l2 = this.time;
        if (l2 != Long.MIN_VALUE) {
            fixedMillisecond = new FixedMillisecond(l2 - 1L);
        }
        return fixedMillisecond;
    }

    @Override
    public RegularTimePeriod next() {
        FixedMillisecond fixedMillisecond = null;
        long l2 = this.time;
        if (l2 != Long.MAX_VALUE) {
            fixedMillisecond = new FixedMillisecond(l2 + 1L);
        }
        return fixedMillisecond;
    }

    public boolean equals(Object object) {
        if (object instanceof FixedMillisecond) {
            FixedMillisecond fixedMillisecond = (FixedMillisecond)object;
            return this.time == fixedMillisecond.getFirstMillisecond();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.time;
    }

    public int compareTo(Object object) {
        int n2;
        if (object instanceof FixedMillisecond) {
            FixedMillisecond fixedMillisecond = (FixedMillisecond)object;
            long l2 = this.time - fixedMillisecond.time;
            n2 = l2 > 0L ? 1 : (l2 < 0L ? -1 : 0);
        } else {
            n2 = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n2;
    }

    @Override
    public long getFirstMillisecond() {
        return this.time;
    }

    @Override
    public long getFirstMillisecond(Calendar calendar) {
        return this.time;
    }

    @Override
    public long getLastMillisecond() {
        return this.time;
    }

    @Override
    public long getLastMillisecond(Calendar calendar) {
        return this.time;
    }

    @Override
    public long getMiddleMillisecond() {
        return this.time;
    }

    @Override
    public long getMiddleMillisecond(Calendar calendar) {
        return this.time;
    }

    @Override
    public long getSerialIndex() {
        return this.time;
    }
}

