/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;

public abstract class Statistics {
    public static double calculateMean(Number[] numberArray) {
        return Statistics.calculateMean(numberArray, true);
    }

    public static double calculateMean(Number[] numberArray, boolean bl2) {
        ParamChecks.nullNotPermitted(numberArray, "values");
        double d2 = 0.0;
        int n2 = 0;
        for (int i2 = 0; i2 < numberArray.length; ++i2) {
            double d3 = numberArray[i2] != null ? numberArray[i2].doubleValue() : Double.NaN;
            if (!bl2 && Double.isNaN(d3)) continue;
            d2 += d3;
            ++n2;
        }
        double d4 = d2 / (double)n2;
        return d4;
    }

    public static double calculateMean(Collection collection) {
        return Statistics.calculateMean(collection, true);
    }

    public static double calculateMean(Collection collection, boolean bl2) {
        ParamChecks.nullNotPermitted(collection, "values");
        int n2 = 0;
        double d2 = 0.0;
        for (Object e2 : collection) {
            if (e2 == null) {
                if (!bl2) continue;
                return Double.NaN;
            }
            if (!(e2 instanceof Number)) continue;
            Number number = (Number)e2;
            double d3 = number.doubleValue();
            if (Double.isNaN(d3)) {
                if (!bl2) continue;
                return Double.NaN;
            }
            d2 += number.doubleValue();
            ++n2;
        }
        return d2 / (double)n2;
    }

    public static double calculateMedian(List list) {
        return Statistics.calculateMedian(list, true);
    }

    public static double calculateMedian(List arrayList, boolean bl2) {
        double d2 = Double.NaN;
        if (arrayList != null) {
            Serializable serializable;
            int n2;
            if (bl2) {
                n2 = arrayList.size();
                serializable = new ArrayList(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    serializable.add(i2, arrayList.get(i2));
                }
                Collections.sort(serializable);
                arrayList = serializable;
            }
            if ((n2 = arrayList.size()) > 0) {
                if (n2 % 2 == 1) {
                    if (n2 > 1) {
                        serializable = (Number)arrayList.get((n2 - 1) / 2);
                        d2 = ((Number)serializable).doubleValue();
                    } else {
                        serializable = (Number)arrayList.get(0);
                        d2 = ((Number)serializable).doubleValue();
                    }
                } else {
                    serializable = (Number)arrayList.get(n2 / 2 - 1);
                    Number number = (Number)arrayList.get(n2 / 2);
                    d2 = (((Number)serializable).doubleValue() + number.doubleValue()) / 2.0;
                }
            }
        }
        return d2;
    }

    public static double calculateMedian(List list, int n2, int n3) {
        return Statistics.calculateMedian(list, n2, n3, true);
    }

    public static double calculateMedian(List list, int n2, int n3, boolean bl2) {
        double d2 = Double.NaN;
        if (bl2) {
            ArrayList arrayList = new ArrayList(n3 - n2 + 1);
            for (int i2 = n2; i2 <= n3; ++i2) {
                arrayList.add(list.get(i2));
            }
            Collections.sort(arrayList);
            d2 = Statistics.calculateMedian(arrayList, false);
        } else {
            int n4 = n3 - n2 + 1;
            if (n4 > 0) {
                if (n4 % 2 == 1) {
                    if (n4 > 1) {
                        Number number = (Number)list.get(n2 + (n4 - 1) / 2);
                        d2 = number.doubleValue();
                    } else {
                        Number number = (Number)list.get(n2);
                        d2 = number.doubleValue();
                    }
                } else {
                    Number number = (Number)list.get(n2 + n4 / 2 - 1);
                    Number number2 = (Number)list.get(n2 + n4 / 2);
                    d2 = (number.doubleValue() + number2.doubleValue()) / 2.0;
                }
            }
        }
        return d2;
    }

    public static double getStdDev(Number[] numberArray) {
        ParamChecks.nullNotPermitted(numberArray, "data");
        if (numberArray.length == 0) {
            throw new IllegalArgumentException("Zero length 'data' array.");
        }
        double d2 = Statistics.calculateMean(numberArray);
        double d3 = 0.0;
        for (int i2 = 0; i2 < numberArray.length; ++i2) {
            double d4 = numberArray[i2].doubleValue() - d2;
            d3 += d4 * d4;
        }
        return Math.sqrt(d3 / (double)(numberArray.length - 1));
    }

    public static double[] getLinearFit(Number[] numberArray, Number[] numberArray2) {
        ParamChecks.nullNotPermitted(numberArray, "xData");
        ParamChecks.nullNotPermitted(numberArray2, "yData");
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getLinearFit(): array lengths must be equal.");
        }
        double[] dArray = new double[2];
        dArray[1] = Statistics.getSlope(numberArray, numberArray2);
        dArray[0] = Statistics.calculateMean(numberArray2) - dArray[1] * Statistics.calculateMean(numberArray);
        return dArray;
    }

    public static double getSlope(Number[] numberArray, Number[] numberArray2) {
        int n2;
        ParamChecks.nullNotPermitted(numberArray, "xData");
        ParamChecks.nullNotPermitted(numberArray2, "yData");
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Array lengths must be equal.");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n2 = 0; n2 < numberArray.length; ++n2) {
            d2 += numberArray[n2].doubleValue();
            d3 += Math.pow(numberArray[n2].doubleValue(), 2.0);
            d4 += numberArray2[n2].doubleValue() * numberArray[n2].doubleValue();
            d5 += numberArray2[n2].doubleValue();
        }
        return (d4 - d2 * d5 / (double)n2) / (d3 - d2 * d2 / (double)n2);
    }

    public static double getCorrelation(Number[] numberArray, Number[] numberArray2) {
        ParamChecks.nullNotPermitted(numberArray, "data1");
        ParamChecks.nullNotPermitted(numberArray2, "data2");
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("'data1' and 'data2' arrays must have same length.");
        }
        int n2 = numberArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d7 = 0.0;
            if (numberArray[i2] != null) {
                d7 = numberArray[i2].doubleValue();
            }
            double d8 = 0.0;
            if (numberArray2[i2] != null) {
                d8 = numberArray2[i2].doubleValue();
            }
            d2 += d7;
            d3 += d8;
            d6 += d7 * d8;
            d4 += d7 * d7;
            d5 += d8 * d8;
        }
        return ((double)n2 * d6 - d2 * d3) / Math.pow(((double)n2 * d4 - d2 * d2) * ((double)n2 * d5 - d3 * d3), 0.5);
    }

    public static double[][] getMovingAverage(Number[] numberArray, Number[] numberArray2, int n2) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Array lengths must be equal.");
        }
        if (n2 > numberArray.length) {
            throw new IllegalArgumentException("Period can't be longer than dataset.");
        }
        double[][] dArray = new double[numberArray.length - n2][2];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2][0] = numberArray[i2 + n2].doubleValue();
            double d2 = 0.0;
            for (int i3 = 0; i3 < n2; ++i3) {
                d2 += numberArray2[i2 + i3].doubleValue();
            }
            dArray[i2][1] = d2 /= (double)n2;
        }
        return dArray;
    }
}

