/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;

public abstract class Regression {
    public static double[] getOLSRegression(double[][] dArray) {
        int n2 = dArray.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d6 = dArray[i2][0];
            double d7 = dArray[i2][1];
            d2 += d6;
            d3 += d7;
            double d8 = d6 * d6;
            d4 += d8;
            double d9 = d6 * d7;
            d5 += d9;
        }
        double d10 = d4 - d2 * d2 / (double)n2;
        double d11 = d5 - d2 * d3 / (double)n2;
        double d12 = d2 / (double)n2;
        double d13 = d3 / (double)n2;
        double[] dArray2 = new double[2];
        dArray2[1] = d11 / d10;
        dArray2[0] = d13 - dArray2[1] * d12;
        return dArray2;
    }

    public static double[] getOLSRegression(XYDataset xYDataset, int n2) {
        int n3 = xYDataset.getItemCount(n2);
        if (n3 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            double d6 = xYDataset.getXValue(n2, i2);
            double d7 = xYDataset.getYValue(n2, i2);
            d2 += d6;
            d3 += d7;
            double d8 = d6 * d6;
            d4 += d8;
            double d9 = d6 * d7;
            d5 += d9;
        }
        double d10 = d4 - d2 * d2 / (double)n3;
        double d11 = d5 - d2 * d3 / (double)n3;
        double d12 = d2 / (double)n3;
        double d13 = d3 / (double)n3;
        double[] dArray = new double[2];
        dArray[1] = d11 / d10;
        dArray[0] = d13 - dArray[1] * d12;
        return dArray;
    }

    public static double[] getPowerRegression(double[][] dArray) {
        int n2 = dArray.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d6 = Math.log(dArray[i2][0]);
            double d7 = Math.log(dArray[i2][1]);
            d2 += d6;
            d3 += d7;
            double d8 = d6 * d6;
            d4 += d8;
            double d9 = d6 * d7;
            d5 += d9;
        }
        double d10 = d4 - d2 * d2 / (double)n2;
        double d11 = d5 - d2 * d3 / (double)n2;
        double d12 = d2 / (double)n2;
        double d13 = d3 / (double)n2;
        double[] dArray2 = new double[2];
        dArray2[1] = d11 / d10;
        dArray2[0] = Math.pow(Math.exp(1.0), d13 - dArray2[1] * d12);
        return dArray2;
    }

    public static double[] getPowerRegression(XYDataset xYDataset, int n2) {
        int n3 = xYDataset.getItemCount(n2);
        if (n3 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            double d6 = Math.log(xYDataset.getXValue(n2, i2));
            double d7 = Math.log(xYDataset.getYValue(n2, i2));
            d2 += d6;
            d3 += d7;
            double d8 = d6 * d6;
            d4 += d8;
            double d9 = d6 * d7;
            d5 += d9;
        }
        double d10 = d4 - d2 * d2 / (double)n3;
        double d11 = d5 - d2 * d3 / (double)n3;
        double d12 = d2 / (double)n3;
        double d13 = d3 / (double)n3;
        double[] dArray = new double[2];
        dArray[1] = d11 / d10;
        dArray[0] = Math.pow(Math.exp(1.0), d13 - dArray[1] * d12);
        return dArray;
    }

    public static double[] getPolynomialRegression(XYDataset xYDataset, int n2, int n3) {
        double d2;
        int n4;
        int n5;
        int n6;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        int n7 = xYDataset.getItemCount(n2);
        if (n7 < n3 + 1) {
            throw new IllegalArgumentException("Not enough data.");
        }
        int n8 = 0;
        double[][] dArray = new double[2][n7];
        for (n6 = 0; n6 < n7; ++n6) {
            double d3 = xYDataset.getXValue(n2, n6);
            double d4 = xYDataset.getYValue(n2, n6);
            if (Double.isNaN(d3) || Double.isNaN(d4)) continue;
            dArray[0][n8] = d3;
            dArray[1][n8] = d4;
            ++n8;
        }
        if (n8 < n3 + 1) {
            throw new IllegalArgumentException("Not enough data.");
        }
        n6 = n3 + 1;
        int n9 = n3 + 2;
        double[] dArray2 = new double[n6 + 1];
        double[][] dArray3 = new double[n6][n9];
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i2 = 0; i2 < n8; ++i2) {
            d5 += dArray[0][i2];
            d6 += dArray[1][i2];
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n9 - 1; ++n4) {
                    double[] dArray4 = dArray3[n5];
                    int n10 = n4;
                    dArray4[n10] = dArray4[n10] + Math.pow(dArray[0][i2], n5 + n4);
                }
                double[] dArray5 = dArray3[n5];
                int n11 = n9 - 1;
                dArray5[n11] = dArray5[n11] + dArray[1][i2] * Math.pow(dArray[0][i2], n5);
            }
        }
        double[][] dArray6 = Regression.calculateSubMatrix(dArray3);
        for (n5 = 1; n5 < n6; ++n5) {
            dArray3[n5][0] = 0.0;
            for (n4 = 1; n4 < n9; ++n4) {
                dArray3[n5][n4] = dArray6[n5 - 1][n4 - 1];
            }
        }
        for (n5 = n6 - 1; n5 > -1; --n5) {
            double d7 = dArray3[n5][n9 - 1];
            for (int i3 = n5; i3 < n9 - 1; ++i3) {
                d7 -= dArray3[n5][i3] * dArray2[i3];
            }
            dArray2[n5] = d7 / dArray3[n5][n5];
        }
        double d8 = d6 / (double)n8;
        double d9 = 0.0;
        double d10 = 0.0;
        for (int i4 = 0; i4 < n8; ++i4) {
            double d11 = 0.0;
            for (int i5 = 0; i5 < n6; ++i5) {
                d11 += dArray2[i5] * Math.pow(dArray[0][i4], i5);
            }
            d10 += Math.pow(d11 - d8, 2.0);
            d9 += Math.pow(dArray[1][i4] - d8, 2.0);
        }
        dArray2[n6] = d2 = d10 / d9;
        return dArray2;
    }

    private static double[][] calculateSubMatrix(double[][] dArray) {
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[][] dArray2 = new double[n3 - 1][n4 - 1];
        for (n2 = 1; n2 < n3; ++n2) {
            double d2 = dArray[0][0] / dArray[n2][0];
            for (int i2 = 1; i2 < n4; ++i2) {
                dArray2[n2 - 1][i2 - 1] = dArray[0][i2] - dArray[n2][i2] * d2;
            }
        }
        if (n3 == 1) {
            return dArray2;
        }
        if (dArray2[0][0] == 0.0) {
            n2 = 0;
            for (int i3 = 0; i3 < dArray2.length; ++i3) {
                if (dArray2[i3][0] == 0.0) continue;
                n2 = 1;
                double[] dArray3 = dArray2[0];
                System.arraycopy(dArray2[i3], 0, dArray2[0], 0, dArray2[i3].length);
                System.arraycopy(dArray3, 0, dArray2[i3], 0, dArray3.length);
                break;
            }
            if (n2 == 0) {
                return new double[n3 - 1][n4 - 1];
            }
        }
        double[][] dArray4 = Regression.calculateSubMatrix(dArray2);
        for (int i4 = 1; i4 < n3 - 1; ++i4) {
            dArray2[i4][0] = 0.0;
            for (int i5 = 1; i5 < n4 - 1; ++i5) {
                dArray2[i4][i5] = dArray4[i4 - 1][i5 - 1];
            }
        }
        return dArray2;
    }
}

