/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import org.jfree.util.ObjectUtilities;

public class MeanAndStandardDeviation
implements Serializable {
    private static final long serialVersionUID = 7413468697315721515L;
    private Number mean;
    private Number standardDeviation;

    public MeanAndStandardDeviation(double d2, double d3) {
        this(new Double(d2), new Double(d3));
    }

    public MeanAndStandardDeviation(Number number, Number number2) {
        this.mean = number;
        this.standardDeviation = number2;
    }

    public Number getMean() {
        return this.mean;
    }

    public double getMeanValue() {
        double d2 = Double.NaN;
        if (this.mean != null) {
            d2 = this.mean.doubleValue();
        }
        return d2;
    }

    public Number getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getStandardDeviationValue() {
        double d2 = Double.NaN;
        if (this.standardDeviation != null) {
            d2 = this.standardDeviation.doubleValue();
        }
        return d2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MeanAndStandardDeviation)) {
            return false;
        }
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)object;
        if (!ObjectUtilities.equal(this.mean, meanAndStandardDeviation.mean)) {
            return false;
        }
        return ObjectUtilities.equal(this.standardDeviation, meanAndStandardDeviation.standardDeviation);
    }

    public String toString() {
        return "[" + this.mean + ", " + this.standardDeviation + "]";
    }
}

